/*
 * Decompiled with CFR 0.152.
 */
package net.soundvibe.reacto.server;

import io.reactivex.Flowable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.soundvibe.reacto.client.commands.CommandExecutor;
import net.soundvibe.reacto.errors.CommandAlreadyRegistered;
import net.soundvibe.reacto.mappers.CommandRegistryMapper;
import net.soundvibe.reacto.types.Command;
import net.soundvibe.reacto.types.CommandDescriptor;
import net.soundvibe.reacto.types.Pair;

public final class CommandRegistry
implements Iterable<Pair<CommandDescriptor, CommandExecutor>> {
    private final Map<CommandDescriptor, CommandExecutor> commands = new ConcurrentHashMap<CommandDescriptor, CommandExecutor>();
    private final CommandRegistryMapper mapper;

    private CommandRegistry() {
        this.mapper = null;
    }

    private CommandRegistry(CommandRegistryMapper mapper) {
        this.mapper = mapper;
    }

    public CommandRegistry and(String commandName, CommandExecutor onInvoke) {
        Objects.requireNonNull(commandName, "Command name cannot be null");
        Objects.requireNonNull(onInvoke, "onInvoke cannot be null");
        this.add(CommandDescriptor.of(commandName), onInvoke);
        return this;
    }

    public <C, E> CommandRegistry and(Class<C> commandType, Class<? extends E> eventType, Function<C, Flowable<? extends E>> onInvoke) {
        Objects.requireNonNull(commandType, "commandType name cannot be null");
        Objects.requireNonNull(eventType, "eventType name cannot be null");
        Objects.requireNonNull(onInvoke, "onInvoke cannot be null");
        Objects.requireNonNull(this.mapper, "mapper cannot be null");
        Function<Command, Flowable<E>> before = onInvoke.compose(c -> this.mapper.toGenericCommand((Command)c, commandType));
        Function<Command, Flowable> after = before.andThen(observable -> observable.map(this.mapper::toEvent));
        this.add(CommandDescriptor.ofTypes(commandType, eventType), after::apply);
        return this;
    }

    private void add(CommandDescriptor descriptor, CommandExecutor onInvoke) {
        if (this.commands.containsKey(descriptor)) {
            throw new CommandAlreadyRegistered(descriptor);
        }
        this.commands.put(descriptor, onInvoke);
    }

    public static CommandRegistry typed(CommandRegistryMapper mapper) {
        return new CommandRegistry(mapper);
    }

    public static CommandRegistry untyped() {
        return new CommandRegistry();
    }

    public static CommandRegistry of(String commandName, CommandExecutor onInvoke) {
        return CommandRegistry.untyped().and(commandName, onInvoke);
    }

    public static <C, E> CommandRegistry ofTyped(Class<C> commandType, Class<? extends E> eventType, Function<C, Flowable<? extends E>> onInvoke, CommandRegistryMapper mapper) {
        return CommandRegistry.typed(mapper).and(commandType, eventType, onInvoke);
    }

    public static CommandRegistry empty() {
        return new CommandRegistry();
    }

    public boolean isEmpty() {
        return this.commands.isEmpty();
    }

    public Optional<CommandExecutor> findCommand(CommandDescriptor descriptor) {
        return Optional.ofNullable(this.commands.get(descriptor));
    }

    public Stream<Pair<CommandDescriptor, CommandExecutor>> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public Stream<CommandDescriptor> streamOfKeys() {
        return this.stream().map(Pair::getKey);
    }

    public String toString() {
        return "CommandRegistry{commands=" + this.commands + ", mapper=" + this.mapper + '}';
    }

    @Override
    public Iterator<Pair<CommandDescriptor, CommandExecutor>> iterator() {
        final Iterator<Map.Entry<CommandDescriptor, CommandExecutor>> entryIterator = this.commands.entrySet().iterator();
        return new Iterator<Pair<CommandDescriptor, CommandExecutor>>(){

            @Override
            public boolean hasNext() {
                return entryIterator.hasNext();
            }

            @Override
            public Pair<CommandDescriptor, CommandExecutor> next() {
                Map.Entry entry = (Map.Entry)entryIterator.next();
                return Pair.of((CommandDescriptor)entry.getKey(), (CommandExecutor)entry.getValue());
            }
        };
    }
}

