/*
 * Decompiled with CFR 0.152.
 */
package net.soundvibe.reacto.types;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import net.soundvibe.reacto.internal.ObjectId;
import net.soundvibe.reacto.types.MetaData;
import net.soundvibe.reacto.types.Pair;
import net.soundvibe.reacto.utils.Bytes;

public class Command {
    public final ObjectId id;
    public final String name;
    public final Optional<MetaData> metaData;
    public final Optional<byte[]> payload;

    public Command(ObjectId id, String name, Optional<MetaData> metaData, Optional<byte[]> payload) {
        this.id = id;
        this.name = name;
        this.metaData = metaData;
        this.payload = payload;
    }

    public String get(String key) {
        return this.metaData.map(pairs -> pairs.get(key)).orElse(null);
    }

    public Optional<String> valueOf(String key) {
        return this.metaData.flatMap(pairs -> pairs.valueOf(key));
    }

    public String eventType() {
        return this.valueOf("eventType").orElse("");
    }

    public static Command create(String name, Optional<MetaData> metaData, Optional<byte[]> payload) {
        return new Command(ObjectId.get(), name, metaData, payload);
    }

    public static Command create(String name) {
        Objects.requireNonNull(name, "name cannot be null");
        return new Command(ObjectId.get(), name, Optional.empty(), Optional.empty());
    }

    public static Command create(String name, MetaData metaData) {
        Objects.requireNonNull(name, "name cannot be null");
        Objects.requireNonNull(metaData, "metaData cannot be null");
        return new Command(ObjectId.get(), name, Optional.of(metaData), Optional.empty());
    }

    @SafeVarargs
    public static Command create(String name, Pair<String, String> ... pairs) {
        Objects.requireNonNull(name, "name cannot be null");
        Objects.requireNonNull(pairs, "pairs cannot be null");
        return new Command(ObjectId.get(), name, Optional.of(MetaData.from(pairs)), Optional.empty());
    }

    public static Command create(String name, MetaData metaData, byte[] payload) {
        Objects.requireNonNull(name, "name cannot be null");
        Objects.requireNonNull(metaData, "metaData cannot be null");
        Objects.requireNonNull(payload, "payload cannot be null");
        return new Command(ObjectId.get(), name, Optional.of(metaData), Optional.of(payload));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Command command = (Command)o;
        return Objects.equals(this.id, command.id) && Objects.equals(this.name, command.name) && Objects.equals(this.metaData, command.metaData) && Bytes.payloadsAreEqual(this.payload, command.payload);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.metaData, this.payload.map(Arrays::hashCode).orElse(0));
    }

    public String toString() {
        return "Command{id=" + this.id + ", name='" + this.name + '\'' + ", metaData=" + this.metaData + ", payload=" + this.payload + '}';
    }
}

