/*
 * Decompiled with CFR 0.152.
 */
package net.soundvibe.reacto.types;

import java.util.Objects;
import net.soundvibe.reacto.types.Command;

public final class CommandDescriptor {
    public static final String COMMAND = "commandType";
    public static final String EVENT = "eventType";
    public final String commandType;
    public final String eventType;

    private CommandDescriptor(String commandType, String eventType) {
        Objects.requireNonNull(commandType, "commandType cannot be null");
        Objects.requireNonNull(eventType, "eventType cannot be null");
        this.commandType = commandType;
        this.eventType = eventType;
    }

    public static CommandDescriptor of(String commandName) {
        return new CommandDescriptor(commandName, "");
    }

    public static CommandDescriptor ofTypes(Class<?> commandType, Class<?> eventType) {
        Objects.requireNonNull(commandType, "commandType cannot be null");
        Objects.requireNonNull(eventType, "eventType cannot be null");
        return new CommandDescriptor(commandType.getName(), eventType.getName());
    }

    public static CommandDescriptor fromCommand(Command receivedCommand) {
        return new CommandDescriptor(receivedCommand.name, receivedCommand.eventType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandDescriptor that = (CommandDescriptor)o;
        return Objects.equals(this.commandType, that.commandType) && Objects.equals(this.eventType, that.eventType);
    }

    public int hashCode() {
        return Objects.hash(this.commandType, this.eventType);
    }

    public String toString() {
        return "CommandDescriptor{commandType='" + this.commandType + '\'' + ", eventType='" + this.eventType + '\'' + '}';
    }
}

