/*
 * Decompiled with CFR 0.152.
 */
package net.soundvibe.reacto.types;

import io.reactivex.Flowable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import net.soundvibe.reacto.types.MetaData;
import net.soundvibe.reacto.types.Pair;
import net.soundvibe.reacto.utils.Bytes;

public class Event {
    public final String name;
    public final Optional<MetaData> metaData;
    public final Optional<byte[]> payload;

    Event(String name, Optional<MetaData> metaData, Optional<byte[]> payload) {
        this.name = name;
        this.metaData = metaData;
        this.payload = payload;
    }

    public String get(String key) {
        return this.metaData.map(pairs -> pairs.get(key)).orElse(null);
    }

    public Optional<String> valueOf(String key) {
        return this.metaData.flatMap(pairs -> pairs.valueOf(key));
    }

    public Flowable<Event> toObservable() {
        return Flowable.just((Object)this);
    }

    public static Event create(String name) {
        return new Event(name, Optional.empty(), Optional.empty());
    }

    @SafeVarargs
    public static Event create(String name, Pair<String, String> ... metaDataPairs) {
        return new Event(name, Optional.of(MetaData.from(metaDataPairs)), Optional.empty());
    }

    public static Event create(String name, MetaData metaData) {
        return new Event(name, Optional.ofNullable(metaData), Optional.empty());
    }

    public static Event create(String name, byte[] payload) {
        return new Event(name, Optional.empty(), Optional.ofNullable(payload));
    }

    public static Event create(String name, MetaData metaData, byte[] payload) {
        return new Event(name, Optional.ofNullable(metaData), Optional.ofNullable(payload));
    }

    public static Event create(String name, Optional<MetaData> metaData, Optional<byte[]> payload) {
        return new Event(name, metaData, payload);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        return Objects.equals(this.name, event.name) && Objects.equals(this.metaData, event.metaData) && Bytes.payloadsAreEqual(this.payload, event.payload);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.metaData, this.payload.map(Arrays::hashCode).orElse(0));
    }

    public String toString() {
        return "Event{name='" + this.name + '\'' + ", metaData=" + this.metaData + ", payload=" + this.payload + '}';
    }
}

