/*
 * Decompiled with CFR 0.152.
 */
package net.soundvibe.reacto.types;

import java.util.Objects;
import java.util.Optional;
import net.soundvibe.reacto.internal.ObjectId;
import net.soundvibe.reacto.types.Command;
import net.soundvibe.reacto.types.MetaData;

public final class TypedCommand
extends Command {
    private TypedCommand(ObjectId id, String name, Optional<MetaData> metaData, Optional<byte[]> payload) {
        super(id, name, metaData, payload);
    }

    public static TypedCommand create(Class<?> commandType, Class<?> eventType, byte[] serializedCommand) {
        Objects.requireNonNull(commandType, "commandType cannot be null");
        Objects.requireNonNull(eventType, "eventType cannot be null");
        Objects.requireNonNull(serializedCommand, "serializedCommand cannot be null");
        return new TypedCommand(ObjectId.get(), commandType.getName(), Optional.of(MetaData.of("eventType", eventType.getName())), Optional.of(serializedCommand));
    }

    public static TypedCommand create(Class<?> commandType, Class<?> eventType, MetaData metaData) {
        Objects.requireNonNull(commandType, "commandType cannot be null");
        Objects.requireNonNull(eventType, "eventType cannot be null");
        Objects.requireNonNull(metaData, "metaData cannot be null");
        return new TypedCommand(ObjectId.get(), commandType.getName(), Optional.of(MetaData.of("eventType", eventType.getName()).concat(metaData)), Optional.empty());
    }

    public static TypedCommand create(Class<?> commandType, Class<?> eventType, MetaData metaData, byte[] serializedCommand) {
        Objects.requireNonNull(commandType, "commandType cannot be null");
        Objects.requireNonNull(eventType, "eventType cannot be null");
        Objects.requireNonNull(metaData, "metaData cannot be null");
        Objects.requireNonNull(serializedCommand, "serializedCommand cannot be null");
        return new TypedCommand(ObjectId.get(), commandType.getName(), Optional.of(MetaData.of("eventType", eventType.getName()).concat(metaData)), Optional.of(serializedCommand));
    }

    public String commandType() {
        return this.name;
    }

    @Override
    public String eventType() {
        return this.get("eventType");
    }
}

