/*
 * Decompiled with CFR 0.152.
 */
package net.soundvibe.reacto.types.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.soundvibe.reacto.mappers.jackson.JacksonMapper;
import net.soundvibe.reacto.types.json.JsonObject;

public final class JsonArray
implements Iterable<Object> {
    final List<Object> values;
    private static final JsonArray EMPTY = new JsonArray(Collections.emptyList());

    public JsonArray(List<Object> values) {
        this.values = values;
    }

    public static JsonArray empty() {
        return EMPTY;
    }

    public static JsonArray fromJson(String jsonString) {
        return JacksonMapper.fromJson(jsonString, JsonArray.class);
    }

    public <T> Optional<T> valueOf(int index, Class<T> valueClass) {
        if (Enum.class.isAssignableFrom(valueClass)) {
            return this.asEnum(index, valueClass).map(anEnum -> anEnum);
        }
        if (Instant.class.isAssignableFrom(valueClass)) {
            return this.asInstant(index).map(instant -> instant);
        }
        if (byte[].class.isAssignableFrom(valueClass)) {
            return this.asBytes(index).map(bytes -> bytes);
        }
        return Optional.ofNullable(this.values.get(index)).flatMap(o -> valueClass.isInstance(o) ? Optional.of(valueClass.cast(o)) : Optional.empty());
    }

    public Optional<String> asString(int index) {
        return this.valueOf(index, String.class);
    }

    public Optional<Integer> asInteger(int index) {
        return this.valueOf(index, Integer.class);
    }

    public Optional<Long> asLong(int index) {
        return this.valueOf(index, Long.class);
    }

    public Optional<Double> asDouble(int index) {
        return this.valueOf(index, Double.class);
    }

    public Optional<Boolean> asBoolean(int index) {
        return this.valueOf(index, Boolean.class);
    }

    public Optional<Number> asNumber(int index) {
        return this.valueOf(index, Number.class);
    }

    public Optional<byte[]> asBytes(int index) {
        return this.valueOf(index, String.class).map(s -> Base64.getDecoder().decode((String)s));
    }

    public Optional<Instant> asInstant(int index) {
        return this.valueOf(index, String.class).map(s -> Instant.from(DateTimeFormatter.ISO_INSTANT.parse((CharSequence)s)));
    }

    public Optional<JsonArray> asArray(int index) {
        return Optional.ofNullable(this.values.get(index)).flatMap(o -> o instanceof List ? Optional.of(new JsonArray((List)o)) : (o instanceof JsonArray ? Optional.of((JsonArray)o) : Optional.empty()));
    }

    public Optional<JsonObject> asObject(int index) {
        return Optional.ofNullable(this.values.get(index)).flatMap(o -> o instanceof Map ? Optional.of(new JsonObject((Map)o)) : (o instanceof JsonObject ? Optional.of((JsonObject)o) : Optional.empty()));
    }

    public <T extends Enum<T>> Optional<T> asEnum(int index, Class<T> enumClass) {
        return this.valueOf(index, String.class).map(name -> Enum.valueOf(enumClass, name));
    }

    public int size() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public boolean hasElements() {
        return !this.isEmpty();
    }

    public Stream<Object> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public Stream<Object> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    public List<Object> toList() {
        return new ArrayList<Object>(this.values);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof List) {
            List list = (List)o;
            return Objects.equals(this.values, list);
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        JsonArray objects = (JsonArray)o;
        return Objects.equals(this.values, objects.values);
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    @Override
    public Iterator<Object> iterator() {
        return new JsonArrayIterator(this.values.iterator());
    }

    public String toString() {
        return this.values.toString();
    }

    public String toJson() {
        return JacksonMapper.toJson(this);
    }

    public static class JsonArrayDeserializer
    extends JsonDeserializer<JsonArray> {
        private static final JavaType listType = TypeFactory.defaultInstance().constructCollectionType(ArrayList.class, Object.class);

        public JsonArray deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return new JsonArray((List)ctxt.readValue(p, listType));
        }
    }

    public static class JsonArraySerializer
    extends JsonSerializer<JsonArray> {
        public void serialize(JsonArray value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeObject(value.values);
        }
    }

    private class JsonArrayIterator
    implements Iterator<Object> {
        private final Iterator<Object> listIterator;

        JsonArrayIterator(Iterator<Object> listIterator) {
            this.listIterator = listIterator;
        }

        @Override
        public boolean hasNext() {
            return this.listIterator.hasNext();
        }

        @Override
        public Object next() {
            Object next = this.listIterator.next();
            if (next instanceof Map) {
                next = new JsonObject((Map)next);
            } else if (next instanceof List) {
                next = new JsonArray((List)next);
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

