/*
 * Decompiled with CFR 0.152.
 */
package net.soundvibe.reacto.types.json;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import net.soundvibe.reacto.types.json.JsonArray;
import net.soundvibe.reacto.types.json.JsonObject;
import net.soundvibe.reacto.types.json.JsonObjectBuilder;

public final class JsonArrayBuilder {
    private final List<Object> values;

    private JsonArrayBuilder(List<Object> list) {
        Objects.requireNonNull(list, "list cannot be null");
        this.values = list;
    }

    private JsonArrayBuilder(JsonArray jsonArray) {
        Objects.requireNonNull(jsonArray, "jsonArray cannot be null");
        this.values = new ArrayList<Object>(jsonArray.values);
    }

    public static JsonArrayBuilder create() {
        return new JsonArrayBuilder(new ArrayList<Object>());
    }

    public static JsonArrayBuilder from(JsonArray jsonArray) {
        return new JsonArrayBuilder(jsonArray);
    }

    public JsonArray build() {
        return new JsonArray(this.values);
    }

    public JsonArrayBuilder add(CharSequence value) {
        return this.addValue(value == null ? null : value.toString());
    }

    public JsonArrayBuilder add(JsonObject value) {
        return this.addValue(value);
    }

    public JsonArrayBuilder addArray(UnaryOperator<JsonArrayBuilder> operator) {
        return this.add(((JsonArrayBuilder)operator.apply(JsonArrayBuilder.create())).build());
    }

    public JsonArrayBuilder addObject(UnaryOperator<JsonObjectBuilder> operator) {
        return this.add(((JsonObjectBuilder)operator.apply(JsonObjectBuilder.create())).build());
    }

    public JsonArrayBuilder add(JsonArray value) {
        return this.addValue(value);
    }

    public JsonArrayBuilder add(String value) {
        return this.addValue(value);
    }

    public JsonArrayBuilder add(Integer value) {
        return this.addValue(value);
    }

    public JsonArrayBuilder add(Long value) {
        return this.addValue(value);
    }

    public JsonArrayBuilder add(Number value) {
        return this.addValue(value);
    }

    public JsonArrayBuilder add(Double value) {
        return this.addValue(value);
    }

    public JsonArrayBuilder add(Boolean value) {
        return this.addValue(value);
    }

    public JsonArrayBuilder add(byte[] value) {
        return this.addValue(value == null ? null : Base64.getEncoder().encodeToString(value));
    }

    public JsonArrayBuilder add(Instant value) {
        return this.addValue(value == null ? null : DateTimeFormatter.ISO_INSTANT.format(value));
    }

    public <T extends Enum> JsonArrayBuilder add(T value) {
        return this.addValue(value == null ? null : value.name());
    }

    public JsonArrayBuilder addNull() {
        return this.addValue(null);
    }

    public JsonArrayBuilder merge(JsonArray jsonArray) {
        this.values.addAll(jsonArray.values);
        return this;
    }

    public JsonArrayBuilder merge(JsonArrayBuilder builder) {
        this.values.addAll(builder.values);
        return this;
    }

    public JsonArrayBuilder remove(int index) {
        this.values.remove(index);
        return this;
    }

    public JsonArrayBuilder clear() {
        this.values.clear();
        return this;
    }

    private <T> JsonArrayBuilder addValue(T value) {
        this.values.add(value);
        return this;
    }
}

