/*
 * Decompiled with CFR 0.152.
 */
package net.soundvibe.reacto.types.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.soundvibe.reacto.mappers.jackson.JacksonMapper;
import net.soundvibe.reacto.types.json.JsonArray;
import net.soundvibe.reacto.types.json.JsonStringEncoder;

public final class JsonObject
implements Iterable<Map.Entry<String, Object>> {
    private static final JsonObject EMPTY = new JsonObject(Collections.emptyMap());
    final Map<String, Object> values;

    public JsonObject(Map<String, Object> values) {
        this.values = values;
    }

    public static JsonObject empty() {
        return EMPTY;
    }

    public static JsonObject fromJson(String json) {
        return JacksonMapper.fromJson(json, JsonObject.class);
    }

    public Optional<String> asString(String key) {
        return this.valueOf(key, String.class);
    }

    public Optional<Integer> asInteger(String key) {
        return this.valueOf(key, Integer.class);
    }

    public Optional<Long> asLong(String key) {
        return this.valueOf(key, Long.class);
    }

    public Optional<Double> asDouble(String key) {
        return this.valueOf(key, Double.class);
    }

    public Optional<Boolean> asBoolean(String key) {
        return this.valueOf(key, Boolean.class);
    }

    public Optional<Number> asNumber(String key) {
        return this.valueOf(key, Number.class);
    }

    public <T> Optional<T> valueOf(String key, Class<T> valueClass) {
        if (Enum.class.isAssignableFrom(valueClass)) {
            return this.asEnum(key, valueClass).map(anEnum -> anEnum);
        }
        if (Instant.class.isAssignableFrom(valueClass)) {
            return this.asInstant(key).map(instant -> instant);
        }
        if (byte[].class.isAssignableFrom(valueClass)) {
            return this.asBytes(key).map(bytes -> bytes);
        }
        return Optional.ofNullable(this.values.get(key)).flatMap(o -> valueClass.isInstance(o) ? Optional.of(valueClass.cast(o)) : Optional.empty());
    }

    public Optional<byte[]> asBytes(String key) {
        return this.valueOf(key, String.class).map(s -> Base64.getDecoder().decode((String)s));
    }

    public Optional<Instant> asInstant(String key) {
        return this.valueOf(key, String.class).map(s -> Instant.from(DateTimeFormatter.ISO_INSTANT.parse((CharSequence)s)));
    }

    public Optional<JsonArray> asArray(String key) {
        return Optional.ofNullable(this.values.get(key)).flatMap(o -> o instanceof List ? Optional.of(new JsonArray((List)o)) : (o instanceof JsonArray ? Optional.of((JsonArray)o) : Optional.empty()));
    }

    public Optional<JsonObject> asObject(String key) {
        return Optional.ofNullable(this.values.get(key)).flatMap(o -> o instanceof Map ? Optional.of(new JsonObject((Map)o)) : (o instanceof JsonObject ? Optional.of((JsonObject)o) : Optional.empty()));
    }

    public <T extends Enum<T>> Optional<T> asEnum(String key, Class<T> enumClass) {
        return this.valueOf(key, String.class).map(name -> Enum.valueOf(enumClass, name));
    }

    public Map<String, Object> toMap() {
        return new LinkedHashMap<String, Object>(this.values);
    }

    public boolean containsKey(String key) {
        return this.values.containsKey(key);
    }

    public int size() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public boolean hasElements() {
        return !this.isEmpty();
    }

    public Set<String> fieldNames() {
        return new LinkedHashSet<String>(this.values.keySet());
    }

    public Stream<Map.Entry<String, Object>> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public Stream<String> streamOfKeys() {
        return this.stream().map(Map.Entry::getKey);
    }

    public Stream<Object> streamOfValues() {
        return this.stream().map(Map.Entry::getValue);
    }

    public Stream<Map.Entry<String, Object>> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            return Objects.equals(this.values, map);
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        JsonObject entries = (JsonObject)o;
        return Objects.equals(this.values, entries.values);
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return new JsonObjectIterator(this.values.entrySet().iterator());
    }

    public String toString() {
        return this.values.toString();
    }

    public String toJson() {
        return JacksonMapper.toJson(this);
    }

    public String encode(JsonStringEncoder encoder) {
        return encoder.encode(this);
    }

    public static class JsonObjectDeserializer
    extends JsonDeserializer<JsonObject> {
        private static final JavaType mapType = TypeFactory.defaultInstance().constructMapType(LinkedHashMap.class, String.class, Object.class);

        public JsonObject deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return new JsonObject((Map)deserializationContext.readValue(jsonParser, mapType));
        }
    }

    public static class JsonObjectSerializer
    extends JsonSerializer<JsonObject> {
        public void serialize(JsonObject value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeObject(value.values);
        }
    }

    private static final class Entry
    implements Map.Entry<String, Object> {
        private final String key;
        private final Object value;

        Entry(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }
    }

    private class JsonObjectIterator
    implements Iterator<Map.Entry<String, Object>> {
        private final Iterator<Map.Entry<String, Object>> entryIterator;

        JsonObjectIterator(Iterator<Map.Entry<String, Object>> entryIterator) {
            this.entryIterator = entryIterator;
        }

        @Override
        public boolean hasNext() {
            return this.entryIterator.hasNext();
        }

        @Override
        public Map.Entry<String, Object> next() {
            Map.Entry<String, Object> next = this.entryIterator.next();
            if (next.getValue() instanceof Map) {
                return new Entry(next.getKey(), new JsonObject((Map)next.getValue()));
            }
            if (next.getValue() instanceof List) {
                return new Entry(next.getKey(), new JsonArray((List)next.getValue()));
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

