/*
 * Decompiled with CFR 0.152.
 */
package net.soundvibe.reacto.types.json;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import net.soundvibe.reacto.types.json.JsonArray;
import net.soundvibe.reacto.types.json.JsonArrayBuilder;
import net.soundvibe.reacto.types.json.JsonObject;
import net.soundvibe.reacto.types.json.JsonStringDecoder;

public final class JsonObjectBuilder {
    private final Map<String, Object> values;

    private JsonObjectBuilder(JsonObject jsonObject) {
        Objects.requireNonNull(jsonObject, "jsonObject cannot be null");
        this.values = new LinkedHashMap<String, Object>(jsonObject.values);
    }

    private JsonObjectBuilder(Map<String, Object> map) {
        Objects.requireNonNull(map, "decode cannot be null");
        this.values = map;
    }

    public static JsonObjectBuilder create() {
        return new JsonObjectBuilder(new LinkedHashMap<String, Object>());
    }

    public static JsonObjectBuilder from(JsonObject jsonObject) {
        return new JsonObjectBuilder(jsonObject);
    }

    public static JsonObjectBuilder from(String jsonString, JsonStringDecoder decoder) {
        return new JsonObjectBuilder(decoder.decodeToObject(jsonString));
    }

    public JsonObjectBuilder put(String key, CharSequence value) {
        return this.putValue(key, value == null ? null : value.toString());
    }

    public JsonObjectBuilder put(String key, JsonObject value) {
        return this.putValue(key, value);
    }

    public JsonObjectBuilder put(String key, JsonArray value) {
        return this.putValue(key, value);
    }

    public JsonObjectBuilder putObject(String key, UnaryOperator<JsonObjectBuilder> operator) {
        return this.put(key, ((JsonObjectBuilder)operator.apply(JsonObjectBuilder.create())).build());
    }

    public JsonObjectBuilder putArray(String key, UnaryOperator<JsonArrayBuilder> operator) {
        return this.put(key, ((JsonArrayBuilder)operator.apply(JsonArrayBuilder.create())).build());
    }

    public JsonObjectBuilder put(String key, String value) {
        return this.putValue(key, value);
    }

    public JsonObjectBuilder put(String key, Integer value) {
        return this.putValue(key, value);
    }

    public JsonObjectBuilder put(String key, Long value) {
        return this.putValue(key, value);
    }

    public JsonObjectBuilder put(String key, Number value) {
        return this.putValue(key, value);
    }

    public JsonObjectBuilder put(String key, Double value) {
        return this.putValue(key, value);
    }

    public JsonObjectBuilder put(String key, Boolean value) {
        return this.putValue(key, value);
    }

    public JsonObjectBuilder put(String key, byte[] value) {
        return this.putValue(key, value == null ? null : Base64.getEncoder().encodeToString(value));
    }

    public JsonObjectBuilder put(String key, Instant value) {
        return this.putValue(key, value == null ? null : DateTimeFormatter.ISO_INSTANT.format(value));
    }

    public <T extends Enum> JsonObjectBuilder put(String key, T value) {
        return this.putValue(key, value == null ? null : value.name());
    }

    public JsonObjectBuilder putNull(String key) {
        return this.putValue(key, null);
    }

    public JsonObjectBuilder merge(JsonObject jsonObject) {
        this.values.putAll(jsonObject.values);
        return this;
    }

    public JsonObjectBuilder merge(JsonObjectBuilder builder) {
        this.values.putAll(builder.values);
        return this;
    }

    public JsonObjectBuilder clear() {
        this.values.clear();
        return this;
    }

    public JsonObjectBuilder remove(String key) {
        this.values.remove(key);
        return this;
    }

    public JsonObject build() {
        return new JsonObject(this.values);
    }

    private <T> JsonObjectBuilder putValue(String key, T value) {
        Objects.requireNonNull(key, "key cannot be null");
        this.values.put(key, value);
        return this;
    }
}

