/*
 * Decompiled with CFR 0.152.
 */
package net.soundvibe.reacto.utils;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;

public interface WebUtils {
    public static String includeEndDelimiter(String url) {
        if (url == null) {
            return null;
        }
        return url.endsWith("/") ? url : url + "/";
    }

    public static String excludeEndDelimiter(String url) {
        if (url == null) {
            return null;
        }
        return url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
    }

    public static String excludeStartDelimiter(String url) {
        if (url == null) {
            return null;
        }
        return url.startsWith("/") ? url.substring(1, url.length()) : url;
    }

    public static String includeStartDelimiter(String url) {
        if (url == null) {
            return null;
        }
        return url.startsWith("/") ? url : "/" + url;
    }

    public static URI resolveWsURI(String url) {
        return url.startsWith("http") ? URI.create(url.replaceFirst("http", "ws")) : (url.startsWith("https") ? URI.create(url.replaceFirst("https", "wss")) : URI.create(url));
    }

    public static String getLocalAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            try {
                return InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e1) {
                return "localhost";
            }
        }
    }
}

