/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ccxjc;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JForLoop;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.generator.bean.ImplStructureStrategy;
import com.sun.tools.xjc.model.CArrayInfo;
import com.sun.tools.xjc.model.CBuiltinLeafInfo;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CElementInfo;
import com.sun.tools.xjc.model.CEnumLeafInfo;
import com.sun.tools.xjc.model.CNonElement;
import com.sun.tools.xjc.model.CTypeInfo;
import com.sun.tools.xjc.model.CWildcardTypeInfo;
import com.sun.tools.xjc.model.nav.NType;
import com.sun.tools.xjc.outline.Aspect;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.logging.Level;
import javax.activation.MimeType;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import net.sourceforge.ccxjc.CAdapterInfo;
import net.sourceforge.ccxjc.CClassInfoComparator;
import net.sourceforge.ccxjc.CElementInfoComparator;
import net.sourceforge.ccxjc.CTypeInfoComparator;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PluginImpl
extends Plugin {
    private static final JType[] NO_ARGS = new JType[0];
    private static final String MESSAGE_PREFIX = "CC-XJC";
    private static final String WARNING_PREFIX = "CC-XJC WARNING";
    private static final String OPTION_NAME = "copy-constructor";
    private static final String VISIBILITY_OPTION_NAME = "-cc-visibility";
    private static final String TARGET_OPTION_NAME = "-cc-target";
    private static final String NULLABLE_OPTION_NAME = "-cc-nullable";
    private static final String HIERARCHICAL_OPTION_NAME = "-cc-hierarchical";
    private static final String IMMUTABLE_TYPES_OPTION_NAME = "-cc-immutable-types";
    private static final String CLONEABLE_TYPES_OPTION_NAME = "-cc-cloneable-types";
    private static final String STRING_TYPES_OPTION_NAME = "-cc-string-types";
    private static final String ELEMENT_SEPARATOR = ":";
    private static final List<String> DEFAULT_IMMUTABLE_TYPES = Arrays.asList(Boolean.class.getName(), Byte.class.getName(), Character.class.getName(), Double.class.getName(), Enum.class.getName(), Float.class.getName(), Integer.class.getName(), Long.class.getName(), Short.class.getName(), String.class.getName(), BigDecimal.class.getName(), BigInteger.class.getName(), UUID.class.getName(), QName.class.getName(), Duration.class.getName(), Currency.class.getName());
    private static final List<String> DEFAULT_CLONEABLE_TYPES = Arrays.asList(XMLGregorianCalendar.class.getName(), Date.class.getName(), Calendar.class.getName(), TimeZone.class.getName(), Locale.class.getName());
    private static final List<String> DEFAULT_STRING_TYPES = Arrays.asList(File.class.getName(), URI.class.getName(), URL.class.getName(), MimeType.class.getName());
    private static final Class<?>[] PRIMITIVE_ARRAY_TYPES = new Class[]{boolean[].class, byte[].class, char[].class, double[].class, float[].class, int[].class, long[].class, short[].class};
    private static final String[] VISIBILITY_ARGUMENTS = new String[]{"private", "package", "protected", "public"};
    private static final String[] TARGET_ARGUMENTS = new String[]{"1.5", "1.6", "1.7"};
    private static final int TARGET_1_5 = 5;
    private static final int TARGET_1_6 = 6;
    private static final int TARGET_1_7 = 7;
    private boolean success;
    private Options options;
    private String visibility = "private";
    private int targetJdk = 5;
    private boolean nullable = false;
    private boolean hierarchical = false;
    private final List<String> immutableTypes = new ArrayList<String>(64);
    private final List<String> cloneableTypes = new ArrayList<String>(64);
    private final List<String> stringTypes = new ArrayList<String>(64);
    private BigInteger methodCount;
    private BigInteger constructorCount;
    private BigInteger expressionCount;
    private final Set<Class<?>> contextExceptions = new HashSet();
    private boolean tryCatchCopyExpression = false;

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        String n = System.getProperty("line.separator", "\n");
        return new StringBuilder(1024).append("  -").append(OPTION_NAME).append("  :  ").append(PluginImpl.getMessage("usage", new Object[0])).append(n).append("  ").append(VISIBILITY_OPTION_NAME).append("     :  ").append(PluginImpl.getMessage("visibilityUsage", new Object[0])).append(n).append("  ").append(TARGET_OPTION_NAME).append("         :  ").append(PluginImpl.getMessage("targetUsage", new Object[0])).append(n).append("  ").append(NULLABLE_OPTION_NAME).append("       :  ").append(PluginImpl.getMessage("nullableUsage", new Object[0])).append(n).append("  ").append(HIERARCHICAL_OPTION_NAME).append("   :  ").append(PluginImpl.getMessage("hierarchicalUsage", new Object[0])).append(n).append("  ").append(CLONEABLE_TYPES_OPTION_NAME).append(":  ").append(PluginImpl.getMessage("cloneableTypesUsage", ELEMENT_SEPARATOR)).append(n).append("  ").append(IMMUTABLE_TYPES_OPTION_NAME).append(":  ").append(PluginImpl.getMessage("immutableTypesUsage", ELEMENT_SEPARATOR)).append(n).append("  ").append(STRING_TYPES_OPTION_NAME).append("   :  ").append(PluginImpl.getMessage("stringTypesUsage", ELEMENT_SEPARATOR)).toString();
    }

    public int parseArgument(Options opt, String[] args, int i) throws BadCommandLineException, IOException {
        List<String> types;
        String missingOptionArgument;
        StringBuilder supportedVisibilities = new StringBuilder(1024).append('[');
        Iterator<String> it = Arrays.asList(VISIBILITY_ARGUMENTS).iterator();
        while (it.hasNext()) {
            supportedVisibilities.append(it.next());
            if (!it.hasNext()) continue;
            supportedVisibilities.append(", ");
        }
        StringBuilder supportedTargets = new StringBuilder(512).append('[');
        Iterator<String> it2 = Arrays.asList(TARGET_ARGUMENTS).iterator();
        while (it2.hasNext()) {
            supportedTargets.append(it2.next());
            if (!it2.hasNext()) continue;
            supportedTargets.append(", ");
        }
        if (args[i].startsWith(VISIBILITY_OPTION_NAME)) {
            if (i + 1 >= args.length) {
                missingOptionArgument = PluginImpl.getMessage("missingOptionArgument", VISIBILITY_OPTION_NAME);
                String expectedOptionArgument = PluginImpl.getMessage("expectedOptionArgument", supportedVisibilities.append(']').toString());
                throw new BadCommandLineException(missingOptionArgument + " " + expectedOptionArgument);
            }
            this.visibility = args[i + 1].trim();
            boolean supported = false;
            for (String argument : VISIBILITY_ARGUMENTS) {
                if (!argument.equals(this.visibility)) continue;
                supported = true;
                break;
            }
            if (!supported) {
                String expectedOptionArgument = PluginImpl.getMessage("expectedOptionArgument", supportedVisibilities.append(']').toString());
                throw new BadCommandLineException(expectedOptionArgument);
            }
            return 2;
        }
        if (args[i].startsWith(TARGET_OPTION_NAME)) {
            if (i + 1 >= args.length) {
                missingOptionArgument = PluginImpl.getMessage("missingOptionArgument", TARGET_OPTION_NAME);
                String expectedOptionArgument = PluginImpl.getMessage("expectedOptionArgument", supportedTargets.append(']').toString());
                throw new BadCommandLineException(missingOptionArgument + " " + expectedOptionArgument);
            }
            String targetArg = args[i + 1].trim();
            boolean supported = false;
            for (String argument : TARGET_ARGUMENTS) {
                if (!argument.equals(targetArg)) continue;
                supported = true;
                break;
            }
            if (!supported) {
                String expectedOptionArgument = PluginImpl.getMessage("expectedOptionArgument", supportedTargets.append(']').toString());
                throw new BadCommandLineException(expectedOptionArgument);
            }
            if (targetArg.equals("1.5")) {
                this.targetJdk = 5;
            } else if (targetArg.equals("1.6")) {
                this.targetJdk = 6;
            } else if (targetArg.equals("1.7")) {
                this.targetJdk = 7;
            }
            return 2;
        }
        if (args[i].startsWith(NULLABLE_OPTION_NAME)) {
            this.nullable = true;
            return 1;
        }
        if (args[i].startsWith(HIERARCHICAL_OPTION_NAME)) {
            this.hierarchical = true;
            return 1;
        }
        if (args[i].startsWith(IMMUTABLE_TYPES_OPTION_NAME)) {
            if (i + 1 >= args.length) {
                throw new BadCommandLineException(PluginImpl.getMessage("missingOptionArgument", IMMUTABLE_TYPES_OPTION_NAME));
            }
            types = Arrays.asList(args[i + 1].split(ELEMENT_SEPARATOR));
            for (String type : types) {
                if (type.startsWith("@")) {
                    this.immutableTypes.addAll(this.readTypes(type.substring(1)));
                    continue;
                }
                if (type.trim().length() <= 0) continue;
                this.immutableTypes.add(type);
            }
            return 2;
        }
        if (args[i].startsWith(CLONEABLE_TYPES_OPTION_NAME)) {
            if (i + 1 >= args.length) {
                throw new BadCommandLineException(PluginImpl.getMessage("missingOptionArgument", CLONEABLE_TYPES_OPTION_NAME));
            }
            types = Arrays.asList(args[i + 1].split(ELEMENT_SEPARATOR));
            for (String type : types) {
                if (type.startsWith("@")) {
                    this.cloneableTypes.addAll(this.readTypes(type.substring(1)));
                    continue;
                }
                if (type.trim().length() <= 0) continue;
                this.cloneableTypes.add(type);
            }
            return 2;
        }
        if (args[i].startsWith(STRING_TYPES_OPTION_NAME)) {
            if (i + 1 >= args.length) {
                throw new BadCommandLineException(PluginImpl.getMessage("missingOptionArgument", STRING_TYPES_OPTION_NAME));
            }
            types = Arrays.asList(args[i + 1].split(ELEMENT_SEPARATOR));
            for (String type : types) {
                if (type.startsWith("@")) {
                    this.stringTypes.addAll(this.readTypes(type.substring(1)));
                    continue;
                }
                if (type.trim().length() <= 0) continue;
                this.stringTypes.add(type);
            }
            return 2;
        }
        return 0;
    }

    public boolean run(Outline model, Options options, ErrorHandler errorHandler) {
        this.success = true;
        this.options = options;
        this.methodCount = BigInteger.ZERO;
        this.constructorCount = BigInteger.ZERO;
        this.expressionCount = BigInteger.ZERO;
        this.cloneableTypes.removeAll(DEFAULT_CLONEABLE_TYPES);
        this.cloneableTypes.addAll(DEFAULT_CLONEABLE_TYPES);
        this.immutableTypes.removeAll(DEFAULT_IMMUTABLE_TYPES);
        this.immutableTypes.addAll(DEFAULT_IMMUTABLE_TYPES);
        this.stringTypes.removeAll(DEFAULT_STRING_TYPES);
        this.stringTypes.addAll(DEFAULT_STRING_TYPES);
        this.log(Level.INFO, "title", new Object[0]);
        this.log(Level.INFO, "visibilityReport", this.visibility);
        StringBuilder cloneableInfo = new StringBuilder(1024);
        StringBuilder immutableInfo = new StringBuilder(1024);
        StringBuilder stringInfo = new StringBuilder(1024);
        for (String name : this.cloneableTypes) {
            cloneableInfo.append(System.getProperty("line.separator", "\n")).append("\t").append(name);
        }
        for (String name : this.immutableTypes) {
            immutableInfo.append(System.getProperty("line.separator", "\n")).append("\t").append(name);
        }
        for (String name : this.stringTypes) {
            stringInfo.append(System.getProperty("line.separator", "\n")).append("\t").append(name);
        }
        this.log(Level.INFO, "cloneableTypesInfo", cloneableInfo.toString());
        this.log(Level.INFO, "immutableTypesInfo", immutableInfo.toString());
        this.log(Level.INFO, "stringTypesInfo", stringInfo.toString());
        for (ClassOutline clazz : model.getClasses()) {
            this.warnOnReferencedSupertypes(clazz);
            if (this.getStandardConstructor(clazz) == null) {
                this.log(Level.WARNING, "couldNotAddStdCtor", clazz.implClass.binaryName());
            }
            if (this.getCopyConstructor(clazz) == null) {
                this.log(Level.WARNING, "couldNotAddCopyCtor", clazz.implClass.binaryName());
            }
            if (this.getCloneMethod(clazz) != null) continue;
            this.log(Level.WARNING, "couldNotAddMethod", "clone", clazz.implClass.binaryName());
        }
        this.log(Level.INFO, "report", this.methodCount, this.constructorCount, this.expressionCount);
        this.options = null;
        return this.success;
    }

    private int getVisibilityModifier() {
        if ("private".equals(this.visibility)) {
            return 4;
        }
        if ("protected".equals(this.visibility)) {
            return 2;
        }
        if ("public".equals(this.visibility)) {
            return 1;
        }
        return 0;
    }

    private boolean isTargetSupported(int target) {
        return target <= this.targetJdk;
    }

    private JMethod getStandardConstructor(ClassOutline clazz) {
        JMethod ctor = clazz.implClass.getConstructor(NO_ARGS);
        if (ctor == null) {
            ctor = this.generateStandardConstructor(clazz);
        } else {
            this.log(Level.WARNING, "standardCtorExists", clazz.implClass.binaryName());
        }
        return ctor;
    }

    private JMethod getCopyConstructor(ClassOutline clazz) {
        JMethod ctor = clazz.implClass.getConstructor(new JType[]{clazz.implClass});
        if (ctor == null) {
            ctor = this.generateCopyConstructor(clazz);
        } else {
            this.log(Level.WARNING, "copyCtorExists", clazz.implClass.binaryName());
        }
        return ctor;
    }

    private JMethod getCloneMethod(ClassOutline clazz) {
        JMethod clone = clazz.implClass.getMethod("clone", NO_ARGS);
        if (clone == null) {
            clone = this.generateCloneMethod(clazz);
        } else {
            this.log(Level.WARNING, "methodExists", "clone", clazz.implClass.binaryName());
        }
        return clone;
    }

    private JMethod getPropertyGetter(FieldOutline f) {
        JDefinedClass clazz = f.parent().implClass;
        String name = f.getPropertyInfo().getName(true);
        JMethod getter = clazz.getMethod("get" + name, NO_ARGS);
        if (getter == null) {
            getter = clazz.getMethod("is" + name, NO_ARGS);
        }
        return getter;
    }

    private FieldOutline getFieldOutline(ClassOutline clazz, String fieldName) {
        for (FieldOutline f : clazz.getDeclaredFields()) {
            if (!f.getPropertyInfo().getName(false).equals(fieldName)) continue;
            return f;
        }
        return null;
    }

    private JInvocation getCopyOfJaxbElementInvocation(ClassOutline clazz) {
        JClass jaxbElement = clazz.parent().getCodeModel().ref(JAXBElement.class);
        JType[] signature = new JType[]{jaxbElement};
        String methodName = "copyOf";
        int mod = this.getVisibilityModifier();
        if (mod != 4) {
            for (JMethod m : clazz._package().objectFactory().methods()) {
                if (!m.name().equals("copyOf") || !m.hasSignature(signature)) continue;
                return clazz._package().objectFactory().staticInvoke(m);
            }
        } else {
            for (JMethod m : clazz.implClass.methods()) {
                if (!m.name().equals("copyOf") || !m.hasSignature(signature)) continue;
                return JExpr.invoke((JMethod)m);
            }
        }
        JMethod m = mod != 4 ? clazz._package().objectFactory().method(0x10 | mod, JAXBElement.class, "copyOf") : clazz.implClass.method(0x10 | mod, JAXBElement.class, "copyOf");
        JVar element = m.param(8, (JType)jaxbElement, "element");
        m.javadoc().append((Object)"Creates and returns a deep copy of a given {@code JAXBElement} instance.");
        m.javadoc().addParam(element).append((Object)"The instance to copy or {@code null}.");
        m.javadoc().addReturn().append((Object)"A deep copy of {@code element} or {@code null} if {@code element} is {@code null}.");
        m.annotate(SuppressWarnings.class).param("value", "unchecked");
        m.body().directStatement("// " + PluginImpl.getMessage("title", new Object[0]));
        JConditional isNotNull = m.body()._if(element.ne(JExpr._null()));
        JInvocation newElement = JExpr._new((JClass)jaxbElement).arg((JExpression)JExpr.invoke((JExpression)element, (String)"getName")).arg((JExpression)JExpr.invoke((JExpression)element, (String)"getDeclaredType")).arg((JExpression)JExpr.invoke((JExpression)element, (String)"getScope")).arg((JExpression)JExpr.invoke((JExpression)element, (String)"getValue"));
        JVar copy = isNotNull._then().decl(8, (JType)jaxbElement, "copy", (JExpression)newElement);
        isNotNull._then().add((JStatement)copy.invoke("setNil").arg((JExpression)element.invoke("isNil")));
        isNotNull._then().add((JStatement)copy.invoke("setValue").arg((JExpression)this.getCopyOfObjectInvocation(clazz).arg((JExpression)JExpr.invoke((JExpression)copy, (String)"getValue"))));
        isNotNull._then()._return((JExpression)copy);
        m.body()._return(JExpr._null());
        this.methodCount = this.methodCount.add(BigInteger.ONE);
        return mod != 4 ? clazz._package().objectFactory().staticInvoke(m) : JExpr.invoke((JMethod)m);
    }

    private JExpression getCopyOfPrimitiveArrayExpression(ClassOutline classOutline, JClass arrayType, JExpression source) {
        if (this.isTargetSupported(6)) {
            JClass arrays = classOutline.parent().getCodeModel().ref(Arrays.class);
            return JOp.cond((JExpression)source.eq(JExpr._null()), (JExpression)JExpr._null(), (JExpression)arrays.staticInvoke("copyOf").arg(source).arg((JExpression)source.ref("length")));
        }
        JClass array = classOutline.parent().getCodeModel().ref(Array.class);
        JClass system = classOutline.parent().getCodeModel().ref(System.class);
        int mod = this.getVisibilityModifier();
        String methodName = "copyOf";
        JType[] signature = new JType[]{arrayType};
        if (mod != 4) {
            for (JMethod m : classOutline._package().objectFactory().methods()) {
                if (!m.name().equals("copyOf") || !m.hasSignature(signature)) continue;
                return classOutline._package().objectFactory().staticInvoke(m).arg(source);
            }
        } else {
            for (JMethod m : classOutline.implClass.methods()) {
                if (!m.name().equals("copyOf") || !m.hasSignature(signature)) continue;
                return JExpr.invoke((JMethod)m).arg(source);
            }
        }
        JMethod m = mod != 4 ? classOutline._package().objectFactory().method(0x10 | mod, (JType)arrayType, "copyOf") : classOutline.implClass.method(0x10 | mod, (JType)arrayType, "copyOf");
        JVar arrayParam = m.param(8, (JType)arrayType, "array");
        m.javadoc().append((Object)"Creates and returns a deep copy of a given array.");
        m.javadoc().addParam(arrayParam).append((Object)"The array to copy or {@code null}.");
        m.javadoc().addReturn().append((Object)"A deep copy of {@code array} or {@code null} if {@code array} is {@code null}.");
        m.body().directStatement("// " + PluginImpl.getMessage("title", new Object[0]));
        JConditional arrayNotNull = m.body()._if(arrayParam.ne(JExpr._null()));
        JVar copy = arrayNotNull._then().decl(8, (JType)arrayType, "copy", (JExpression)JExpr.cast((JType)arrayType, (JExpression)array.staticInvoke("newInstance").arg((JExpression)arrayParam.invoke("getClass").invoke("getComponentType")).arg((JExpression)arrayParam.ref("length"))));
        arrayNotNull._then().add((JStatement)system.staticInvoke("arraycopy").arg((JExpression)arrayParam).arg(JExpr.lit((int)0)).arg((JExpression)copy).arg(JExpr.lit((int)0)).arg((JExpression)arrayParam.ref("length")));
        arrayNotNull._then()._return((JExpression)copy);
        m.body()._return(JExpr._null());
        this.methodCount = this.methodCount.add(BigInteger.ONE);
        return mod != 4 ? classOutline._package().objectFactory().staticInvoke(m).arg(source) : JExpr.invoke((JMethod)m).arg(source);
    }

    private JInvocation getCopyOfArrayInvocation(ClassOutline clazz) {
        JClass object = clazz.parent().getCodeModel().ref(Object.class);
        JClass array = clazz.parent().getCodeModel().ref(Array.class);
        JType[] signature = new JType[]{object};
        String methodName = "copyOfArray";
        int mod = this.getVisibilityModifier();
        if (mod != 4) {
            for (JMethod m : clazz._package().objectFactory().methods()) {
                if (!m.name().equals("copyOfArray") || !m.hasSignature(signature)) continue;
                return clazz._package().objectFactory().staticInvoke(m);
            }
        } else {
            for (JMethod m : clazz.implClass.methods()) {
                if (!m.name().equals("copyOfArray") || !m.hasSignature(signature)) continue;
                return JExpr.invoke((JMethod)m);
            }
        }
        JMethod m = mod != 4 ? clazz._package().objectFactory().method(0x10 | mod, (JType)object, "copyOfArray") : clazz.implClass.method(0x10 | mod, (JType)object, "copyOfArray");
        JVar arrayArg = m.param(8, (JType)object, "array");
        m.javadoc().append((Object)"Creates and returns a deep copy of a given array.");
        m.javadoc().addParam(arrayArg).append((Object)"The array to copy or {@code null}.");
        m.javadoc().addReturn().append((Object)"A deep copy of {@code array} or {@code null} if {@code array} is {@code null}.");
        m.body().directStatement("// " + PluginImpl.getMessage("title", new Object[0]));
        JConditional arrayNotNull = m.body()._if(arrayArg.ne(JExpr._null()));
        for (Class<?> a : PRIMITIVE_ARRAY_TYPES) {
            JClass primitiveArray = clazz.parent().getCodeModel().ref(a);
            JConditional isArrayOfPrimitive = arrayNotNull._then()._if(arrayArg.invoke("getClass").eq(primitiveArray.dotclass()));
            isArrayOfPrimitive._then()._return(this.getCopyOfPrimitiveArrayExpression(clazz, primitiveArray, (JExpression)JExpr.cast((JType)primitiveArray, (JExpression)arrayArg)));
        }
        JVar len = arrayNotNull._then().decl(8, (JType)clazz.parent().getCodeModel().INT, "len", (JExpression)array.staticInvoke("getLength").arg((JExpression)arrayArg));
        JVar copy = arrayNotNull._then().decl(8, (JType)object, "copy", (JExpression)array.staticInvoke("newInstance").arg((JExpression)arrayArg.invoke("getClass").invoke("getComponentType")).arg((JExpression)len));
        JForLoop forEachRef = arrayNotNull._then()._for();
        JVar i = forEachRef.init((JType)clazz.parent().getCodeModel().INT, "i", len.minus(JExpr.lit((int)1)));
        forEachRef.test(i.gte(JExpr.lit((int)0)));
        forEachRef.update(i.decr());
        forEachRef.body().add((JStatement)array.staticInvoke("set").arg((JExpression)copy).arg((JExpression)i).arg((JExpression)this.getCopyOfObjectInvocation(clazz).arg((JExpression)array.staticInvoke("get").arg((JExpression)arrayArg).arg((JExpression)i))));
        arrayNotNull._then()._return((JExpression)copy);
        m.body()._return(JExpr._null());
        this.methodCount = this.methodCount.add(BigInteger.ONE);
        return mod != 4 ? clazz._package().objectFactory().staticInvoke(m) : JExpr.invoke((JMethod)m);
    }

    private JInvocation getCopyOfSerializableInvocation(ClassOutline clazz) {
        JClass serializable = clazz.parent().getCodeModel().ref(Serializable.class);
        JClass byteArrayOutputStream = clazz.parent().getCodeModel().ref(ByteArrayOutputStream.class);
        JClass byteArrayInputStream = clazz.parent().getCodeModel().ref(ByteArrayInputStream.class);
        JClass objectOutputStream = clazz.parent().getCodeModel().ref(ObjectOutputStream.class);
        JClass objectInputStream = clazz.parent().getCodeModel().ref(ObjectInputStream.class);
        JClass ioException = clazz.parent().getCodeModel().ref(IOException.class);
        JClass invalidClass = clazz.parent().getCodeModel().ref(InvalidClassException.class);
        JClass notSerializable = clazz.parent().getCodeModel().ref(NotSerializableException.class);
        JClass streamCorrupted = clazz.parent().getCodeModel().ref(StreamCorruptedException.class);
        JClass securityException = clazz.parent().getCodeModel().ref(SecurityException.class);
        JClass optionalData = clazz.parent().getCodeModel().ref(OptionalDataException.class);
        JClass classNotFound = clazz.parent().getCodeModel().ref(ClassNotFoundException.class);
        JClass assertionError = clazz.parent().getCodeModel().ref(AssertionError.class);
        JType[] signature = new JType[]{serializable};
        String methodName = "copyOf";
        int mod = this.getVisibilityModifier();
        if (mod != 4) {
            for (JMethod m : clazz._package().objectFactory().methods()) {
                if (!m.name().equals("copyOf") || !m.hasSignature(signature)) continue;
                return clazz._package().objectFactory().staticInvoke(m);
            }
        } else {
            for (JMethod m : clazz.implClass.methods()) {
                if (!m.name().equals("copyOf") || !m.hasSignature(signature)) continue;
                return JExpr.invoke((JMethod)m);
            }
        }
        JMethod m = mod != 4 ? clazz._package().objectFactory().method(0x10 | mod, (JType)serializable, "copyOf") : clazz.implClass.method(0x10 | mod, (JType)serializable, "copyOf");
        JVar s = m.param(8, (JType)serializable, "serializable");
        m.javadoc().append((Object)"Creates and returns a deep copy of a given {@code Serializable}.");
        m.javadoc().addParam(s).append((Object)"The instance to copy or {@code null}.");
        m.javadoc().addReturn().append((Object)"A deep copy of {@code serializable} or {@code null} if {@code serializable} is {@code null}.");
        m.body().directStatement("// " + PluginImpl.getMessage("title", new Object[0]));
        JConditional sNotNull = m.body()._if(s.ne(JExpr._null()));
        JTryBlock tryClone = sNotNull._then()._try();
        JVar byteArrayOutput = tryClone.body().decl(8, (JType)byteArrayOutputStream, "byteArrayOutput", (JExpression)JExpr._new((JClass)byteArrayOutputStream));
        JVar objectOutput = tryClone.body().decl(8, (JType)objectOutputStream, "out", (JExpression)JExpr._new((JClass)objectOutputStream).arg((JExpression)byteArrayOutput));
        tryClone.body().add((JStatement)objectOutput.invoke("writeObject").arg((JExpression)s));
        tryClone.body().add((JStatement)objectOutput.invoke("close"));
        JVar byteArrayInput = tryClone.body().decl(8, (JType)byteArrayInputStream, "byteArrayInput", (JExpression)JExpr._new((JClass)byteArrayInputStream).arg((JExpression)byteArrayOutput.invoke("toByteArray")));
        JVar objectInput = tryClone.body().decl(8, (JType)objectInputStream, "in", (JExpression)JExpr._new((JClass)objectInputStream).arg((JExpression)byteArrayInput));
        JVar copy = tryClone.body().decl(8, (JType)serializable, "copy", (JExpression)JExpr.cast((JType)serializable, (JExpression)objectInput.invoke("readObject")));
        tryClone.body().invoke((JExpression)objectInput, "close");
        tryClone.body()._return((JExpression)copy);
        JExpression assertionErrorMsg = JExpr.lit((String)"Unexpected instance during copying object '").plus((JExpression)s).plus(JExpr.lit((String)"'."));
        JCatchBlock catchSecurityException = tryClone._catch(securityException);
        catchSecurityException.body()._throw((JExpression)JExpr.cast((JType)assertionError, (JExpression)JExpr._new((JClass)assertionError).arg(assertionErrorMsg).invoke("initCause").arg((JExpression)catchSecurityException.param("e"))));
        JCatchBlock catchClassNotFound = tryClone._catch(classNotFound);
        catchClassNotFound.body()._throw((JExpression)JExpr.cast((JType)assertionError, (JExpression)JExpr._new((JClass)assertionError).arg(assertionErrorMsg).invoke("initCause").arg((JExpression)catchClassNotFound.param("e"))));
        JCatchBlock catchInvalidClass = tryClone._catch(invalidClass);
        catchInvalidClass.body()._throw((JExpression)JExpr.cast((JType)assertionError, (JExpression)JExpr._new((JClass)assertionError).arg(assertionErrorMsg).invoke("initCause").arg((JExpression)catchInvalidClass.param("e"))));
        JCatchBlock catchNotSerializable = tryClone._catch(notSerializable);
        catchNotSerializable.body()._throw((JExpression)JExpr.cast((JType)assertionError, (JExpression)JExpr._new((JClass)assertionError).arg(assertionErrorMsg).invoke("initCause").arg((JExpression)catchNotSerializable.param("e"))));
        JCatchBlock catchStreamCorrupted = tryClone._catch(streamCorrupted);
        catchStreamCorrupted.body()._throw((JExpression)JExpr.cast((JType)assertionError, (JExpression)JExpr._new((JClass)assertionError).arg(assertionErrorMsg).invoke("initCause").arg((JExpression)catchStreamCorrupted.param("e"))));
        JCatchBlock catchOptionalData = tryClone._catch(optionalData);
        catchOptionalData.body()._throw((JExpression)JExpr.cast((JType)assertionError, (JExpression)JExpr._new((JClass)assertionError).arg(assertionErrorMsg).invoke("initCause").arg((JExpression)catchOptionalData.param("e"))));
        JCatchBlock catchIOException = tryClone._catch(ioException);
        catchIOException.body()._throw((JExpression)JExpr.cast((JType)assertionError, (JExpression)JExpr._new((JClass)assertionError).arg(assertionErrorMsg).invoke("initCause").arg((JExpression)catchIOException.param("e"))));
        m.body()._return(JExpr._null());
        this.methodCount = this.methodCount.add(BigInteger.ONE);
        return mod != 4 ? clazz._package().objectFactory().staticInvoke(m) : JExpr.invoke((JMethod)m);
    }

    private JInvocation getCopyOfObjectInvocation(ClassOutline clazz) {
        Class<?> c;
        JClass object = clazz.parent().getCodeModel().ref(Object.class);
        JClass element = clazz.parent().getCodeModel().ref(Element.class);
        JClass jaxbElement = clazz.parent().getCodeModel().ref(JAXBElement.class);
        JClass noSuchMethod = clazz.parent().getCodeModel().ref(NoSuchMethodException.class);
        JClass illegalAccess = clazz.parent().getCodeModel().ref(IllegalAccessException.class);
        JClass invocationTarget = clazz.parent().getCodeModel().ref(InvocationTargetException.class);
        JClass securityException = clazz.parent().getCodeModel().ref(SecurityException.class);
        JClass illegalArgument = clazz.parent().getCodeModel().ref(IllegalArgumentException.class);
        JClass initializerError = clazz.parent().getCodeModel().ref(ExceptionInInitializerError.class);
        JClass assertionError = clazz.parent().getCodeModel().ref(AssertionError.class);
        JClass classArray = clazz.parent().getCodeModel().ref(Class[].class);
        JClass objectArray = clazz.parent().getCodeModel().ref(Object[].class);
        JClass serializable = clazz.parent().getCodeModel().ref(Serializable.class);
        String methodName = "copyOf";
        int mod = this.getVisibilityModifier();
        JType[] signature = new JType[]{object};
        if (mod != 4) {
            for (JMethod m : clazz._package().objectFactory().methods()) {
                if (!m.name().equals("copyOf") || !m.hasSignature(signature)) continue;
                return clazz._package().objectFactory().staticInvoke(m);
            }
        } else {
            for (JMethod m : clazz.implClass.methods()) {
                if (!m.name().equals("copyOf") || !m.hasSignature(signature)) continue;
                return JExpr.invoke((JMethod)m);
            }
        }
        JMethod m = mod != 4 ? clazz._package().objectFactory().method(0x10 | mod, (JType)object, "copyOf") : clazz.implClass.method(0x10 | mod, (JType)object, "copyOf");
        JVar o = m.param(8, (JType)object, "o");
        HashSet exceptions = new HashSet();
        m.javadoc().append((Object)"Creates and returns a deep copy of a given object.");
        m.javadoc().addParam(o).append((Object)"The instance to copy or {@code null}.");
        m.javadoc().addReturn().append((Object)"A deep copy of {@code o} or {@code null} if {@code o} is {@code null}.");
        m.annotate(SuppressWarnings.class).param("value", "unchecked");
        m.body().directStatement("// " + PluginImpl.getMessage("title", new Object[0]));
        JBlock copyBlock = new JBlock(false, false);
        JConditional objectNotNull = copyBlock._if(o.ne(JExpr._null()));
        JConditional isPrimitive = objectNotNull._then()._if((JExpression)JExpr.invoke((JExpression)JExpr.invoke((JExpression)o, (String)"getClass"), (String)"isPrimitive"));
        isPrimitive._then()._return((JExpression)o);
        JConditional isArray = objectNotNull._then()._if((JExpression)JExpr.invoke((JExpression)JExpr.invoke((JExpression)o, (String)"getClass"), (String)"isArray"));
        isArray._then()._return((JExpression)this.getCopyOfArrayInvocation(clazz).arg((JExpression)o));
        objectNotNull._then().directStatement("// Immutable types.");
        for (String immutableType : this.immutableTypes) {
            JClass immutable = clazz.parent().getCodeModel().ref(immutableType);
            objectNotNull._then()._if(o._instanceof((JType)immutable))._then()._return((JExpression)o);
        }
        objectNotNull._then().directStatement("// String based types.");
        for (String stringType : this.stringTypes) {
            JClass string = clazz.parent().getCodeModel().ref(stringType);
            c = this.getClass(stringType);
            if (c != null) {
                try {
                    exceptions.addAll(Arrays.asList(c.getConstructor(String.class).getExceptionTypes()));
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            objectNotNull._then()._if(o._instanceof((JType)string))._then()._return((JExpression)JExpr._new((JClass)string).arg((JExpression)o.invoke("toString")));
        }
        objectNotNull._then().directStatement("// Cloneable types.");
        for (String cloneableType : this.cloneableTypes) {
            JClass cloneable = clazz.parent().getCodeModel().ref(cloneableType);
            c = this.getClass(cloneableType);
            if (c != null) {
                try {
                    exceptions.addAll(Arrays.asList(c.getMethod("clone", new Class[0]).getExceptionTypes()));
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            objectNotNull._then()._if(o._instanceof((JType)cloneable))._then()._return((JExpression)JExpr.invoke((JExpression)JExpr.cast((JType)cloneable, (JExpression)o), (String)"clone"));
        }
        JConditional instanceOfDOMElement = objectNotNull._then()._if(o._instanceof((JType)element));
        instanceOfDOMElement._then()._return((JExpression)JExpr.cast((JType)element, (JExpression)JExpr.invoke((JExpression)JExpr.cast((JType)element, (JExpression)o), (String)"cloneNode").arg(JExpr.TRUE)));
        JConditional instanceOfElement = objectNotNull._then()._if(o._instanceof((JType)jaxbElement));
        instanceOfElement._then()._return((JExpression)this.getCopyOfJaxbElementInvocation(clazz).arg((JExpression)JExpr.cast((JType)jaxbElement, (JExpression)o)));
        JTryBlock tryCloneMethod = objectNotNull._then()._try();
        tryCloneMethod.body()._return((JExpression)JExpr.invoke((JExpression)JExpr.invoke((JExpression)JExpr.invoke((JExpression)o, (String)"getClass"), (String)"getMethod").arg("clone").arg((JExpression)JExpr.cast((JType)classArray, (JExpression)JExpr._null())), (String)"invoke").arg((JExpression)o).arg((JExpression)JExpr.cast((JType)objectArray, (JExpression)JExpr._null())));
        JExpression assertionErrorMsg = JExpr.lit((String)"Unexpected instance during copying object '").plus((JExpression)o).plus(JExpr.lit((String)"'."));
        JCatchBlock catchNoSuchMethod = tryCloneMethod._catch(noSuchMethod);
        JConditional instanceOfSerializable = catchNoSuchMethod.body()._if(o._instanceof((JType)serializable));
        instanceOfSerializable._then()._return((JExpression)this.getCopyOfSerializableInvocation(clazz).arg((JExpression)JExpr.cast((JType)serializable, (JExpression)o)));
        catchNoSuchMethod.body().directStatement("// Please report this at " + PluginImpl.getMessage("bugtrackerUrl", new Object[0]));
        catchNoSuchMethod.body()._throw((JExpression)JExpr.cast((JType)assertionError, (JExpression)JExpr._new((JClass)assertionError).arg(assertionErrorMsg).invoke("initCause").arg((JExpression)catchNoSuchMethod.param("e"))));
        JCatchBlock catchIllegalAccess = tryCloneMethod._catch(illegalAccess);
        catchIllegalAccess.body().directStatement("// Please report this at " + PluginImpl.getMessage("bugtrackerUrl", new Object[0]));
        catchIllegalAccess.body()._throw((JExpression)JExpr.cast((JType)assertionError, (JExpression)JExpr._new((JClass)assertionError).arg(assertionErrorMsg).invoke("initCause").arg((JExpression)catchIllegalAccess.param("e"))));
        JCatchBlock catchInvocationTarget = tryCloneMethod._catch(invocationTarget);
        catchInvocationTarget.body().directStatement("// Please report this at " + PluginImpl.getMessage("bugtrackerUrl", new Object[0]));
        catchInvocationTarget.body()._throw((JExpression)JExpr.cast((JType)assertionError, (JExpression)JExpr._new((JClass)assertionError).arg(assertionErrorMsg).invoke("initCause").arg((JExpression)catchInvocationTarget.param("e"))));
        JCatchBlock catchSecurityException = tryCloneMethod._catch(securityException);
        catchSecurityException.body().directStatement("// Please report this at " + PluginImpl.getMessage("bugtrackerUrl", new Object[0]));
        catchSecurityException.body()._throw((JExpression)JExpr.cast((JType)assertionError, (JExpression)JExpr._new((JClass)assertionError).arg(assertionErrorMsg).invoke("initCause").arg((JExpression)catchSecurityException.param("e"))));
        JCatchBlock catchIllegalArgument = tryCloneMethod._catch(illegalArgument);
        catchIllegalArgument.body().directStatement("// Please report this at " + PluginImpl.getMessage("bugtrackerUrl", new Object[0]));
        catchIllegalArgument.body()._throw((JExpression)JExpr.cast((JType)assertionError, (JExpression)JExpr._new((JClass)assertionError).arg(assertionErrorMsg).invoke("initCause").arg((JExpression)catchIllegalArgument.param("e"))));
        JCatchBlock catchInitializerError = tryCloneMethod._catch(initializerError);
        catchInitializerError.body().directStatement("// Please report this at " + PluginImpl.getMessage("bugtrackerUrl", new Object[0]));
        catchInitializerError.body()._throw((JExpression)JExpr.cast((JType)assertionError, (JExpression)JExpr._new((JClass)assertionError).arg(assertionErrorMsg).invoke("initCause").arg((JExpression)catchInitializerError.param("e"))));
        copyBlock._return(JExpr._null());
        if (!exceptions.isEmpty()) {
            JTryBlock tryCopy = m.body()._try();
            tryCopy.body().add((JStatement)copyBlock);
            for (Class clazz2 : exceptions) {
                JCatchBlock catchBlock = tryCopy._catch(clazz.parent().getCodeModel().ref(clazz2));
                catchBlock.body()._throw((JExpression)JExpr.cast((JType)assertionError, (JExpression)JExpr._new((JClass)assertionError).arg(assertionErrorMsg).invoke("initCause").arg((JExpression)catchBlock.param("e"))));
            }
        } else {
            m.body().add((JStatement)copyBlock);
        }
        this.methodCount = this.methodCount.add(BigInteger.ONE);
        return mod != 4 ? clazz._package().objectFactory().staticInvoke(m) : JExpr.invoke((JMethod)m);
    }

    private JInvocation getCopyOfElementInfoInvocation(FieldOutline fieldOutline, CElementInfo element) {
        JInvocation newElement;
        JType elementType = element.toType(fieldOutline.parent().parent(), Aspect.IMPLEMENTATION);
        JType[] signature = new JType[]{elementType};
        String methodName = element.hasClass() ? "copyOf" + element.shortName() : "copyOf" + this.getMethodNamePart(element.getContentType().toType(fieldOutline.parent().parent(), Aspect.IMPLEMENTATION)) + "Element";
        int mod = this.getVisibilityModifier();
        boolean needsToCatchException = false;
        if (mod != 4) {
            for (JMethod m : fieldOutline.parent()._package().objectFactory().methods()) {
                if (!m.name().equals(methodName) || !m.hasSignature(signature)) continue;
                return fieldOutline.parent()._package().objectFactory().staticInvoke(m);
            }
        } else {
            for (JMethod m : fieldOutline.parent().implClass.methods()) {
                if (!m.name().equals(methodName) || !m.hasSignature(signature)) continue;
                return JExpr.invoke((JMethod)m);
            }
        }
        JMethod m = mod != 4 ? fieldOutline.parent()._package().objectFactory().method(0x10 | mod, elementType, methodName) : fieldOutline.parent().implClass.method(0x10 | mod, elementType, methodName);
        JVar e = m.param(8, elementType, "e");
        m.javadoc().append((Object)("Creates and returns a deep copy of a given {@code " + elementType.binaryName() + "} instance."));
        m.javadoc().addParam(e).append((Object)"The instance to copy or {@code null}.");
        m.javadoc().addReturn().append((Object)"A deep copy of {@code e} or {@code null} if {@code e} is {@code null}.");
        m.annotate(SuppressWarnings.class).param("value", "unchecked");
        JBlock body = new JBlock(false, false);
        body.directStatement("// " + PluginImpl.getMessage("title", new Object[0]));
        JConditional elementNotNull = body._if(e.ne(JExpr._null()));
        if (element.hasClass()) {
            newElement = JExpr._new((JType)elementType).arg(this.getCopyExpression(fieldOutline, (CTypeInfo)element.getContentType(), elementNotNull._then(), (JExpression)JExpr.cast((JType)element.getContentType().toType(fieldOutline.parent().parent(), Aspect.IMPLEMENTATION), (JExpression)JExpr.invoke((JExpression)e, (String)"getValue")), true));
            needsToCatchException = needsToCatchException || this.tryCatchCopyExpression;
        } else {
            newElement = JExpr._new((JType)elementType).arg((JExpression)JExpr.invoke((JExpression)e, (String)"getName")).arg((JExpression)JExpr.invoke((JExpression)e, (String)"getDeclaredType")).arg((JExpression)JExpr.invoke((JExpression)e, (String)"getScope")).arg((JExpression)JExpr.invoke((JExpression)e, (String)"getValue"));
        }
        JVar copy = elementNotNull._then().decl(8, elementType, "copy", (JExpression)newElement);
        elementNotNull._then().add((JStatement)copy.invoke("setNil").arg((JExpression)e.invoke("isNil")));
        if (!element.hasClass()) {
            elementNotNull._then().add((JStatement)copy.invoke("setValue").arg(this.getCopyExpression(fieldOutline, (CTypeInfo)element.getContentType(), elementNotNull._then(), (JExpression)JExpr.cast((JType)element.getContentType().toType(fieldOutline.parent().parent(), Aspect.IMPLEMENTATION), (JExpression)copy.invoke("getValue")), true)));
            needsToCatchException = needsToCatchException || this.tryCatchCopyExpression;
        }
        elementNotNull._then()._return((JExpression)copy);
        body._return(JExpr._null());
        if (needsToCatchException) {
            JTryBlock tryCopy = m.body()._try();
            tryCopy.body().add((JStatement)body);
            JCatchBlock catchException = tryCopy._catch(fieldOutline.parent().parent().getCodeModel().ref(Exception.class));
            JVar ex = catchException.param("e");
            catchException.body()._throw((JExpression)JExpr._new((JClass)fieldOutline.parent().parent().getCodeModel().ref(AssertionError.class)).arg((JExpression)ex));
        } else {
            m.body().add((JStatement)body);
        }
        this.methodCount = this.methodCount.add(BigInteger.ONE);
        return mod != 4 ? fieldOutline.parent()._package().objectFactory().staticInvoke(m) : JExpr.invoke((JMethod)m);
    }

    private JInvocation getCopyOfArrayInfoInvocation(FieldOutline fieldOutline, CArrayInfo array) {
        JType arrayType = array.getAdapterUse() != null && array.getAdapterUse().customType != null ? ((NType)array.getAdapterUse().customType).toType(fieldOutline.parent().parent(), Aspect.IMPLEMENTATION) : array.toType(fieldOutline.parent().parent(), Aspect.IMPLEMENTATION);
        JType itemType = array.getItemType().toType(fieldOutline.parent().parent(), Aspect.IMPLEMENTATION);
        JType[] signature = new JType[]{arrayType};
        String methodName = "copyOf" + fieldOutline.getPropertyInfo().getName(true);
        int mod = this.getVisibilityModifier();
        boolean needsToCatchException = false;
        if (mod != 4) {
            for (JMethod m : fieldOutline.parent()._package().objectFactory().methods()) {
                if (!m.name().equals(methodName) || !m.hasSignature(signature)) continue;
                return fieldOutline.parent()._package().objectFactory().staticInvoke(m);
            }
        } else {
            for (JMethod m : fieldOutline.parent().implClass.methods()) {
                if (!m.name().equals(methodName) || !m.hasSignature(signature)) continue;
                return JExpr.invoke((JMethod)m);
            }
        }
        JMethod m = mod != 4 ? fieldOutline.parent()._package().objectFactory().method(0x10 | mod, arrayType, methodName) : fieldOutline.parent().implClass.method(0x10 | mod, arrayType, methodName);
        JVar a = m.param(8, arrayType, "array");
        m.javadoc().append((Object)("Creates and returns a deep copy of a given {@code " + arrayType.binaryName() + "} instance."));
        m.javadoc().addParam(a).append((Object)"The instance to copy or {@code null}.");
        m.javadoc().addReturn().append((Object)"A deep copy of {@code array} or {@code null} if {@code array} is {@code null}.");
        JBlock body = new JBlock(false, false);
        body.directStatement("// " + PluginImpl.getMessage("title", new Object[0]));
        JConditional arrayNotNull = body._if(a.ne(JExpr._null()));
        JVar copy = arrayNotNull._then().decl(arrayType, "copy", (JExpression)JExpr.newArray((JType)itemType, (JExpression)a.ref("length")));
        JForLoop forEachItem = arrayNotNull._then()._for();
        JVar i = forEachItem.init((JType)fieldOutline.parent().parent().getCodeModel().INT, "i", a.ref("length").minus(JExpr.lit((int)1)));
        forEachItem.test(i.gte(JExpr.lit((int)0)));
        forEachItem.update(i.decr());
        JExpression copyExpr = this.getCopyExpression(fieldOutline, (CTypeInfo)array.getItemType(), forEachItem.body(), (JExpression)a.component((JExpression)i), true);
        needsToCatchException = needsToCatchException || this.tryCatchCopyExpression;
        forEachItem.body().assign((JAssignmentTarget)copy.component((JExpression)i), copyExpr);
        arrayNotNull._then()._return((JExpression)copy);
        body._return(JExpr._null());
        if (needsToCatchException) {
            JTryBlock tryCopy = m.body()._try();
            tryCopy.body().add((JStatement)body);
            JCatchBlock catchException = tryCopy._catch(fieldOutline.parent().parent().getCodeModel().ref(Exception.class));
            JVar ex = catchException.param("e");
            catchException.body()._throw((JExpression)JExpr._new((JClass)fieldOutline.parent().parent().getCodeModel().ref(AssertionError.class)).arg((JExpression)ex));
        } else {
            m.body().add((JStatement)body);
        }
        this.methodCount = this.methodCount.add(BigInteger.ONE);
        return mod != 4 ? fieldOutline.parent()._package().objectFactory().staticInvoke(m) : JExpr.invoke((JMethod)m);
    }

    private JMethod getCopyOfPropertyMethod(FieldOutline field) {
        JExpression copyExpr;
        JConditional ifInstanceOf;
        JClass javaType;
        String methodName = "copyOf" + field.getPropertyInfo().getName(true);
        JType[] signature = new JType[]{field.getRawType()};
        for (JMethod m : field.parent().implClass.methods()) {
            if (!m.name().equals(methodName) || !m.hasSignature(signature)) continue;
            return m;
        }
        JClass jaxbElement = field.parent().parent().getCodeModel().ref(JAXBElement.class);
        JClass assertionError = field.parent().parent().getCodeModel().ref(AssertionError.class);
        JMethod m = field.parent().implClass.method(this.getVisibilityModifier() | 0x10, field.getRawType(), methodName);
        JVar source = m.param(8, field.getRawType(), "source");
        m.javadoc().append((Object)("Creates and returns a deep copy of property {@code " + field.getPropertyInfo().getName(true) + "}."));
        m.javadoc().addParam(source).append((Object)"The source to copy from or {@code null}.");
        m.javadoc().addReturn().append((Object)"A deep copy of {@code source} or {@code null} if {@code source} is {@code null}.");
        m.annotate(SuppressWarnings.class).param("value", "unchecked");
        JBlock body = new JBlock(false, false);
        body.directStatement("// " + PluginImpl.getMessage("title", new Object[0]));
        JConditional sourceNotNull = body._if(source.ne(JExpr._null()));
        ArrayList<CClassInfo> referencedClassInfos = new ArrayList<CClassInfo>(field.getPropertyInfo().ref().size());
        ArrayList<CElementInfo> referencedElementInfos = new ArrayList<CElementInfo>(field.getPropertyInfo().ref().size());
        ArrayList<CElementInfo> referencedElementInfosWithClass = new ArrayList<CElementInfo>(field.getPropertyInfo().ref().size());
        ArrayList<CTypeInfo> referencedTypeInfos = new ArrayList<CTypeInfo>(field.getPropertyInfo().ref().size());
        ArrayList<JClass> referencedClassTypes = new ArrayList<JClass>(field.getPropertyInfo().ref().size());
        ArrayList<JType> referencedContentTypes = new ArrayList<JType>(field.getPropertyInfo().ref().size());
        ArrayList<JType> referencedTypes = new ArrayList<JType>(field.getPropertyInfo().ref().size());
        for (CTypeInfo type : field.getPropertyInfo().ref()) {
            if (type instanceof CElementInfo) {
                CElementInfo e = (CElementInfo)type;
                if (e.hasClass()) {
                    referencedElementInfosWithClass.add(e);
                    continue;
                }
                JType contentType = e.getContentType().toType(field.parent().parent(), Aspect.IMPLEMENTATION);
                if (referencedContentTypes.contains(contentType)) continue;
                referencedContentTypes.add(contentType);
                referencedElementInfos.add(e);
                continue;
            }
            if (type instanceof CClassInfo) {
                CClassInfo c = (CClassInfo)type;
                JClass classType = c.toType(field.parent().parent(), Aspect.IMPLEMENTATION);
                if (referencedClassTypes.contains(classType)) continue;
                referencedClassTypes.add(classType);
                referencedClassInfos.add(c);
                continue;
            }
            JType javaType2 = type.toType(field.parent().parent(), Aspect.IMPLEMENTATION);
            if (referencedTypes.contains(javaType2)) continue;
            referencedTypes.add(javaType2);
            referencedTypeInfos.add(type);
        }
        Collections.sort(referencedClassInfos, new CClassInfoComparator(field.parent().parent()));
        Collections.sort(referencedElementInfos, new CElementInfoComparator(field.parent().parent(), false));
        Collections.sort(referencedElementInfosWithClass, new CElementInfoComparator(field.parent().parent(), true));
        Collections.sort(referencedTypeInfos, new CTypeInfoComparator(field.parent().parent()));
        Collections.reverse(referencedClassInfos);
        Collections.reverse(referencedElementInfos);
        Collections.reverse(referencedElementInfosWithClass);
        Collections.reverse(referencedTypeInfos);
        boolean needsToCatchException = false;
        if (!referencedElementInfos.isEmpty() || !referencedElementInfosWithClass.isEmpty()) {
            JExpression copyExpr2;
            JConditional ifInstanceOf2;
            JBlock elementBlock = sourceNotNull._then()._if(source._instanceof((JType)jaxbElement))._then();
            if (!referencedElementInfosWithClass.isEmpty()) {
                elementBlock.directStatement("// Referenced elements with classes.");
                for (CElementInfo elementInfo : referencedElementInfosWithClass) {
                    JType elementType = elementInfo.toType(field.parent().parent(), Aspect.IMPLEMENTATION);
                    ifInstanceOf2 = elementBlock._if(source._instanceof(elementType));
                    copyExpr2 = this.getCopyExpression(field, (CTypeInfo)elementInfo, ifInstanceOf2._then(), (JExpression)JExpr.cast((JType)elementType, (JExpression)source), false);
                    boolean bl = needsToCatchException = needsToCatchException || this.tryCatchCopyExpression;
                    if (copyExpr2 == null) {
                        this.log(Level.SEVERE, "cannotCopyProperty", field.getPropertyInfo().getName(true), field.parent().implClass.binaryName());
                        continue;
                    }
                    ifInstanceOf2._then()._return(copyExpr2);
                }
            }
            if (!referencedElementInfos.isEmpty()) {
                elementBlock.directStatement("// Referenced elements without classes.");
                for (CElementInfo elementInfo : referencedElementInfos) {
                    JType contentType = elementInfo.getAdapterUse() != null && elementInfo.getAdapterUse().customType != null ? ((NType)elementInfo.getAdapterUse().customType).toType(field.parent().parent(), Aspect.IMPLEMENTATION) : elementInfo.getContentType().toType(field.parent().parent(), Aspect.IMPLEMENTATION);
                    ifInstanceOf2 = elementBlock._if(JExpr.invoke((JExpression)JExpr.cast((JType)jaxbElement, (JExpression)source), (String)"getValue")._instanceof(contentType));
                    copyExpr2 = this.getCopyExpression(field, (CTypeInfo)elementInfo, ifInstanceOf2._then(), (JExpression)JExpr.cast((JType)jaxbElement, (JExpression)source), false);
                    boolean bl = needsToCatchException = needsToCatchException || this.tryCatchCopyExpression;
                    if (copyExpr2 == null) {
                        this.log(Level.SEVERE, "cannotCopyProperty", field.getPropertyInfo().getName(true), field.parent().implClass.binaryName());
                        continue;
                    }
                    ifInstanceOf2._then()._return(copyExpr2);
                }
            }
        }
        for (CClassInfo classInfo : referencedClassInfos) {
            javaType = classInfo.getAdapterUse() != null && classInfo.getAdapterUse().customType != null ? ((NType)classInfo.getAdapterUse().customType).toType(field.parent().parent(), Aspect.IMPLEMENTATION) : classInfo.toType(field.parent().parent(), Aspect.IMPLEMENTATION);
            ifInstanceOf = sourceNotNull._then()._if(source._instanceof((JType)javaType));
            copyExpr = this.getCopyExpression(field, (CTypeInfo)classInfo, ifInstanceOf._then(), (JExpression)JExpr.cast((JType)javaType, (JExpression)source), false);
            boolean bl = needsToCatchException = needsToCatchException || this.tryCatchCopyExpression;
            if (copyExpr == null) {
                this.log(Level.SEVERE, "cannotCopyProperty", field.getPropertyInfo().getName(true), field.parent().implClass.binaryName());
                continue;
            }
            ifInstanceOf._then()._return(copyExpr);
        }
        for (CTypeInfo typeInfo : referencedTypeInfos) {
            javaType = typeInfo.toType(field.parent().parent(), Aspect.IMPLEMENTATION);
            ifInstanceOf = sourceNotNull._then()._if(source._instanceof((JType)javaType));
            copyExpr = this.getCopyExpression(field, typeInfo, ifInstanceOf._then(), (JExpression)JExpr.cast((JType)javaType, (JExpression)source), false);
            boolean bl = needsToCatchException = needsToCatchException || this.tryCatchCopyExpression;
            if (copyExpr == null) {
                this.log(Level.SEVERE, "cannotCopyProperty", field.getPropertyInfo().getName(true), field.parent().implClass.binaryName());
                continue;
            }
            ifInstanceOf._then()._return(copyExpr);
        }
        sourceNotNull._then().directStatement("// Please report this at " + PluginImpl.getMessage("bugtrackerUrl", new Object[0]));
        sourceNotNull._then()._throw((JExpression)JExpr._new((JClass)assertionError).arg(JExpr.lit((String)"Unexpected instance '").plus((JExpression)source).plus(JExpr.lit((String)("' for property '" + field.getPropertyInfo().getName(true) + "' of class '" + field.parent().implClass.binaryName() + "'.")))));
        body._return(JExpr._null());
        if (needsToCatchException) {
            JTryBlock tryCopy = m.body()._try();
            tryCopy.body().add((JStatement)body);
            JCatchBlock catchException = tryCopy._catch(field.parent().parent().getCodeModel().ref(Exception.class));
            JVar ex = catchException.param("e");
            catchException.body()._throw((JExpression)JExpr._new((JClass)field.parent().parent().getCodeModel().ref(AssertionError.class)).arg((JExpression)ex));
        } else {
            m.body().add((JStatement)body);
        }
        this.methodCount = this.methodCount.add(BigInteger.ONE);
        return m;
    }

    private JMethod getCopyOfCollectionMethod(FieldOutline field) {
        JExpression copyExpr;
        JConditional ifInstanceOf;
        JClass javaType;
        JVar next;
        JVar it;
        JForLoop copyLoop;
        JVar copy;
        JConditional sourceNotEmpty;
        JType[] signature;
        String methodName;
        if (field.getRawType().isArray()) {
            methodName = "copyOf" + field.getPropertyInfo().getName(true);
            signature = new JType[]{field.getRawType()};
        } else {
            methodName = "copy" + field.getPropertyInfo().getName(true);
            signature = new JType[]{field.getRawType(), field.getRawType()};
        }
        for (JMethod m : field.parent().implClass.methods()) {
            if (!m.name().equals(methodName) || !m.hasSignature(signature)) continue;
            return m;
        }
        JClass object = field.parent().parent().getCodeModel().ref(Object.class);
        JClass array = field.parent().parent().getCodeModel().ref(Array.class);
        JClass jaxbElement = field.parent().parent().getCodeModel().ref(JAXBElement.class);
        JClass nullPointerException = field.parent().parent().getCodeModel().ref(NullPointerException.class);
        JClass assertionError = field.parent().parent().getCodeModel().ref(AssertionError.class);
        JMethod m = field.getRawType().isArray() ? field.parent().implClass.method(this.getVisibilityModifier() | 0x10, field.getRawType(), methodName) : field.parent().implClass.method(this.getVisibilityModifier() | 0x10, Void.TYPE, methodName);
        JVar source = m.param(8, field.getRawType(), "source");
        JVar target = field.getRawType().isArray() ? null : m.param(8, field.getRawType(), "target");
        m.body().directStatement("// " + PluginImpl.getMessage("title", new Object[0]));
        m.javadoc().append((Object)("Copies all values of property {@code " + field.getPropertyInfo().getName(true) + "} deeply."));
        m.javadoc().addParam(source).append((Object)"The source to copy from.");
        if (!field.getRawType().isArray()) {
            m.javadoc().addParam(target).append((Object)"The target to copy {@code source} to.");
            m.javadoc().addThrows(nullPointerException).append((Object)"if {@code target} is {@code null}.");
        } else {
            m.javadoc().addReturn().append((Object)"A deep copy of {@code source} or {@code null}.");
        }
        m.annotate(SuppressWarnings.class).param("value", "unchecked");
        JBlock body = new JBlock(false, false);
        ArrayList<CClassInfo> referencedClassInfos = new ArrayList<CClassInfo>(field.getPropertyInfo().ref().size());
        ArrayList<CElementInfo> referencedElementInfos = new ArrayList<CElementInfo>(field.getPropertyInfo().ref().size());
        ArrayList<CElementInfo> referencedElementInfosWithClass = new ArrayList<CElementInfo>(field.getPropertyInfo().ref().size());
        ArrayList<CTypeInfo> referencedTypeInfos = new ArrayList<CTypeInfo>(field.getPropertyInfo().ref().size());
        ArrayList<JClass> referencedClassTypes = new ArrayList<JClass>(field.getPropertyInfo().ref().size());
        ArrayList<JType> referencedContentTypes = new ArrayList<JType>(field.getPropertyInfo().ref().size());
        ArrayList<JType> referencedTypes = new ArrayList<JType>(field.getPropertyInfo().ref().size());
        for (CTypeInfo type : field.getPropertyInfo().ref()) {
            if (type instanceof CElementInfo) {
                CElementInfo e = (CElementInfo)type;
                if (e.hasClass()) {
                    referencedElementInfosWithClass.add(e);
                    continue;
                }
                JType contentType = e.getContentType().toType(field.parent().parent(), Aspect.IMPLEMENTATION);
                if (referencedContentTypes.contains(contentType)) continue;
                referencedContentTypes.add(contentType);
                referencedElementInfos.add(e);
                continue;
            }
            if (type instanceof CClassInfo) {
                CClassInfo c = (CClassInfo)type;
                JClass classType = c.toType(field.parent().parent(), Aspect.IMPLEMENTATION);
                if (referencedClassTypes.contains(classType)) continue;
                referencedClassTypes.add(classType);
                referencedClassInfos.add(c);
                continue;
            }
            JType javaType2 = type.toType(field.parent().parent(), Aspect.IMPLEMENTATION);
            if (referencedTypes.contains(javaType2)) continue;
            referencedTypes.add(javaType2);
            referencedTypeInfos.add(type);
        }
        Collections.sort(referencedClassInfos, new CClassInfoComparator(field.parent().parent()));
        Collections.sort(referencedElementInfos, new CElementInfoComparator(field.parent().parent(), false));
        Collections.sort(referencedElementInfosWithClass, new CElementInfoComparator(field.parent().parent(), true));
        Collections.sort(referencedTypeInfos, new CTypeInfoComparator(field.parent().parent()));
        Collections.reverse(referencedClassInfos);
        Collections.reverse(referencedElementInfos);
        Collections.reverse(referencedElementInfosWithClass);
        Collections.reverse(referencedTypeInfos);
        boolean needsToCatchException = false;
        if (field.getRawType().isArray()) {
            sourceNotEmpty = body._if(source.ne(JExpr._null()).cand(source.ref("length").gt(JExpr.lit((int)0))));
            copy = sourceNotEmpty._then().decl(8, source.type(), "copy", (JExpression)JExpr.cast((JType)source.type(), (JExpression)array.staticInvoke("newInstance").arg((JExpression)source.invoke("getClass").invoke("getComponentType")).arg((JExpression)source.ref("length"))));
            copyLoop = sourceNotEmpty._then()._for();
            it = copyLoop.init((JType)field.parent().parent().getCodeModel().INT, "i", source.ref("length").minus(JExpr.lit((int)1)));
            copyLoop.test(it.gte(JExpr.lit((int)0)));
            copyLoop.update(it.decr());
            next = copyLoop.body().decl(8, (JType)object, "next", (JExpression)source.component((JExpression)it));
        } else {
            sourceNotEmpty = body._if(source.ne(JExpr._null()).cand(JExpr.invoke((JExpression)source, (String)"isEmpty").not()));
            copyLoop = sourceNotEmpty._then()._for();
            it = copyLoop.init(8, (JType)field.parent().parent().getCodeModel().ref(Iterator.class).narrow(field.parent().parent().getCodeModel().wildcard()), "it", (JExpression)source.invoke("iterator"));
            copyLoop.test((JExpression)JExpr.invoke((JExpression)it, (String)"hasNext"));
            next = copyLoop.body().decl(8, (JType)object, "next", (JExpression)JExpr.invoke((JExpression)it, (String)"next"));
            copy = null;
        }
        if (!referencedElementInfos.isEmpty() || !referencedElementInfosWithClass.isEmpty()) {
            JExpression copyExpr2;
            JConditional ifInstanceOf2;
            JBlock copyBlock = copyLoop.body()._if(next._instanceof((JType)jaxbElement))._then();
            if (!referencedElementInfosWithClass.isEmpty()) {
                copyBlock.directStatement("// Referenced elements with classes.");
                for (CElementInfo elementInfo : referencedElementInfosWithClass) {
                    JType elementType = elementInfo.toType(field.parent().parent(), Aspect.IMPLEMENTATION);
                    ifInstanceOf2 = copyBlock._if(next._instanceof(elementType));
                    copyExpr2 = this.getCopyExpression(field, (CTypeInfo)elementInfo, ifInstanceOf2._then(), (JExpression)JExpr.cast((JType)elementType, (JExpression)next), false);
                    boolean bl = needsToCatchException = needsToCatchException || this.tryCatchCopyExpression;
                    if (copyExpr2 == null) {
                        this.log(Level.SEVERE, "cannotCopyProperty", field.getPropertyInfo().getName(true), field.parent().implClass.binaryName());
                        continue;
                    }
                    if (field.getRawType().isArray()) {
                        ifInstanceOf2._then().assign((JAssignmentTarget)copy.component((JExpression)it), copyExpr2);
                    } else {
                        ifInstanceOf2._then().invoke((JExpression)target, "add").arg(copyExpr2);
                    }
                    ifInstanceOf2._then()._continue();
                }
            }
            if (!referencedElementInfos.isEmpty()) {
                copyBlock.directStatement("// Referenced elements without classes.");
                for (CElementInfo elementInfo : referencedElementInfos) {
                    JType contentType = elementInfo.getAdapterUse() != null && elementInfo.getAdapterUse().customType != null ? ((NType)elementInfo.getAdapterUse().customType).toType(field.parent().parent(), Aspect.IMPLEMENTATION) : elementInfo.getContentType().toType(field.parent().parent(), Aspect.IMPLEMENTATION);
                    ifInstanceOf2 = copyBlock._if(JExpr.invoke((JExpression)JExpr.cast((JType)jaxbElement, (JExpression)next), (String)"getValue")._instanceof(contentType));
                    copyExpr2 = this.getCopyExpression(field, (CTypeInfo)elementInfo, ifInstanceOf2._then(), (JExpression)JExpr.cast((JType)jaxbElement, (JExpression)next), false);
                    boolean bl = needsToCatchException = needsToCatchException || this.tryCatchCopyExpression;
                    if (copyExpr2 == null) {
                        this.log(Level.SEVERE, "cannotCopyProperty", field.getPropertyInfo().getName(true), field.parent().implClass.binaryName());
                    } else if (field.getRawType().isArray()) {
                        ifInstanceOf2._then().assign((JAssignmentTarget)copy.component((JExpression)it), copyExpr2);
                    } else {
                        ifInstanceOf2._then().invoke((JExpression)target, "add").arg(copyExpr2);
                    }
                    ifInstanceOf2._then()._continue();
                }
            }
        }
        for (CClassInfo classInfo : referencedClassInfos) {
            javaType = classInfo.getAdapterUse() != null && classInfo.getAdapterUse().customType != null ? ((NType)classInfo.getAdapterUse().customType).toType(field.parent().parent(), Aspect.IMPLEMENTATION) : classInfo.toType(field.parent().parent(), Aspect.IMPLEMENTATION);
            ifInstanceOf = copyLoop.body()._if(next._instanceof((JType)javaType));
            copyExpr = this.getCopyExpression(field, (CTypeInfo)classInfo, ifInstanceOf._then(), (JExpression)JExpr.cast((JType)javaType, (JExpression)next), false);
            boolean bl = needsToCatchException = needsToCatchException || this.tryCatchCopyExpression;
            if (copyExpr == null) {
                this.log(Level.SEVERE, "cannotCopyProperty", field.getPropertyInfo().getName(true), field.parent().implClass.binaryName());
            } else if (field.getRawType().isArray()) {
                ifInstanceOf._then().assign((JAssignmentTarget)copy.component((JExpression)it), copyExpr);
            } else {
                ifInstanceOf._then().invoke((JExpression)target, "add").arg(copyExpr);
            }
            ifInstanceOf._then()._continue();
        }
        for (CTypeInfo typeInfo : referencedTypeInfos) {
            javaType = typeInfo.toType(field.parent().parent(), Aspect.IMPLEMENTATION);
            ifInstanceOf = copyLoop.body()._if(next._instanceof((JType)javaType));
            copyExpr = this.getCopyExpression(field, typeInfo, ifInstanceOf._then(), (JExpression)JExpr.cast((JType)javaType, (JExpression)next), false);
            boolean bl = needsToCatchException = needsToCatchException || this.tryCatchCopyExpression;
            if (copyExpr == null) {
                this.log(Level.SEVERE, "cannotCopyProperty", field.getPropertyInfo().getName(true), field.parent().implClass.binaryName());
            } else if (field.getRawType().isArray()) {
                ifInstanceOf._then().assign((JAssignmentTarget)copy.component((JExpression)it), copyExpr);
            } else {
                ifInstanceOf._then().invoke((JExpression)target, "add").arg(copyExpr);
            }
            ifInstanceOf._then()._continue();
        }
        copyLoop.body().directStatement("// Please report this at " + PluginImpl.getMessage("bugtrackerUrl", new Object[0]));
        copyLoop.body()._throw((JExpression)JExpr._new((JClass)assertionError).arg(JExpr.lit((String)"Unexpected instance '").plus((JExpression)next).plus(JExpr.lit((String)("' for property '" + field.getPropertyInfo().getName(true) + "' of class '" + field.parent().implClass.binaryName() + "'.")))));
        if (field.getRawType().isArray()) {
            sourceNotEmpty._then()._return((JExpression)copy);
            body._return(JExpr._null());
        }
        if (needsToCatchException) {
            JTryBlock tryCopy = m.body()._try();
            tryCopy.body().add((JStatement)body);
            JCatchBlock catchException = tryCopy._catch(field.parent().parent().getCodeModel().ref(Exception.class));
            JVar ex = catchException.param("e");
            catchException.body()._throw((JExpression)JExpr._new((JClass)field.parent().parent().getCodeModel().ref(AssertionError.class)).arg((JExpression)ex));
        } else {
            m.body().add((JStatement)body);
        }
        this.methodCount = this.methodCount.add(BigInteger.ONE);
        return m;
    }

    private JExpression getCopyExpression(FieldOutline fieldOutline, CTypeInfo type, JBlock block, JExpression sourceExpr, boolean sourceMaybeNull) {
        JExpression expr = null;
        this.tryCatchCopyExpression = false;
        if (type instanceof CBuiltinLeafInfo) {
            expr = this.getBuiltinCopyExpression(fieldOutline, (CBuiltinLeafInfo)type, block, sourceExpr, sourceMaybeNull);
        } else if (type instanceof CWildcardTypeInfo) {
            expr = this.getWildcardCopyExpression(fieldOutline, (CWildcardTypeInfo)type, block, sourceExpr, sourceMaybeNull);
        } else if (type instanceof CClassInfo) {
            expr = this.getClassInfoCopyExpression(fieldOutline, (CClassInfo)type, block, sourceExpr, sourceMaybeNull);
        } else if (type instanceof CEnumLeafInfo) {
            expr = this.getEnumLeafInfoCopyExpression(fieldOutline, (CEnumLeafInfo)type, block, sourceExpr);
        } else if (type instanceof CArrayInfo) {
            expr = this.getArrayCopyExpression(fieldOutline, (CArrayInfo)type, block, sourceExpr);
        } else if (type instanceof CElementInfo) {
            expr = this.getElementCopyExpression(fieldOutline, (CElementInfo)type, block, sourceExpr);
        } else if (type instanceof CNonElement) {
            expr = this.getNonElementCopyExpression(fieldOutline, (CNonElement)type, block, sourceExpr, sourceMaybeNull);
        } else if (type instanceof CAdapterInfo) {
            expr = this.getAdapterInfoCopyExpression(fieldOutline, (CAdapterInfo)type, block, sourceExpr);
        }
        if (expr != null) {
            this.expressionCount = this.expressionCount.add(BigInteger.ONE);
        }
        return expr;
    }

    private JExpression getBuiltinCopyExpression(FieldOutline fieldOutline, CBuiltinLeafInfo type, JBlock block, JExpression sourceExpr, boolean sourceMaybeNull) {
        Object expr = null;
        block.directStatement("// CBuiltinLeafInfo: " + type.toType(fieldOutline.parent().parent(), Aspect.IMPLEMENTATION).binaryName());
        if (type == CBuiltinLeafInfo.ANYTYPE) {
            expr = this.getCopyOfObjectInvocation(fieldOutline.parent()).arg(sourceExpr);
        } else if (type == CBuiltinLeafInfo.BASE64_BYTE_ARRAY) {
            JClass byteArray = fieldOutline.parent().parent().getCodeModel().ref(byte[].class);
            expr = this.getCopyOfPrimitiveArrayExpression(fieldOutline.parent(), byteArray, sourceExpr);
        } else if (type == CBuiltinLeafInfo.BIG_DECIMAL || type == CBuiltinLeafInfo.BIG_INTEGER || type == CBuiltinLeafInfo.STRING || type == CBuiltinLeafInfo.BOOLEAN || type == CBuiltinLeafInfo.INT || type == CBuiltinLeafInfo.LONG || type == CBuiltinLeafInfo.BYTE || type == CBuiltinLeafInfo.SHORT || type == CBuiltinLeafInfo.FLOAT || type == CBuiltinLeafInfo.DOUBLE) {
            expr = sourceExpr;
        } else if (type == CBuiltinLeafInfo.QNAME) {
            expr = sourceExpr;
        } else if (type == CBuiltinLeafInfo.CALENDAR) {
            JClass xmlCal = fieldOutline.parent().parent().getCodeModel().ref(XMLGregorianCalendar.class);
            expr = sourceMaybeNull ? JOp.cond((JExpression)sourceExpr.eq(JExpr._null()), (JExpression)JExpr._null(), (JExpression)JExpr.cast((JType)xmlCal, (JExpression)sourceExpr.invoke("clone"))) : JExpr.cast((JType)xmlCal, (JExpression)sourceExpr.invoke("clone"));
        } else if (type == CBuiltinLeafInfo.DURATION) {
            expr = sourceExpr;
        } else if (type == CBuiltinLeafInfo.DATA_HANDLER || type == CBuiltinLeafInfo.IMAGE || type == CBuiltinLeafInfo.XML_SOURCE) {
            this.log(Level.WARNING, "cannotCopyType", type.toType(fieldOutline.parent().parent(), Aspect.IMPLEMENTATION).fullName(), fieldOutline.getPropertyInfo().getName(true), fieldOutline.parent().implClass.fullName());
            expr = sourceExpr;
        }
        return expr;
    }

    private JExpression getWildcardCopyExpression(FieldOutline fieldOutline, CWildcardTypeInfo type, JBlock block, JExpression sourceExpr, boolean sourceMaybeNull) {
        block.directStatement("// CWildcardTypeInfo: " + type.toType(fieldOutline.parent().parent(), Aspect.IMPLEMENTATION).binaryName());
        if (sourceMaybeNull) {
            return JOp.cond((JExpression)sourceExpr.eq(JExpr._null()), (JExpression)JExpr._null(), (JExpression)JExpr.cast((JType)fieldOutline.parent().parent().getCodeModel().ref(Element.class), (JExpression)sourceExpr.invoke("cloneNode").arg(JExpr.TRUE)));
        }
        return JExpr.cast((JType)fieldOutline.parent().parent().getCodeModel().ref(Element.class), (JExpression)sourceExpr.invoke("cloneNode").arg(JExpr.TRUE));
    }

    private JExpression getClassInfoCopyExpression(FieldOutline fieldOutline, CClassInfo type, JBlock block, JExpression sourceExpr, boolean sourceMaybeNull) {
        block.directStatement("// CClassInfo: " + type.toType(fieldOutline.parent().parent(), Aspect.IMPLEMENTATION).binaryName());
        if (sourceMaybeNull) {
            return JOp.cond((JExpression)sourceExpr.eq(JExpr._null()), (JExpression)JExpr._null(), (JExpression)sourceExpr.invoke("clone"));
        }
        return sourceExpr.invoke("clone");
    }

    private JExpression getNonElementCopyExpression(FieldOutline fieldOutline, CNonElement type, JBlock block, JExpression sourceExpr, boolean sourceMaybeNull) {
        JType jType = type.toType(fieldOutline.parent().parent(), Aspect.IMPLEMENTATION);
        block.directStatement("// CNonElement: " + jType.binaryName());
        block.directStatement("// CC-XJC WARNING: The '" + jType.binaryName() + "'");
        block.directStatement("// CC-XJC WARNING: type was not part of the compilation unit.");
        block.directStatement("// CC-XJC WARNING: The CC-XJC plugin assumes that type to declare a 'public Object clone()' method.");
        block.directStatement("// CC-XJC WARNING: If this warning is part of an 'if instanceof' block, the order of 'if instanceof'");
        block.directStatement("// CC-XJC WARNING: statements may be wrong and must be verified.");
        this.log(Level.WARNING, "nonElementWarning", fieldOutline.parent().implClass.fullName(), fieldOutline.getPropertyInfo().getName(true), jType.binaryName(), WARNING_PREFIX);
        this.tryCatchCopyExpression = true;
        if (sourceMaybeNull) {
            return JOp.cond((JExpression)sourceExpr.eq(JExpr._null()), (JExpression)JExpr._null(), (JExpression)JExpr.cast((JType)jType, (JExpression)sourceExpr.invoke("clone")));
        }
        return JExpr.cast((JType)jType, (JExpression)sourceExpr.invoke("clone"));
    }

    private JExpression getArrayCopyExpression(FieldOutline fieldOutline, CArrayInfo type, JBlock block, JExpression sourceExpr) {
        block.directStatement("// CArrayInfo: " + type.fullName());
        return this.getCopyOfArrayInfoInvocation(fieldOutline, type).arg(sourceExpr);
    }

    private JExpression getElementCopyExpression(FieldOutline fieldOutline, CElementInfo type, JBlock block, JExpression sourceExpr) {
        block.directStatement("// CElementInfo: " + type.toType(fieldOutline.parent().parent(), Aspect.IMPLEMENTATION).binaryName());
        return this.getCopyOfElementInfoInvocation(fieldOutline, type).arg(sourceExpr);
    }

    private JExpression getEnumLeafInfoCopyExpression(FieldOutline fieldOutline, CEnumLeafInfo type, JBlock block, JExpression sourceExpr) {
        block.directStatement("// CEnumLeafInfo: " + type.toType(fieldOutline.parent().parent(), Aspect.IMPLEMENTATION).binaryName());
        return sourceExpr;
    }

    private JExpression getAdapterInfoCopyExpression(FieldOutline fieldOutline, CAdapterInfo type, JBlock block, JExpression source) {
        block.directStatement("// CAdapterInfo: " + type.toType(fieldOutline.parent().parent(), Aspect.IMPLEMENTATION).binaryName());
        JType jType = type.toType(fieldOutline.parent().parent(), Aspect.IMPLEMENTATION);
        return JExpr.cast((JType)jType, (JExpression)this.getCopyOfObjectInvocation(fieldOutline.parent()).arg(source));
    }

    private JMethod generateStandardConstructor(ClassOutline clazz) {
        JMethod ctor = clazz.implClass.constructor(1);
        ctor.body().directStatement("// " + PluginImpl.getMessage("title", new Object[0]));
        ctor.body().invoke("super");
        ctor.javadoc().add((Object)("Creates a new {@code " + clazz.implClass.name() + "} instance."));
        this.constructorCount = this.constructorCount.add(BigInteger.ONE);
        return ctor;
    }

    private JMethod generateCopyConstructor(ClassOutline clazz) {
        JMethod ctor = clazz.implClass.constructor(1);
        JDefinedClass paramClass = this.hierarchical ? this.getSupertype((JClass)clazz.implClass) : clazz.implClass;
        JVar o = ctor.param(8, (JType)paramClass, "o");
        boolean superTypeParam = !clazz.implClass.equals(paramClass);
        ctor.javadoc().add((Object)("Creates a new {@code " + clazz.implClass.name() + "} instance by deeply copying a given {@code " + paramClass.name() + "} instance.\n"));
        if (!this.nullable) {
            ctor.javadoc().addParam(o).add((Object)"The instance to copy.");
            ctor.javadoc().addThrows(NullPointerException.class).append((Object)"if {@code o} is {@code null}.");
        } else {
            ctor.javadoc().addParam(o).add((Object)"The instance to copy or {@code null}.");
        }
        ctor.body().directStatement("// " + PluginImpl.getMessage("title", new Object[0]));
        if (this.needsWarningOnReferencedSupertypes(clazz)) {
            ctor.body().directStatement("// CC-XJC WARNING: A super-class of this class was not part of the compilation unit.");
            ctor.body().directStatement("// CC-XJC WARNING: The plugin assumes this super-class to directly extend class 'java.lang.Object'.");
            ctor.body().directStatement("// CC-XJC WARNING: The type of the constructor arguments (type of o) in the hierarchy this constructor is part");
            ctor.body().directStatement("// CC-XJC WARNING: of may be wrong and must be verified.");
        }
        if (clazz.getSuperClass() != null || clazz.implClass._extends() != null && !clazz.implClass._extends().binaryName().equals("java.lang.Object")) {
            ctor.body().invoke("super").arg((JExpression)o);
        } else {
            ctor.body().invoke("super");
        }
        if (!this.nullable) {
            ctor.body()._if(o.eq(JExpr._null()))._then()._throw((JExpression)JExpr._new((JClass)clazz.parent().getCodeModel().ref(NullPointerException.class)).arg("Cannot create a copy of '" + clazz.implClass.name() + "' from 'null'."));
        }
        this.contextExceptions.clear();
        boolean hasFields = false;
        if (!clazz.implClass.fields().isEmpty()) {
            JBlock copyBlock = new JBlock(false, false);
            JVar source = superTypeParam ? JExpr.cast((JType)clazz.implClass, (JExpression)o) : o;
            for (FieldOutline field : clazz.getDeclaredFields()) {
                hasFields = true;
                this.generateCopyOfProperty(field, JExpr._this(), (JExpression)source, copyBlock, false);
            }
            for (JFieldVar field : clazz.implClass.fields().values()) {
                if ((field.mods().getValue() & 0x10) == 16) continue;
                hasFields = true;
                FieldOutline fieldOutline = this.getFieldOutline(clazz, field.name());
                if (fieldOutline != null) continue;
                if (field.type().isPrimitive()) {
                    copyBlock.directStatement("// Unknown primitive field '" + field.name() + "'.");
                    copyBlock.assign((JAssignmentTarget)JExpr.refthis((String)field.name()), (JExpression)source.ref((JVar)field));
                    this.log(Level.WARNING, "fieldWithoutProperties", field.name(), clazz.implClass.name());
                    continue;
                }
                if (field.name().equals("otherAttributes") && clazz.target.declaresAttributeWildcard()) {
                    copyBlock.directStatement("// Other attributes.");
                    copyBlock.add((JStatement)JExpr.refthis((String)field.name()).invoke("putAll").arg((JExpression)source.ref((JVar)field)));
                    continue;
                }
                copyBlock.directStatement("// Unknown reference field '" + field.name() + "'.");
                copyBlock.assign((JAssignmentTarget)JExpr.refthis((String)field.name()), (JExpression)JExpr.cast((JType)field.type(), (JExpression)this.getCopyOfObjectInvocation(clazz).arg((JExpression)source.ref((JVar)field))));
                this.log(Level.WARNING, "fieldWithoutProperties", field.name(), clazz.implClass.name());
            }
            if (hasFields) {
                JBlock effective = ctor.body();
                if (!this.contextExceptions.isEmpty()) {
                    JTryBlock tryCopy = ctor.body()._try();
                    effective = tryCopy.body();
                    if (this.contextExceptions.contains(Exception.class)) {
                        this.contextExceptions.retainAll(Arrays.asList(Exception.class));
                    }
                    for (Class<?> e : this.contextExceptions) {
                        JCatchBlock catchBlock = tryCopy._catch(clazz.parent().getCodeModel().ref(e));
                        catchBlock.body().directStatement("// Please report this at " + PluginImpl.getMessage("bugtrackerUrl", new Object[0]));
                        catchBlock.body()._throw((JExpression)JExpr._new((JClass)clazz.parent().getCodeModel().ref(AssertionError.class)).arg((JExpression)catchBlock.param("e")));
                    }
                }
                if (superTypeParam) {
                    effective._if(o._instanceof((JType)clazz.implClass))._then().add((JStatement)copyBlock);
                } else if (this.nullable) {
                    effective._if(o.ne(JExpr._null()))._then().add((JStatement)copyBlock);
                } else {
                    effective.add((JStatement)copyBlock);
                }
            }
        }
        this.constructorCount = this.constructorCount.add(BigInteger.ONE);
        return ctor;
    }

    private void warnOnReferencedSupertypes(ClassOutline clazz) {
        if (clazz.getSuperClass() == null && clazz.implClass._extends() != null && !clazz.implClass._extends().binaryName().equals("java.lang.Object")) {
            this.log(Level.WARNING, "referencedSupertypeWarning", clazz.implClass.fullName(), clazz.implClass._extends().binaryName(), WARNING_PREFIX);
        }
        if (clazz.getSuperClass() != null) {
            this.warnOnReferencedSupertypes(clazz.getSuperClass());
        }
    }

    private boolean needsWarningOnReferencedSupertypes(ClassOutline clazz) {
        if (clazz.getSuperClass() == null && clazz.implClass._extends() != null && !clazz.implClass._extends().binaryName().equals("java.lang.Object")) {
            return true;
        }
        if (clazz.getSuperClass() != null) {
            return this.needsWarningOnReferencedSupertypes(clazz.getSuperClass());
        }
        return false;
    }

    private JClass getSupertype(JClass clazz) {
        if (clazz._extends() != null && !clazz._extends().binaryName().equals("java.lang.Object")) {
            return this.getSupertype(clazz._extends());
        }
        return clazz;
    }

    private JMethod generateCloneMethod(ClassOutline clazz) {
        JMethod cloneMethod = clazz.implClass.method(1, (JType)clazz.implClass, "clone");
        cloneMethod.annotate(Override.class);
        clazz.implClass._implements(clazz.parent().getCodeModel().ref(Cloneable.class));
        cloneMethod.javadoc().append((Object)"Creates and returns a deep copy of this object.\n");
        cloneMethod.javadoc().addReturn().append((Object)"A deep copy of this object.");
        this.contextExceptions.clear();
        if (clazz.getSuperClass() == null || clazz.getSuperClass().implClass.binaryName().equals("java.lang.Object") || clazz.implClass._extends() != null && clazz.implClass._extends().binaryName().equals("java.lang.Object")) {
            this.contextExceptions.add(CloneNotSupportedException.class);
        }
        JBlock copyBlock = new JBlock(false, false);
        copyBlock.directStatement("// " + PluginImpl.getMessage("title", new Object[0]));
        JVar clone = copyBlock.decl(8, (JType)clazz.implClass, "clone", (JExpression)JExpr.cast((JType)clazz.implClass, (JExpression)JExpr._super().invoke("clone")));
        for (FieldOutline field : clazz.getDeclaredFields()) {
            this.generateCopyOfProperty(field, (JExpression)clone, JExpr._this(), copyBlock, true);
        }
        for (JFieldVar field : clazz.implClass.fields().values()) {
            FieldOutline fieldOutline;
            if ((field.mods().getValue() & 0x10) == 16 || (fieldOutline = this.getFieldOutline(clazz, field.name())) != null) continue;
            if (field.type().isPrimitive()) {
                copyBlock.directStatement("// Unknown primitive field '" + field.name() + "'.");
                copyBlock.assign((JAssignmentTarget)clone.ref(field.name()), (JExpression)JExpr.refthis((String)field.name()));
                continue;
            }
            if (field.name().equals("otherAttributes") && clazz.target.declaresAttributeWildcard()) {
                copyBlock.directStatement("// Other attributes.");
                copyBlock.add((JStatement)clone.ref(field.name()).invoke("putAll").arg((JExpression)JExpr.refthis((String)field.name())));
                continue;
            }
            copyBlock.directStatement("// Unknown reference field '" + field.name() + "'.");
            copyBlock.assign((JAssignmentTarget)clone.ref(field.name()), (JExpression)JExpr.cast((JType)field.type(), (JExpression)this.getCopyOfObjectInvocation(clazz).arg((JExpression)JExpr.refthis((String)field.name()))));
        }
        copyBlock._return((JExpression)clone);
        if (!this.contextExceptions.isEmpty()) {
            JTryBlock tryCopy = cloneMethod.body()._try();
            tryCopy.body().add((JStatement)copyBlock);
            if (this.contextExceptions.contains(Exception.class)) {
                this.contextExceptions.retainAll(Arrays.asList(Exception.class));
            }
            for (Class<?> e : this.contextExceptions) {
                JCatchBlock catchBlock = tryCopy._catch(clazz.parent().getCodeModel().ref(e));
                catchBlock.body().directStatement("// Please report this at " + PluginImpl.getMessage("bugtrackerUrl", new Object[0]));
                catchBlock.body()._throw((JExpression)JExpr._new((JClass)clazz.parent().getCodeModel().ref(AssertionError.class)).arg((JExpression)catchBlock.param("e")));
            }
        } else {
            cloneMethod.body().add((JStatement)copyBlock);
        }
        this.methodCount = this.methodCount.add(BigInteger.ONE);
        return cloneMethod;
    }

    private void generateCopyOfProperty(FieldOutline field, JExpression targetExpr, JExpression sourceExpr, JBlock block, boolean cloneMethod) {
        JMethod getter = this.getPropertyGetter(field);
        if (getter != null) {
            if (field.getPropertyInfo().isCollection()) {
                if (field.getRawType().isArray()) {
                    block.directStatement("// '" + field.getPropertyInfo().getName(true) + "' array.");
                    JConditional fieldNotNull = block._if(JExpr.ref((JExpression)sourceExpr, (String)field.getPropertyInfo().getName(false)).ne(JExpr._null()));
                    fieldNotNull._then().assign((JAssignmentTarget)targetExpr.ref(field.getPropertyInfo().getName(false)), (JExpression)JExpr.invoke((JMethod)this.getCopyOfCollectionMethod(field)).arg((JExpression)JExpr.invoke((JExpression)sourceExpr, (JMethod)getter)));
                } else {
                    block.directStatement("// '" + field.getPropertyInfo().getName(true) + "' collection.");
                    JConditional fieldNotNull = block._if(JExpr.ref((JExpression)sourceExpr, (String)field.getPropertyInfo().getName(false)).ne(JExpr._null()));
                    if (cloneMethod) {
                        fieldNotNull._then().assign((JAssignmentTarget)JExpr.ref((JExpression)targetExpr, (String)field.getPropertyInfo().getName(false)), JExpr._null());
                    }
                    fieldNotNull._then().invoke(this.getCopyOfCollectionMethod(field)).arg((JExpression)JExpr.invoke((JExpression)sourceExpr, (JMethod)getter)).arg((JExpression)JExpr.invoke((JExpression)targetExpr, (JMethod)getter));
                }
            } else {
                JInvocation copyExpr;
                boolean needsToCatchException = false;
                if (field.getPropertyInfo().ref().size() != 1) {
                    block.directStatement("// '" + field.getPropertyInfo().getName(true) + "' property.");
                    copyExpr = JExpr.invoke((JMethod)this.getCopyOfPropertyMethod(field)).arg((JExpression)sourceExpr.invoke(getter));
                } else {
                    CTypeInfo typeInfo = null;
                    if (field.getPropertyInfo().getAdapter() != null && field.getPropertyInfo().getAdapter().customType != null) {
                        typeInfo = field.parent().parent().getModel().getTypeInfo((NType)field.getPropertyInfo().getAdapter().customType);
                        if (typeInfo == null) {
                            typeInfo = new CAdapterInfo(field.getPropertyInfo().getAdapter());
                        }
                    } else {
                        typeInfo = (CTypeInfo)field.getPropertyInfo().ref().iterator().next();
                    }
                    JType javaType = typeInfo.toType(field.parent().parent(), Aspect.IMPLEMENTATION);
                    JInvocation source = field.parent().parent().getModel().strategy == ImplStructureStrategy.BEAN_ONLY ? JExpr.invoke((JExpression)sourceExpr, (JMethod)getter) : JExpr.cast((JType)javaType, (JExpression)JExpr.invoke((JExpression)sourceExpr, (JMethod)getter));
                    copyExpr = this.getCopyExpression(field, typeInfo, block, (JExpression)source, true);
                    boolean bl = needsToCatchException = needsToCatchException || this.tryCatchCopyExpression;
                }
                if (copyExpr == null) {
                    this.log(Level.SEVERE, "cannotCopyProperty", field.getPropertyInfo().getName(true), field.parent().implClass.binaryName());
                } else {
                    JBlock copyBlock = block;
                    if (needsToCatchException) {
                        JTryBlock tryCopy = block._try();
                        copyBlock = tryCopy.body();
                        JCatchBlock catchException = tryCopy._catch(field.parent().parent().getCodeModel().ref(Exception.class));
                        JVar e = catchException.param("e");
                        catchException.body()._throw((JExpression)JExpr._new((JClass)field.parent().parent().getCodeModel().ref(AssertionError.class)).arg((JExpression)e));
                    }
                    if (field.getRawType().isPrimitive()) {
                        copyBlock.assign((JAssignmentTarget)targetExpr.ref(field.getPropertyInfo().getName(false)), (JExpression)copyExpr);
                    } else {
                        copyBlock.assign((JAssignmentTarget)targetExpr.ref(field.getPropertyInfo().getName(false)), JOp.cond((JExpression)JExpr.ref((JExpression)sourceExpr, (String)field.getPropertyInfo().getName(false)).eq(JExpr._null()), (JExpression)JExpr._null(), (JExpression)copyExpr));
                    }
                }
            }
        } else {
            throw new AssertionError((Object)PluginImpl.getMessage("getterNotFound", field.getPropertyInfo().getName(true), field.parent().implClass.binaryName()));
        }
    }

    private String getMethodNamePart(JType type) {
        String methodName = type.name();
        if (type.isArray()) {
            methodName = methodName.replace("[]", "s");
        }
        methodName = methodName.replace(".", "");
        char[] c = methodName.toCharArray();
        c[0] = Character.toUpperCase(c[0]);
        methodName = String.valueOf(c);
        return methodName;
    }

    private static String getMessage(String key, Object ... args) {
        return MessageFormat.format(ResourceBundle.getBundle("net/sourceforge/ccxjc/PluginImpl").getString(key), args);
    }

    private Class<?> getClass(String binaryName) {
        try {
            return Class.forName(binaryName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private Collection<String> readTypes(String fileName) throws IOException {
        String line;
        LinkedList<String> types = new LinkedList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        while ((line = reader.readLine()) != null) {
            if (line.indexOf(35) > -1 || line.trim().length() <= 0) continue;
            types.add(line.trim());
        }
        return Collections.unmodifiableCollection(types);
    }

    private void log(Level level, String key, Object ... args) {
        StringBuilder b = new StringBuilder(512).append("[").append(MESSAGE_PREFIX).append("] [").append(level.getLocalizedName()).append("] ").append(PluginImpl.getMessage(key, args));
        int logLevel = Level.WARNING.intValue();
        if (this.options != null && !this.options.quiet) {
            if (this.options.verbose) {
                logLevel = Level.INFO.intValue();
            }
            if (this.options.debugMode) {
                logLevel = Level.ALL.intValue();
            }
        }
        if (level.intValue() >= logLevel) {
            if (level.intValue() <= Level.INFO.intValue()) {
                System.out.println(b.toString());
            } else {
                System.err.println(b.toString());
            }
        }
    }
}

