/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import java.io.Serializable;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.NativeConsole;
import net.sourceforge.htmlunit.corejs.javascript.ScriptStackElement;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebConsole
implements NativeConsole.ConsolePrinter,
Serializable {
    private Logger logger_ = new DefaultLogger();

    public void setLogger(Logger logger) {
        this.logger_ = logger;
    }

    public Logger getLogger() {
        return this.logger_;
    }

    @Override
    public void print(Context cx, Scriptable scope, NativeConsole.Level level, Object[] args, ScriptStackElement[] stack) {
        switch (level) {
            case TRACE: {
                if (!this.logger_.isInfoEnabled()) break;
                String msg = NativeConsole.format(cx, scope, args);
                if (stack != null) {
                    StringBuilder scriptStack = new StringBuilder();
                    scriptStack.append(msg);
                    for (ScriptStackElement scriptStackElement : stack) {
                        if (scriptStack.length() > 0) {
                            scriptStack.append('\n');
                        }
                        scriptStack.append(scriptStackElement);
                    }
                    msg = scriptStack.toString();
                }
                this.logger_.info(msg);
                break;
            }
            case DEBUG: {
                if (!this.logger_.isDebugEnabled()) break;
                this.logger_.debug(NativeConsole.format(cx, scope, args));
                break;
            }
            case INFO: {
                if (!this.logger_.isInfoEnabled()) break;
                this.logger_.info(NativeConsole.format(cx, scope, args));
                break;
            }
            case WARN: {
                if (!this.logger_.isWarnEnabled()) break;
                this.logger_.warn(NativeConsole.format(cx, scope, args));
                break;
            }
            case ERROR: {
                if (!this.logger_.isErrorEnabled()) break;
                this.logger_.error(NativeConsole.format(cx, scope, args));
                break;
            }
        }
    }

    private static class DefaultLogger
    implements Logger,
    Serializable {
        private static final Log LOG = LogFactory.getLog(WebConsole.class);

        DefaultLogger() {
        }

        @Override
        public boolean isTraceEnabled() {
            return LOG.isTraceEnabled();
        }

        @Override
        public void trace(Object message) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(message);
            }
        }

        @Override
        public boolean isDebugEnabled() {
            return LOG.isDebugEnabled();
        }

        @Override
        public void debug(Object message) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(message);
            }
        }

        @Override
        public boolean isInfoEnabled() {
            return LOG.isInfoEnabled();
        }

        @Override
        public void info(Object message) {
            LOG.info(message);
        }

        @Override
        public boolean isWarnEnabled() {
            return LOG.isWarnEnabled();
        }

        @Override
        public void warn(Object message) {
            LOG.warn(message);
        }

        @Override
        public boolean isErrorEnabled() {
            return LOG.isErrorEnabled();
        }

        @Override
        public void error(Object message) {
            LOG.error(message);
        }
    }

    public static interface Logger {
        public boolean isTraceEnabled();

        public void trace(Object var1);

        public boolean isDebugEnabled();

        public void debug(Object var1);

        public boolean isInfoEnabled();

        public void info(Object var1);

        public boolean isWarnEnabled();

        public void warn(Object var1);

        public boolean isErrorEnabled();

        public void error(Object var1);
    }
}

