/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.android;

import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class VersionUtil {
    private static final String BUNDLE_NAME = "Bundle-Name";
    private static final String BUNDLE_VERSION = "Bundle-Version";
    private static final String DEFAULT = "unknown";

    public static String determineVersionFromJarFileName(Class<?> aClass) {
        String tmpPath = aClass.getProtectionDomain().getCodeSource().getLocation().getPath();
        if (StringUtils.isNotBlank((CharSequence)tmpPath) && tmpPath.lastIndexOf(47) > -1) {
            tmpPath = tmpPath.substring(tmpPath.lastIndexOf(47) + 1);
            return tmpPath;
        }
        return DEFAULT;
    }

    public static String determineCreationDateFromJarFileName(Class<?> aClass) {
        String tmpPath = aClass.getProtectionDomain().getCodeSource().getLocation().getPath();
        String tmpClassFile = aClass.getName();
        tmpClassFile = tmpClassFile.replace('.', '/');
        tmpClassFile = String.valueOf(tmpClassFile) + ".class";
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JarFile tmpJar = new JarFile(tmpPath);){
                JarEntry tmpJarEntry = tmpJar.getJarEntry(tmpClassFile);
                Date tmpDate = new Date(tmpJarEntry.getTime());
                return new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT).format(tmpDate);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            return DEFAULT;
        }
    }

    public static String determineVersionFromJarManifest(String aJarFilePattern, String aPackage) {
        return VersionUtil.readAttributeFromJarManifest(aJarFilePattern, aPackage, Attributes.Name.IMPLEMENTATION_VERSION.toString(), DEFAULT);
    }

    public static String determineTitleFromJarManifest(String aJarFilePattern, String aPackage) {
        return VersionUtil.readAttributeFromJarManifest(aJarFilePattern, aPackage, Attributes.Name.IMPLEMENTATION_TITLE.toString(), DEFAULT);
    }

    public static String determineBundleNameFromJarManifest(String aJarFilePattern, String aPackage) {
        return VersionUtil.readAttributeFromJarManifest(aJarFilePattern, aPackage, BUNDLE_NAME, DEFAULT);
    }

    public static String determineBundleVersionFromJarManifest(String aJarFilePattern, String aPackage) {
        return VersionUtil.readAttributeFromJarManifest(aJarFilePattern, aPackage, BUNDLE_VERSION, DEFAULT);
    }

    public static String readAttributeFromJarManifest(String aJarFilePattern, String aPackage, String anAttributeName, String aDefault) {
        try {
            Enumeration<URL> tmpResources = VersionUtil.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            Pattern tmpPattern = Pattern.compile(aJarFilePattern);
            while (tmpResources.hasMoreElements()) {
                URL tmpUrl = tmpResources.nextElement();
                String tmpLcUrl = tmpUrl.toExternalForm().toLowerCase(Locale.ROOT);
                Matcher tmpMatcher = tmpPattern.matcher(tmpLcUrl);
                if (!tmpMatcher.find()) continue;
                Throwable throwable = null;
                Object var10_12 = null;
                try (InputStream tmpStream = tmpUrl.openStream();){
                    String tmpAttribute;
                    Manifest tmpManifest = new Manifest(tmpStream);
                    Attributes tmpAttributes = aPackage == null ? tmpManifest.getMainAttributes() : tmpManifest.getAttributes(aPackage);
                    if (tmpAttributes == null || !StringUtils.isNotBlank((CharSequence)(tmpAttribute = tmpAttributes.getValue(anAttributeName)))) continue;
                    return tmpAttribute;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return aDefault;
    }

    private VersionUtil() {
    }
}

