/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlInlineFrame;
import com.gargoylesoftware.htmlunit.html.HtmlNoFrames;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.ScriptElement;
import com.gargoylesoftware.htmlunit.javascript.AbstractJavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Document;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventHandler;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventTarget;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.util.EncodingSniffer;
import com.gargoylesoftware.htmlunit.util.MimeType;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.nio.charset.Charset;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ScriptElementSupport {
    private static final Log LOG = LogFactory.getLog(ScriptElementSupport.class);
    private static final String SLASH_SLASH_COLON = "//:";

    private ScriptElementSupport() {
    }

    public static void onAllChildrenAddedToPage(final DomElement element, boolean postponed) {
        if (element.getOwnerDocument() instanceof XmlPage) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Script node added: " + element.asXml()));
        }
        if (!element.getPage().getWebClient().isJavaScriptEngineEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Script found but not executed because javascript engine is disabled");
            }
            return;
        }
        ScriptElement script = (ScriptElement)((Object)element);
        final String srcAttrib = script.getSrcAttribute();
        if (DomElement.ATTRIBUTE_NOT_DEFINED != srcAttrib && script.isDeferred()) {
            return;
        }
        final WebWindow webWindow = element.getPage().getEnclosingWindow();
        if (webWindow != null) {
            StringBuilder description = new StringBuilder().append("Execution of ").append(srcAttrib == DomElement.ATTRIBUTE_NOT_DEFINED ? "inline " : "external ").append(element.getClass().getSimpleName());
            if (srcAttrib != DomElement.ATTRIBUTE_NOT_DEFINED) {
                description.append(" (").append(srcAttrib).append(')');
            }
            PostponedAction action = new PostponedAction(element.getPage(), description.toString()){

                @Override
                public void execute() {
                    HTMLDocument jsDoc = null;
                    Window window = (Window)webWindow.getScriptableObject();
                    if (window != null) {
                        jsDoc = (HTMLDocument)window.getDocument();
                        jsDoc.setExecutingDynamicExternalPosponed(element.getStartLineNumber() == -1 && DomElement.ATTRIBUTE_NOT_DEFINED != srcAttrib);
                    }
                    try {
                        ScriptElementSupport.executeScriptIfNeeded(element, false, false);
                    }
                    finally {
                        if (jsDoc != null) {
                            jsDoc.setExecutingDynamicExternalPosponed(false);
                        }
                    }
                }
            };
            AbstractJavaScriptEngine<?> engine = element.getPage().getWebClient().getJavaScriptEngine();
            if (engine != null && element.hasAttribute("async") && !engine.isScriptRunning()) {
                HtmlPage owningPage = element.getHtmlPageOrNull();
                owningPage.addAfterLoadAction(action);
            } else if (engine != null && (element.hasAttribute("async") || postponed && StringUtils.isBlank((CharSequence)element.getTextContent()))) {
                engine.addPostponedAction(action);
            } else {
                try {
                    action.execute();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void executeScriptIfNeeded(DomElement element, boolean ignoreAttachedToPage, boolean ignorePageIsAncestor) {
        if (!ScriptElementSupport.isExecutionNeeded(element, ignoreAttachedToPage, ignorePageIsAncestor)) {
            return;
        }
        ScriptElement scriptElement = (ScriptElement)((Object)element);
        String src = scriptElement.getSrcAttribute();
        if (src.equals(SLASH_SLASH_COLON)) {
            ScriptElementSupport.executeEvent(element, "error");
            return;
        }
        HtmlPage page = (HtmlPage)element.getPage();
        if (src != DomElement.ATTRIBUTE_NOT_DEFINED) {
            if (src.startsWith("javascript:")) return;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Loading external JavaScript: " + src));
            }
            try {
                HtmlPage.JavaScriptLoadResult result;
                scriptElement.setExecuted(true);
                Charset charset = EncodingSniffer.toCharset(scriptElement.getCharsetAttribute());
                if (charset == null) {
                    charset = page.getCharset();
                }
                Window win = (Window)page.getEnclosingWindow().getScriptableObject();
                Document doc = win.getDocument();
                try {
                    doc.setCurrentScript((ScriptableObject)element.getScriptableObject());
                    result = page.loadExternalJavaScriptFile(src, charset);
                }
                finally {
                    doc.setCurrentScript(null);
                }
                if (result == HtmlPage.JavaScriptLoadResult.SUCCESS) {
                    ScriptElementSupport.executeEvent(element, "load");
                    return;
                }
                if (result == HtmlPage.JavaScriptLoadResult.DOWNLOAD_ERROR) {
                    ScriptElementSupport.executeEvent(element, "error");
                    return;
                }
                if (result != HtmlPage.JavaScriptLoadResult.NO_CONTENT) return;
                BrowserVersion browserVersion = page.getWebClient().getBrowserVersion();
                if (browserVersion.hasFeature(BrowserVersionFeatures.JS_SCRIPT_HANDLE_204_AS_ERROR)) {
                    ScriptElementSupport.executeEvent(element, "error");
                    return;
                }
                ScriptElementSupport.executeEvent(element, "load");
                return;
            }
            catch (FailingHttpStatusCodeException e) {
                ScriptElementSupport.executeEvent(element, "error");
                throw e;
            }
        }
        if (element.getFirstChild() == null) return;
        Window win = (Window)page.getEnclosingWindow().getScriptableObject();
        Document doc = win.getDocument();
        try {
            doc.setCurrentScript((ScriptableObject)element.getScriptableObject());
            ScriptElementSupport.executeInlineScriptIfNeeded(element);
        }
        finally {
            doc.setCurrentScript(null);
        }
        if (!element.hasFeature(BrowserVersionFeatures.EVENT_ONLOAD_INTERNAL_JAVASCRIPT)) return;
        ScriptElementSupport.executeEvent(element, "load");
    }

    private static boolean isExecutionNeeded(DomElement element, boolean ignoreAttachedToPage, boolean ignorePageIsAncestor) {
        String l;
        ScriptElement script = (ScriptElement)((Object)element);
        if (script.isExecuted() || script.wasCreatedByDomParser()) {
            return false;
        }
        if (!ignoreAttachedToPage && !element.isAttachedToPage()) {
            return false;
        }
        SgmlPage page = element.getPage();
        if (!page.getWebClient().isJavaScriptEnabled()) {
            return false;
        }
        HtmlPage htmlPage = element.getHtmlPageOrNull();
        if (htmlPage != null && htmlPage.isParsingHtmlSnippet()) {
            return false;
        }
        for (DomNode o = element; o != null; o = o.getParentNode()) {
            if (!(o instanceof HtmlInlineFrame) && !(o instanceof HtmlNoFrames)) continue;
            return false;
        }
        if (page.getEnclosingWindow() != null && page.getEnclosingWindow().getEnclosedPage() != page) {
            return false;
        }
        String t = element.getAttributeDirect("type");
        if (!ScriptElementSupport.isJavaScript(element, t, l = element.getAttributeDirect("language"))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Script is not JavaScript (type: '" + t + "', language: '" + l + "'). Skipping execution."));
            }
            return false;
        }
        return ignorePageIsAncestor || element.getPage().isAncestorOf(element);
    }

    public static boolean isJavaScript(DomElement element, String typeAttribute, String languageAttribute) {
        BrowserVersion browserVersion = element.getPage().getWebClient().getBrowserVersion();
        if (browserVersion.hasFeature(BrowserVersionFeatures.HTMLSCRIPT_TRIM_TYPE)) {
            typeAttribute = typeAttribute.trim();
        }
        if (StringUtils.isNotEmpty((CharSequence)typeAttribute)) {
            return MimeType.isJavascriptMimeType(typeAttribute);
        }
        if (StringUtils.isNotEmpty((CharSequence)languageAttribute)) {
            return StringUtils.startsWithIgnoreCase((CharSequence)languageAttribute, (CharSequence)"javascript");
        }
        return true;
    }

    private static void executeEvent(DomElement element, String type) {
        EventTarget eventTarget = (EventTarget)element.getScriptableObject();
        Event event = new Event(element, type);
        eventTarget.executeEventLocally(event);
    }

    private static void executeInlineScriptIfNeeded(DomElement element) {
        if (!ScriptElementSupport.isExecutionNeeded(element, false, false)) {
            return;
        }
        ScriptElement scriptElement = (ScriptElement)((Object)element);
        String src = scriptElement.getSrcAttribute();
        if (src != DomElement.ATTRIBUTE_NOT_DEFINED) {
            return;
        }
        String forr = element.getAttributeDirect("for");
        String event = element.getAttributeDirect("event");
        if (event.endsWith("()")) {
            event = event.substring(0, event.length() - 2);
        }
        String scriptCode = ScriptElementSupport.getScriptCode(element);
        if (event != DomElement.ATTRIBUTE_NOT_DEFINED && forr != DomElement.ATTRIBUTE_NOT_DEFINED && element.hasFeature(BrowserVersionFeatures.JS_SCRIPT_SUPPORTS_FOR_AND_EVENT_WINDOW) && "window".equals(forr)) {
            Window window = (Window)element.getPage().getEnclosingWindow().getScriptableObject();
            EventHandler function = new EventHandler(element, event, scriptCode);
            window.getEventListenersContainer().addEventListener(StringUtils.substring((String)event, (int)2), function, false);
            return;
        }
        if (forr == DomElement.ATTRIBUTE_NOT_DEFINED || "onload".equals(event)) {
            String url = element.getPage().getUrl().toExternalForm();
            int line1 = element.getStartLineNumber();
            int line2 = element.getEndLineNumber();
            int col1 = element.getStartColumnNumber();
            int col2 = element.getEndColumnNumber();
            String desc = "script in " + url + " from (" + line1 + ", " + col1 + ") to (" + line2 + ", " + col2 + ")";
            scriptElement.setExecuted(true);
            ((HtmlPage)element.getPage()).executeJavaScript(scriptCode, desc, line1);
        }
    }

    private static String getScriptCode(DomElement element) {
        Iterable<DomNode> textNodes = element.getChildren();
        StringBuilder scriptCode = new StringBuilder();
        for (DomNode node : textNodes) {
            if (!(node instanceof DomText)) continue;
            DomText domText = (DomText)node;
            scriptCode.append(domText.getData());
        }
        return scriptCode.toString();
    }
}

