/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.httpclient;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.httpclient.HtmlUnitBrowserCompatCookieHeaderValueFormatter;
import com.gargoylesoftware.htmlunit.httpclient.HtmlUnitDomainHandler;
import com.gargoylesoftware.htmlunit.httpclient.HtmlUnitExpiresHandler;
import com.gargoylesoftware.htmlunit.httpclient.HtmlUnitHttpOnlyHandler;
import com.gargoylesoftware.htmlunit.httpclient.HtmlUnitPathHandler;
import com.gargoylesoftware.htmlunit.httpclient.HtmlUnitSameSiteHandler;
import com.gargoylesoftware.htmlunit.httpclient.HtmlUnitVersionAttributeHandler;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.htmlunit.org.apache.http.FormattedHeader;
import org.htmlunit.org.apache.http.Header;
import org.htmlunit.org.apache.http.HeaderElement;
import org.htmlunit.org.apache.http.NameValuePair;
import org.htmlunit.org.apache.http.ParseException;
import org.htmlunit.org.apache.http.client.utils.DateUtils;
import org.htmlunit.org.apache.http.cookie.Cookie;
import org.htmlunit.org.apache.http.cookie.CookieAttributeHandler;
import org.htmlunit.org.apache.http.cookie.CookieOrigin;
import org.htmlunit.org.apache.http.cookie.CookiePathComparator;
import org.htmlunit.org.apache.http.cookie.MalformedCookieException;
import org.htmlunit.org.apache.http.impl.cookie.BasicClientCookie;
import org.htmlunit.org.apache.http.impl.cookie.BasicCommentHandler;
import org.htmlunit.org.apache.http.impl.cookie.BasicMaxAgeHandler;
import org.htmlunit.org.apache.http.impl.cookie.BasicSecureHandler;
import org.htmlunit.org.apache.http.impl.cookie.CookieSpecBase;
import org.htmlunit.org.apache.http.message.BasicHeader;
import org.htmlunit.org.apache.http.message.BasicHeaderElement;
import org.htmlunit.org.apache.http.message.BasicNameValuePair;
import org.htmlunit.org.apache.http.message.BufferedHeader;
import org.htmlunit.org.apache.http.message.ParserCursor;
import org.htmlunit.org.apache.http.message.TokenParser;
import org.htmlunit.org.apache.http.util.CharArrayBuffer;

public class HtmlUnitBrowserCompatCookieSpec
extends CookieSpecBase {
    public static final String EMPTY_COOKIE_NAME = "HTMLUNIT_EMPTY_COOKIE";
    public static final String LOCAL_FILESYSTEM_DOMAIN = "LOCAL_FILESYSTEM";
    private static final Comparator<Cookie> COOKIE_COMPARATOR = new CookiePathComparator();
    private static final NetscapeDraftHeaderParser DEFAULT_NETSCAPE_DRAFT_HEADER_PARSER = new NetscapeDraftHeaderParser();
    static final Date DATE_1_1_1970;

    public HtmlUnitBrowserCompatCookieSpec(BrowserVersion browserVersion) {
        super(new HtmlUnitVersionAttributeHandler(), new HtmlUnitDomainHandler(browserVersion), new HtmlUnitPathHandler(browserVersion), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicCommentHandler(), new HtmlUnitExpiresHandler(browserVersion), new HtmlUnitHttpOnlyHandler(), new HtmlUnitSameSiteHandler());
    }

    @Override
    public List<Cookie> parse(Header header, CookieOrigin origin) throws MalformedCookieException {
        List<Cookie> cookies;
        int pos;
        String text = header.getValue();
        int endPos = text.indexOf(59);
        endPos = endPos < 0 ? text.indexOf(61) : ((pos = text.indexOf(61)) > endPos ? -1 : pos);
        if (endPos < 0) {
            header = new BasicHeader(header.getName(), "HTMLUNIT_EMPTY_COOKIE=" + header.getValue());
        } else if (endPos == 0 || StringUtils.isBlank((CharSequence)text.substring(0, endPos))) {
            header = new BasicHeader(header.getName(), EMPTY_COOKIE_NAME + header.getValue());
        }
        String headername = header.getName();
        if (!headername.equalsIgnoreCase("Set-Cookie")) {
            throw new MalformedCookieException("Unrecognized cookie header '" + header + "'");
        }
        HeaderElement[] helems = header.getElements();
        boolean versioned = false;
        boolean netscape = false;
        for (HeaderElement helem : helems) {
            if (helem.getParameterByName("version") != null) {
                versioned = true;
            }
            if (helem.getParameterByName("expires") == null) continue;
            netscape = true;
        }
        if (netscape || !versioned) {
            ParserCursor cursor;
            CharArrayBuffer buffer;
            if (header instanceof FormattedHeader) {
                buffer = ((FormattedHeader)header).getBuffer();
                cursor = new ParserCursor(((FormattedHeader)header).getValuePos(), buffer.length());
            } else {
                String s = header.getValue();
                if (s == null) {
                    throw new MalformedCookieException("Header value is null");
                }
                buffer = new CharArrayBuffer(s.length());
                buffer.append(s);
                cursor = new ParserCursor(0, buffer.length());
            }
            HeaderElement elem = DEFAULT_NETSCAPE_DRAFT_HEADER_PARSER.parseHeader(buffer, cursor);
            String name = elem.getName();
            if (name == null || name.isEmpty()) {
                throw new MalformedCookieException("Cookie name may not be empty");
            }
            String value = elem.getValue();
            BasicClientCookie cookie = new BasicClientCookie(name, value);
            cookie.setPath(HtmlUnitBrowserCompatCookieSpec.getDefaultPath(origin));
            cookie.setDomain(HtmlUnitBrowserCompatCookieSpec.getDefaultDomain(origin));
            NameValuePair[] attribs = elem.getParameters();
            for (int j = attribs.length - 1; j >= 0; --j) {
                NameValuePair attrib = attribs[j];
                String s = attrib.getName().toLowerCase(Locale.ROOT);
                cookie.setAttribute(s, attrib.getValue());
                CookieAttributeHandler handler = this.findAttribHandler(s);
                if (handler == null) continue;
                handler.parse(cookie, attrib.getValue());
            }
            if (netscape) {
                cookie.setVersion(0);
            }
            cookies = Collections.singletonList(cookie);
        } else {
            cookies = this.parse(helems, origin);
        }
        for (Cookie c : cookies) {
            if (!header.getValue().contains(c.getName() + "=\"" + c.getValue())) continue;
            ((BasicClientCookie)c).setValue('\"' + c.getValue() + '\"');
        }
        return cookies;
    }

    @Override
    public List<Header> formatCookies(List<Cookie> cookies) {
        cookies.sort(COOKIE_COMPARATOR);
        CharArrayBuffer buffer = new CharArrayBuffer(20 * cookies.size());
        buffer.append("Cookie");
        buffer.append(": ");
        for (int i = 0; i < cookies.size(); ++i) {
            Cookie cookie = cookies.get(i);
            if (i > 0) {
                buffer.append("; ");
            }
            String cookieName = cookie.getName();
            String cookieValue = cookie.getValue();
            if (cookie.getVersion() > 0 && !HtmlUnitBrowserCompatCookieSpec.isQuoteEnclosed(cookieValue)) {
                HtmlUnitBrowserCompatCookieHeaderValueFormatter.INSTANCE.formatHeaderElement(buffer, new BasicHeaderElement(cookieName, cookieValue), false);
                continue;
            }
            buffer.append(cookieName);
            buffer.append("=");
            if (cookieValue == null) continue;
            buffer.append(cookieValue);
        }
        ArrayList<Header> headers = new ArrayList<Header>(1);
        headers.add(new BufferedHeader(buffer));
        return headers;
    }

    private static boolean isQuoteEnclosed(String s) {
        return s != null && s.length() > 1 && '\"' == s.charAt(0) && '\"' == s.charAt(s.length() - 1);
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public Header getVersionHeader() {
        return null;
    }

    public String toString() {
        return "compatibility";
    }

    static {
        Calendar calendar = Calendar.getInstance(Locale.ROOT);
        calendar.setTimeZone(DateUtils.GMT);
        calendar.set(1970, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        DATE_1_1_1970 = calendar.getTime();
    }

    private static final class NetscapeDraftHeaderParser {
        private static final char PARAM_DELIMITER = ';';
        private static final BitSet TOKEN_DELIMS = TokenParser.INIT_BITSET(61, 59);
        private static final BitSet VALUE_DELIMS = TokenParser.INIT_BITSET(59);
        private final TokenParser tokenParser_ = TokenParser.INSTANCE;

        private NetscapeDraftHeaderParser() {
        }

        HeaderElement parseHeader(CharArrayBuffer buffer, ParserCursor cursor) throws ParseException {
            NameValuePair nvp = this.parseNameValuePair(buffer, cursor);
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            while (!cursor.atEnd()) {
                NameValuePair param = this.parseNameValuePair(buffer, cursor);
                params.add(param);
            }
            return new BasicHeaderElement(nvp.getName(), nvp.getValue(), params.toArray(new NameValuePair[0]));
        }

        private NameValuePair parseNameValuePair(CharArrayBuffer buffer, ParserCursor cursor) {
            String name = this.tokenParser_.parseToken(buffer, cursor, TOKEN_DELIMS);
            if (cursor.atEnd()) {
                return new BasicNameValuePair(name, null);
            }
            char delim = buffer.charAt(cursor.getPos());
            cursor.updatePos(cursor.getPos() + 1);
            if (delim != '=') {
                return new BasicNameValuePair(name, null);
            }
            String value = this.tokenParser_.parseToken(buffer, cursor, VALUE_DELIMS);
            if (!cursor.atEnd()) {
                cursor.updatePos(cursor.getPos() + 1);
            }
            return new BasicNameValuePair(name, value);
        }
    }
}

