/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import java.util.Date;
import java.util.Locale;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.lang3.time.FastDateFormat;

public final class DateCustom {
    private DateCustom() {
    }

    public static String toLocaleDateString(Context context, Scriptable thisObj, Object[] args, Function function) {
        BrowserVersion browserVersion = ((Window)thisObj.getParentScope()).getBrowserVersion();
        String formatString = browserVersion.hasFeature(BrowserVersionFeatures.JS_DATE_WITH_LEFT_TO_RIGHT_MARK) ? "\u200eM\u200e/\u200ed\u200e/\u200eyyyy" : (browserVersion.hasFeature(BrowserVersionFeatures.JS_DATE_LOCALE_DATE_SHORT) ? "M/d/yyyy" : "EEEE, MMMM dd, yyyy");
        FastDateFormat format = FastDateFormat.getInstance((String)formatString, (Locale)browserVersion.getBrowserLocale());
        return format.format(DateCustom.getDateValue(thisObj));
    }

    public static String toLocaleTimeString(Context context, Scriptable thisObj, Object[] args, Function function) {
        BrowserVersion browserVersion = ((Window)thisObj.getParentScope()).getBrowserVersion();
        String formatString = browserVersion.hasFeature(BrowserVersionFeatures.JS_DATE_WITH_LEFT_TO_RIGHT_MARK) ? "\u200eh\u200e:\u200emm\u200e:\u200ess\u200e \u200ea" : "h:mm:ss a";
        FastDateFormat format = FastDateFormat.getInstance((String)formatString, (Locale)browserVersion.getBrowserLocale());
        return format.format(DateCustom.getDateValue(thisObj));
    }

    private static long getDateValue(Scriptable thisObj) {
        Date date = (Date)Context.jsToJava(thisObj, Date.class);
        return date.getTime();
    }
}

