/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.URL;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ES6Iterator;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@JsxClass(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
public class URLSearchParams
extends HtmlUnitScriptable {
    private static final Log LOG = LogFactory.getLog(URLSearchParams.class);
    public static final String URL_SEARCH_PARMS_TAG = "URLSearchParams";
    private final URL url_;

    public URLSearchParams() {
        this.url_ = null;
    }

    URLSearchParams(URL url) {
        this.url_ = url;
    }

    @JsxConstructor
    public URLSearchParams(Object params) {
        this.url_ = new URL("http://www.htmlunit.org", "");
        if (params == null || Undefined.isUndefined(params)) {
            return;
        }
        try {
            this.url_.setSearch(URLSearchParams.splitQuery(Context.toString(params)));
        }
        catch (MalformedURLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private List<NameValuePair> splitQuery() {
        String search = this.url_.getSearch();
        search = UrlUtils.decode(search);
        return URLSearchParams.splitQuery(search);
    }

    private static List<NameValuePair> splitQuery(String params) {
        String[] parts;
        ArrayList<NameValuePair> splitted = new ArrayList<NameValuePair>();
        if (StringUtils.isEmpty((CharSequence)(params = StringUtils.stripStart((String)params, (String)"?")))) {
            return splitted;
        }
        for (String part : parts = StringUtils.split((String)params, (char)'&')) {
            splitted.add(URLSearchParams.splitQueryParameter(part));
        }
        return splitted;
    }

    private static NameValuePair splitQueryParameter(String singleParam) {
        int idx = singleParam.indexOf(61);
        if (idx > -1) {
            String key = singleParam.substring(0, idx);
            String value = null;
            if (idx < singleParam.length()) {
                value = singleParam.substring(idx + 1);
            }
            return new NameValuePair(key, value);
        }
        String value = "";
        return new NameValuePair(singleParam, "");
    }

    @JsxFunction
    public void append(String name, String value) {
        ArrayList<NameValuePair> pairs;
        String search = this.url_.getSearch();
        if (search == null || search.isEmpty()) {
            pairs = new ArrayList<NameValuePair>(1);
        } else {
            search = UrlUtils.decode(search);
            pairs = URLSearchParams.splitQuery(search);
        }
        pairs.add(new NameValuePair(name, value));
        try {
            this.url_.setSearch(pairs);
        }
        catch (MalformedURLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @JsxFunction
    public void delete(String name) {
        List<NameValuePair> splitted = this.splitQuery();
        splitted.removeIf(entry -> entry.getName().equals(name));
        if (splitted.size() == 0) {
            try {
                this.url_.setSearch((String)null);
            }
            catch (MalformedURLException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            return;
        }
        try {
            this.url_.setSearch(splitted);
        }
        catch (MalformedURLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @JsxFunction
    public String get(String name) {
        List<NameValuePair> splitted = this.splitQuery();
        for (NameValuePair param : splitted) {
            if (!param.getName().equals(name)) continue;
            return param.getValue();
        }
        return null;
    }

    @JsxFunction
    public Scriptable getAll(String name) {
        List<NameValuePair> splitted = this.splitQuery();
        ArrayList<String> result = new ArrayList<String>(splitted.size());
        for (NameValuePair param : splitted) {
            if (!param.getName().equals(name)) continue;
            result.add(param.getValue());
        }
        return Context.getCurrentContext().newArray((Scriptable)URLSearchParams.getWindow(this), result.toArray());
    }

    @JsxFunction
    public void set(String name, String value) {
        List<NameValuePair> splitted = this.splitQuery();
        boolean change = true;
        ListIterator<NameValuePair> iter = splitted.listIterator();
        while (iter.hasNext()) {
            NameValuePair entry = iter.next();
            if (!entry.getName().equals(name)) continue;
            if (change) {
                iter.set(new NameValuePair(name, value));
                change = false;
                continue;
            }
            iter.remove();
        }
        if (change) {
            splitted.add(new NameValuePair(name, value));
        }
        try {
            this.url_.setSearch(splitted);
        }
        catch (MalformedURLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @JsxFunction
    public boolean has(String name) {
        List<NameValuePair> splitted = this.splitQuery();
        for (NameValuePair param : splitted) {
            if (!param.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @JsxFunction
    public Object entries() {
        List<NameValuePair> splitted = this.splitQuery();
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_URL_SEARCH_PARMS_ITERATOR_SIMPLE_NAME)) {
            return new NativeParamsIterator(this.getParentScope(), "Iterator", NativeParamsIterator.Type.BOTH, splitted.iterator());
        }
        return new NativeParamsIterator(this.getParentScope(), "URLSearchParams Iterator", NativeParamsIterator.Type.BOTH, splitted.iterator());
    }

    @JsxFunction
    public Object keys() {
        List<NameValuePair> splitted = this.splitQuery();
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_URL_SEARCH_PARMS_ITERATOR_SIMPLE_NAME)) {
            return new NativeParamsIterator(this.getParentScope(), "Iterator", NativeParamsIterator.Type.KEYS, splitted.iterator());
        }
        return new NativeParamsIterator(this.getParentScope(), "URLSearchParams Iterator", NativeParamsIterator.Type.KEYS, splitted.iterator());
    }

    @JsxFunction
    public Object values() {
        List<NameValuePair> splitted = this.splitQuery();
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_URL_SEARCH_PARMS_ITERATOR_SIMPLE_NAME)) {
            return new NativeParamsIterator(this.getParentScope(), "Iterator", NativeParamsIterator.Type.VALUES, splitted.iterator());
        }
        return new NativeParamsIterator(this.getParentScope(), "URLSearchParams Iterator", NativeParamsIterator.Type.VALUES, splitted.iterator());
    }

    @JsxFunction(functionName="toString")
    public String jsToString() {
        StringBuilder newSearch = new StringBuilder();
        for (NameValuePair nameValuePair : URLSearchParams.splitQuery(this.url_.getSearch())) {
            if (newSearch.length() > 0) {
                newSearch.append('&');
            }
            newSearch.append(nameValuePair.getName()).append('=').append(nameValuePair.getValue());
        }
        return newSearch.toString();
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        return this.jsToString();
    }

    public void fillRequest(WebRequest webRequest) {
        webRequest.setRequestBody(null);
        webRequest.setEncodingType(FormEncodingType.URL_ENCODED);
        List<NameValuePair> splitted = this.splitQuery();
        if (splitted.size() > 0) {
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            for (NameValuePair entry : splitted) {
                params.add(new NameValuePair(entry.getName(), entry.getValue()));
            }
            webRequest.setRequestParameters(params);
        }
    }

    public static final class NativeParamsIterator
    extends ES6Iterator {
        private final Type type_;
        private final String className_;
        private final transient Iterator<NameValuePair> iterator_;

        public static void init(ScriptableObject scope, String className) {
            ES6Iterator.init(scope, false, new NativeParamsIterator(className), URLSearchParams.URL_SEARCH_PARMS_TAG);
        }

        public NativeParamsIterator(String className) {
            this.iterator_ = Collections.emptyIterator();
            this.type_ = Type.BOTH;
            this.className_ = className;
        }

        public NativeParamsIterator(Scriptable scope, String className, Type type, Iterator<NameValuePair> iterator) {
            super(scope, URLSearchParams.URL_SEARCH_PARMS_TAG);
            this.iterator_ = iterator;
            this.type_ = type;
            this.className_ = className;
        }

        @Override
        public String getClassName() {
            return this.className_;
        }

        @Override
        protected boolean isDone(Context cx, Scriptable scope) {
            return !this.iterator_.hasNext();
        }

        @Override
        protected Object nextValue(Context cx, Scriptable scope) {
            NameValuePair e = this.iterator_.next();
            switch (this.type_) {
                case KEYS: {
                    return e.getName();
                }
                case VALUES: {
                    return e.getValue();
                }
                case BOTH: {
                    return cx.newArray(scope, new Object[]{e.getName(), e.getValue()});
                }
            }
            throw new AssertionError();
        }

        static enum Type {
            KEYS,
            VALUES,
            BOTH;

        }
    }
}

