/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.css.dom.AbstractCSSRuleImpl;
import com.gargoylesoftware.css.dom.CSSCharsetRuleImpl;
import com.gargoylesoftware.css.dom.CSSImportRuleImpl;
import com.gargoylesoftware.css.dom.CSSMediaRuleImpl;
import com.gargoylesoftware.css.dom.CSSRuleListImpl;
import com.gargoylesoftware.css.dom.CSSStyleDeclarationImpl;
import com.gargoylesoftware.css.dom.CSSStyleRuleImpl;
import com.gargoylesoftware.css.dom.CSSStyleSheetImpl;
import com.gargoylesoftware.css.dom.CSSValueImpl;
import com.gargoylesoftware.css.dom.MediaListImpl;
import com.gargoylesoftware.css.dom.Property;
import com.gargoylesoftware.css.parser.CSSErrorHandler;
import com.gargoylesoftware.css.parser.CSSException;
import com.gargoylesoftware.css.parser.CSSOMParser;
import com.gargoylesoftware.css.parser.InputSource;
import com.gargoylesoftware.css.parser.LexicalUnit;
import com.gargoylesoftware.css.parser.condition.Condition;
import com.gargoylesoftware.css.parser.javacc.CSS3Parser;
import com.gargoylesoftware.css.parser.media.MediaQuery;
import com.gargoylesoftware.css.parser.selector.ChildSelector;
import com.gargoylesoftware.css.parser.selector.DescendantSelector;
import com.gargoylesoftware.css.parser.selector.DirectAdjacentSelector;
import com.gargoylesoftware.css.parser.selector.ElementSelector;
import com.gargoylesoftware.css.parser.selector.GeneralAdjacentSelector;
import com.gargoylesoftware.css.parser.selector.Selector;
import com.gargoylesoftware.css.parser.selector.SelectorList;
import com.gargoylesoftware.css.parser.selector.SelectorListImpl;
import com.gargoylesoftware.css.parser.selector.SimpleSelector;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.css.CssStyleSheet;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlLink;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSRule;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSRuleList;
import com.gargoylesoftware.htmlunit.javascript.host.css.ComputedCSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.css.StyleSheet;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.DOMException;

@JsxClass
public class CSSStyleSheet
extends StyleSheet {
    private static final Log LOG = LogFactory.getLog(CSSStyleSheet.class);
    private static final Pattern NTH_NUMERIC = Pattern.compile("\\d+");
    private static final Pattern NTH_COMPLEX = Pattern.compile("[+-]?\\d*n\\w*([+-]\\w\\d*)?");
    private final CssStyleSheet styleSheet_;
    private final HTMLElement ownerNode_;
    private CSSRuleList cssRules_;
    private List<Integer> cssRulesIndexFix_;
    private final Map<CSSImportRuleImpl, CSSStyleSheet> imports_ = new HashMap<CSSImportRuleImpl, CSSStyleSheet>();
    private static final transient Map<String, MediaListImpl> media_ = new HashMap<String, MediaListImpl>();
    private boolean enabled_ = true;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public CSSStyleSheet() {
        this.styleSheet_ = new CssStyleSheet(null, (InputSource)null, null);
        this.ownerNode_ = null;
    }

    public CSSStyleSheet(HTMLElement element, InputSource source, String uri) {
        this.setParentScope(element.getWindow());
        this.setPrototype(this.getPrototype(CSSStyleSheet.class));
        this.styleSheet_ = new CssStyleSheet(element.getDomNodeOrDie(), source, uri);
        this.ownerNode_ = element;
    }

    public CSSStyleSheet(HTMLElement element, String styleSheet, String uri) {
        Window win = element.getWindow();
        CssStyleSheet css = null;
        try (InputSource source = new InputSource(new StringReader(styleSheet));){
            css = new CssStyleSheet(element.getDomNodeOrDie(), source, uri);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        this.setParentScope(win);
        this.setPrototype(this.getPrototype(CSSStyleSheet.class));
        this.styleSheet_ = css;
        this.ownerNode_ = element;
    }

    public CSSStyleSheet(HTMLElement element, Scriptable parentScope, CssStyleSheet cssStyleSheet) {
        this.setParentScope(parentScope);
        this.setPrototype(this.getPrototype(CSSStyleSheet.class));
        this.styleSheet_ = cssStyleSheet;
        this.ownerNode_ = element;
    }

    public CssStyleSheet getCssStyleSheet() {
        return this.styleSheet_;
    }

    public void modifyIfNecessary(ComputedCSSStyleDeclaration style, DomElement element, String pseudoElement) {
        BrowserVersion browser = this.getBrowserVersion();
        List<CSSStyleSheetImpl.SelectorEntry> matchingRules = this.selects(this.getRuleIndex(), this, browser, element, pseudoElement, false);
        for (CSSStyleSheetImpl.SelectorEntry entry : matchingRules) {
            CSSStyleDeclarationImpl dec = entry.getRule().getStyle();
            style.applyStyleFromSelector(dec, entry.getSelector());
        }
    }

    public static CSSStyleSheet loadStylesheet(HTMLElement element, HtmlLink link, String url) {
        try {
            CssStyleSheet css = CssStyleSheet.loadStylesheet(element.getDomNodeOrDie(), link, url);
            return new CSSStyleSheet(element, element.getWindow(), css);
        }
        catch (RuntimeException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("RuntimeException loading " + url), (Throwable)e);
            }
            throw Context.reportRuntimeError("Exception: " + e);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Exception loading " + url), (Throwable)e);
            }
            throw Context.reportRuntimeError("Exception: " + e);
        }
    }

    @Deprecated
    public static boolean selects(BrowserVersion browserVersion, Selector selector, DomElement element, String pseudoElement, boolean fromQuerySelectorAll) {
        return CssStyleSheet.selects(browserVersion, selector, element, pseudoElement, fromQuerySelectorAll, true);
    }

    @Deprecated
    static boolean selects(BrowserVersion browserVersion, Condition condition, DomElement element, boolean fromQuerySelectorAll) {
        return CssStyleSheet.selects(browserVersion, condition, element, fromQuerySelectorAll, true);
    }

    public SelectorList parseSelectors(String source) {
        SelectorList selectors;
        try {
            CSSErrorHandler errorHandler = this.getWindow().getWebWindow().getWebClient().getCssErrorHandler();
            CSSOMParser parser = new CSSOMParser(new CSS3Parser());
            parser.setErrorHandler(errorHandler);
            selectors = parser.parseSelectors(source);
            if (null == selectors) {
                selectors = new SelectorListImpl();
            }
        }
        catch (Throwable t) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Error parsing CSS selectors from '" + source + "': " + t.getMessage()), t);
            }
            selectors = new SelectorListImpl();
        }
        return selectors;
    }

    static MediaListImpl parseMedia(CSSErrorHandler errorHandler, String mediaString) {
        MediaListImpl media = media_.get(mediaString);
        if (media != null) {
            return media;
        }
        try {
            CSSOMParser parser = new CSSOMParser(new CSS3Parser());
            parser.setErrorHandler(errorHandler);
            media = new MediaListImpl(parser.parseMedia(mediaString));
            media_.put(mediaString, media);
            return media;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Error parsing CSS media from '" + mediaString + "': " + e.getMessage()), (Throwable)e);
            }
            media = new MediaListImpl(null);
            media_.put(mediaString, media);
            return media;
        }
    }

    @JsxGetter
    public HTMLElement getOwnerNode() {
        return this.ownerNode_;
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public HTMLElement getOwningElement() {
        return this.ownerNode_;
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public CSSRuleList getRules() {
        return this.getCssRules();
    }

    @JsxGetter
    public CSSRuleList getCssRules() {
        this.initCssRules();
        return this.cssRules_;
    }

    @JsxGetter
    public String getHref() {
        if (this.ownerNode_ != null) {
            HtmlElement node = this.ownerNode_.getDomNodeOrDie();
            if (node instanceof HtmlStyle) {
                return null;
            }
            if (node instanceof HtmlLink) {
                HtmlLink link = (HtmlLink)node;
                String href = link.getHrefAttribute();
                if ("".equals(href) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.STYLESHEET_HREF_EMPTY_IS_NULL)) {
                    return null;
                }
                try {
                    HtmlPage page = (HtmlPage)link.getPage();
                    URL url = page.getFullyQualifiedUrl(href);
                    return url.toExternalForm();
                }
                catch (MalformedURLException e) {
                    LOG.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return this.getUri();
    }

    @JsxFunction
    public int insertRule(String rule, int position) {
        try {
            this.initCssRules();
            this.getCssStyleSheet().getWrappedSheet().insertRule(rule, this.fixIndex(position));
            this.refreshCssRules();
            return position;
        }
        catch (DOMException e) {
            int pos = rule.indexOf(123);
            if (pos > -1) {
                String newRule = rule.substring(0, pos) + "{}";
                try {
                    this.getCssStyleSheet().getWrappedSheet().insertRule(newRule, this.fixIndex(position));
                    this.refreshCssRules();
                    return position;
                }
                catch (DOMException ex) {
                    throw Context.throwAsScriptRuntimeEx(ex);
                }
            }
            throw Context.throwAsScriptRuntimeEx(e);
        }
    }

    private void refreshCssRules() {
        if (this.cssRules_ == null) {
            return;
        }
        this.cssRules_.clearRules();
        this.cssRulesIndexFix_.clear();
        CSSRuleListImpl ruleList = this.getCssStyleSheet().getWrappedSheet().getCssRules();
        List<AbstractCSSRuleImpl> rules = ruleList.getRules();
        int pos = 0;
        for (AbstractCSSRuleImpl rule : rules) {
            if (rule instanceof CSSCharsetRuleImpl) {
                this.cssRulesIndexFix_.add(pos);
                continue;
            }
            CSSRule cssRule = CSSRule.create(this, rule);
            if (null == cssRule) {
                this.cssRulesIndexFix_.add(pos);
            } else {
                this.cssRules_.addRule(cssRule);
            }
            ++pos;
        }
        this.getCssStyleSheet().getWrappedSheet().resetRuleIndex();
    }

    private int fixIndex(int index) {
        for (int fix : this.cssRulesIndexFix_) {
            if (fix > index) {
                return index;
            }
            ++index;
        }
        return index;
    }

    @JsxFunction
    public void deleteRule(int position) {
        try {
            this.initCssRules();
            this.getCssStyleSheet().getWrappedSheet().deleteRule(this.fixIndex(position));
            this.refreshCssRules();
        }
        catch (DOMException e) {
            throw Context.throwAsScriptRuntimeEx(e);
        }
    }

    @JsxFunction
    public int addRule(String selector, String rule) {
        String completeRule = selector + " {" + rule + "}";
        try {
            this.initCssRules();
            this.getCssStyleSheet().getWrappedSheet().insertRule(completeRule, this.getCssStyleSheet().getWrappedSheet().getCssRules().getLength());
            this.refreshCssRules();
        }
        catch (DOMException e) {
            completeRule = selector + " {}";
            try {
                this.getCssStyleSheet().getWrappedSheet().insertRule(completeRule, this.getCssStyleSheet().getWrappedSheet().getCssRules().getLength());
                this.refreshCssRules();
            }
            catch (DOMException ex) {
                throw Context.throwAsScriptRuntimeEx(ex);
            }
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.STYLESHEET_ADD_RULE_RETURNS_POS)) {
            return this.getCssStyleSheet().getWrappedSheet().getCssRules().getLength() - 1;
        }
        return -1;
    }

    @JsxFunction
    public void removeRule(int position) {
        try {
            this.initCssRules();
            this.getCssStyleSheet().getWrappedSheet().deleteRule(this.fixIndex(position));
            this.refreshCssRules();
        }
        catch (DOMException e) {
            throw Context.throwAsScriptRuntimeEx(e);
        }
    }

    public String getUri() {
        return this.getCssStyleSheet().getUri();
    }

    public boolean isActive() {
        String media;
        HtmlElement e = this.ownerNode_.getDomNodeOrNull();
        if (e instanceof HtmlStyle) {
            HtmlStyle style = (HtmlStyle)e;
            media = style.getMediaAttribute();
        } else if (e instanceof HtmlLink) {
            HtmlLink link = (HtmlLink)e;
            media = link.getMediaAttribute();
        } else {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)media)) {
            return true;
        }
        WebClient webClient = this.getWindow().getWebWindow().getWebClient();
        MediaListImpl mediaList = CSSStyleSheet.parseMedia(webClient.getCssErrorHandler(), media);
        return CSSStyleSheet.isActive((HtmlUnitScriptable)this, mediaList);
    }

    public boolean isEnabled() {
        return this.enabled_;
    }

    public void setEnabled(boolean enabled) {
        this.enabled_ = enabled;
    }

    static boolean isActive(HtmlUnitScriptable scriptable, MediaListImpl mediaList) {
        if (mediaList.getLength() == 0) {
            return true;
        }
        for (int i = 0; i < mediaList.getLength(); ++i) {
            MediaQuery mediaQuery = mediaList.mediaQuery(i);
            boolean isActive = CSSStyleSheet.isActive(scriptable, mediaQuery);
            if (mediaQuery.isNot()) {
                boolean bl = isActive = !isActive;
            }
            if (!isActive) continue;
            return true;
        }
        return false;
    }

    private static boolean isActive(HtmlUnitScriptable scriptable, MediaQuery mediaQuery) {
        String mediaType = mediaQuery.getMedia();
        if ("screen".equalsIgnoreCase(mediaType) || "all".equalsIgnoreCase(mediaType)) {
            for (Property property : mediaQuery.getProperties()) {
                switch (property.getName()) {
                    case "max-width": {
                        double val = CSSStyleSheet.pixelValue(property.getValue(), scriptable);
                        if (val != -1.0 && !(val < (double)scriptable.getWindow().getWebWindow().getInnerWidth())) break;
                        return false;
                    }
                    case "min-width": {
                        double val = CSSStyleSheet.pixelValue(property.getValue(), scriptable);
                        if (val != -1.0 && !(val > (double)scriptable.getWindow().getWebWindow().getInnerWidth())) break;
                        return false;
                    }
                    case "max-device-width": {
                        double val = CSSStyleSheet.pixelValue(property.getValue(), scriptable);
                        if (val != -1.0 && !(val < (double)scriptable.getWindow().getScreen().getWidth())) break;
                        return false;
                    }
                    case "min-device-width": {
                        double val = CSSStyleSheet.pixelValue(property.getValue(), scriptable);
                        if (val != -1.0 && !(val > (double)scriptable.getWindow().getScreen().getWidth())) break;
                        return false;
                    }
                    case "max-height": {
                        double val = CSSStyleSheet.pixelValue(property.getValue(), scriptable);
                        if (val != -1.0 && !(val < (double)scriptable.getWindow().getWebWindow().getInnerWidth())) break;
                        return false;
                    }
                    case "min-height": {
                        double val = CSSStyleSheet.pixelValue(property.getValue(), scriptable);
                        if (val != -1.0 && !(val > (double)scriptable.getWindow().getWebWindow().getInnerWidth())) break;
                        return false;
                    }
                    case "max-device-height": {
                        double val = CSSStyleSheet.pixelValue(property.getValue(), scriptable);
                        if (val != -1.0 && !(val < (double)scriptable.getWindow().getScreen().getWidth())) break;
                        return false;
                    }
                    case "min-device-height": {
                        double val = CSSStyleSheet.pixelValue(property.getValue(), scriptable);
                        if (val != -1.0 && !(val > (double)scriptable.getWindow().getScreen().getWidth())) break;
                        return false;
                    }
                    case "resolution": {
                        CSSValueImpl propValue = property.getValue();
                        double val = CSSStyleSheet.resolutionValue(propValue);
                        if (propValue == null) {
                            return true;
                        }
                        if (val != -1.0 && Math.round(val) == (long)scriptable.getWindow().getScreen().getDeviceXDPI()) break;
                        return false;
                    }
                    case "max-resolution": {
                        double val = CSSStyleSheet.resolutionValue(property.getValue());
                        if (val != -1.0 && !(val < (double)scriptable.getWindow().getScreen().getDeviceXDPI())) break;
                        return false;
                    }
                    case "min-resolution": {
                        double val = CSSStyleSheet.resolutionValue(property.getValue());
                        if (val != -1.0 && !(val > (double)scriptable.getWindow().getScreen().getDeviceXDPI())) break;
                        return false;
                    }
                    case "orientation": {
                        CSSValueImpl cssValue = property.getValue();
                        if (cssValue == null) {
                            if (LOG.isWarnEnabled()) {
                                LOG.warn((Object)"CSSValue is null not supported for feature 'orientation'");
                            }
                            return true;
                        }
                        String orient = cssValue.getCssText();
                        WebWindow window = scriptable.getWindow().getWebWindow();
                        if ("portrait".equals(orient)) {
                            if (window.getInnerWidth() <= window.getInnerHeight()) break;
                            return false;
                        }
                        if ("landscape".equals(orient)) {
                            if (window.getInnerWidth() >= window.getInnerHeight()) break;
                            return false;
                        }
                        if (LOG.isWarnEnabled()) {
                            LOG.warn((Object)("CSSValue '" + property.getValue().getCssText() + "' not supported for feature 'orientation'."));
                        }
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    private static double pixelValue(CSSValueImpl cssValue, HtmlUnitScriptable scriptable) {
        if (cssValue == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"CSSValue is null but has to be a 'px', 'em', '%', 'ex', 'ch', 'vw', 'vh', 'vmin', 'vmax', 'rem', 'mm', 'cm', 'Q', or 'pt' value.");
            }
            return -1.0;
        }
        LexicalUnit.LexicalUnitType luType = cssValue.getLexicalUnitType();
        if (luType != null) {
            switch (luType) {
                case PIXEL: {
                    return cssValue.getDoubleValue();
                }
                case EM: {
                    return 16.0 * cssValue.getDoubleValue();
                }
                case PERCENTAGE: {
                    return (double)0.16f * cssValue.getDoubleValue();
                }
                case EX: {
                    return (double)0.16f * cssValue.getDoubleValue();
                }
                case CH: {
                    return (double)0.16f * cssValue.getDoubleValue();
                }
                case VW: {
                    return (double)0.16f * cssValue.getDoubleValue();
                }
                case VH: {
                    return (double)0.16f * cssValue.getDoubleValue();
                }
                case VMIN: {
                    return (double)0.16f * cssValue.getDoubleValue();
                }
                case VMAX: {
                    return (double)0.16f * cssValue.getDoubleValue();
                }
                case REM: {
                    return (double)0.16f * cssValue.getDoubleValue();
                }
                case MILLIMETER: {
                    int dpi = scriptable.getWindow().getScreen().getDeviceXDPI();
                    return (double)((float)dpi / 25.4f) * cssValue.getDoubleValue();
                }
                case QUATER: {
                    int dpi = scriptable.getWindow().getScreen().getDeviceXDPI();
                    return (double)((float)dpi / 25.4f) * cssValue.getDoubleValue() / 4.0;
                }
                case CENTIMETER: {
                    int dpi = scriptable.getWindow().getScreen().getDeviceXDPI();
                    return (double)((float)dpi / 254.0f) * cssValue.getDoubleValue();
                }
                case POINT: {
                    int dpi = scriptable.getWindow().getScreen().getDeviceXDPI();
                    return (double)((float)dpi / 72.0f) * cssValue.getDoubleValue();
                }
            }
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("CSSValue '" + cssValue.getCssText() + "' has to be a 'px', 'em', '%', 'ex', 'ch', 'vw', 'vh', 'vmin', 'vmax', 'rem', 'mm', 'cm', 'Q', or 'pt' value."));
        }
        return -1.0;
    }

    private static double resolutionValue(CSSValueImpl cssValue) {
        if (cssValue == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"CSSValue is null but has to be a 'dpi', 'dpcm', or 'dppx' value.");
            }
            return -1.0;
        }
        if (cssValue.getPrimitiveType() == CSSValueImpl.CSSPrimitiveValueType.CSS_DIMENSION) {
            String text = cssValue.getCssText();
            if (text.endsWith("dpi")) {
                return cssValue.getDoubleValue();
            }
            if (text.endsWith("dpcm")) {
                return (double)2.54f * cssValue.getDoubleValue();
            }
            if (text.endsWith("dppx")) {
                return 96.0 * cssValue.getDoubleValue();
            }
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("CSSValue '" + cssValue.getCssText() + "' has to be a 'dpi', 'dpcm', or 'dppx' value."));
        }
        return -1.0;
    }

    public static void validateSelectors(SelectorList selectorList, int documentMode, DomNode domNode) throws CSSException {
        for (Selector selector : selectorList) {
            if (CSSStyleSheet.isValidSelector(selector, documentMode, domNode)) continue;
            throw new CSSException("Invalid selector: " + selector);
        }
    }

    private static boolean isValidSelector(Selector selector, int documentMode, DomNode domNode) {
        switch (selector.getSelectorType()) {
            case ELEMENT_NODE_SELECTOR: {
                List<Condition> conditions = ((ElementSelector)selector).getConditions();
                if (conditions != null) {
                    for (Condition condition : conditions) {
                        if (CSSStyleSheet.isValidCondition(condition, documentMode, domNode)) continue;
                        return false;
                    }
                }
                return true;
            }
            case DESCENDANT_SELECTOR: {
                DescendantSelector ds = (DescendantSelector)selector;
                return CSSStyleSheet.isValidSelector(ds.getAncestorSelector(), documentMode, domNode) && CSSStyleSheet.isValidSelector(ds.getSimpleSelector(), documentMode, domNode);
            }
            case CHILD_SELECTOR: {
                ChildSelector cs = (ChildSelector)selector;
                return CSSStyleSheet.isValidSelector(cs.getAncestorSelector(), documentMode, domNode) && CSSStyleSheet.isValidSelector(cs.getSimpleSelector(), documentMode, domNode);
            }
            case DIRECT_ADJACENT_SELECTOR: {
                DirectAdjacentSelector das = (DirectAdjacentSelector)selector;
                return CSSStyleSheet.isValidSelector(das.getSelector(), documentMode, domNode) && CSSStyleSheet.isValidSelector(das.getSimpleSelector(), documentMode, domNode);
            }
            case GENERAL_ADJACENT_SELECTOR: {
                GeneralAdjacentSelector gas = (GeneralAdjacentSelector)selector;
                return CSSStyleSheet.isValidSelector(gas.getSelector(), documentMode, domNode) && CSSStyleSheet.isValidSelector(gas.getSimpleSelector(), documentMode, domNode);
            }
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("Unhandled CSS selector type '" + (Object)((Object)selector.getSelectorType()) + "'. Accepting it silently."));
        }
        return true;
    }

    private static boolean isValidCondition(Condition condition, int documentMode, DomNode domNode) {
        switch (condition.getConditionType()) {
            case ATTRIBUTE_CONDITION: 
            case ID_CONDITION: 
            case LANG_CONDITION: 
            case ONE_OF_ATTRIBUTE_CONDITION: 
            case BEGIN_HYPHEN_ATTRIBUTE_CONDITION: 
            case CLASS_CONDITION: 
            case PREFIX_ATTRIBUTE_CONDITION: 
            case SUBSTRING_ATTRIBUTE_CONDITION: 
            case SUFFIX_ATTRIBUTE_CONDITION: {
                return true;
            }
            case PSEUDO_CLASS_CONDITION: {
                String value = condition.getValue();
                if (value.endsWith(")")) {
                    if (value.endsWith("()")) {
                        return false;
                    }
                    value = value.substring(0, value.indexOf(40) + 1) + ')';
                }
                if (documentMode < 9) {
                    return CssStyleSheet.CSS2_PSEUDO_CLASSES.contains(value);
                }
                if (!CssStyleSheet.CSS2_PSEUDO_CLASSES.contains(value) && domNode.hasFeature(BrowserVersionFeatures.QUERYSELECTOR_CSS3_PSEUDO_REQUIRE_ATTACHED_NODE) && !domNode.isAttachedToPage() && !domNode.hasChildNodes()) {
                    throw new CSSException("Syntax Error");
                }
                if ("nth-child()".equals(value)) {
                    String arg = StringUtils.substringBetween((String)condition.getValue(), (String)"(", (String)")").trim();
                    return "even".equalsIgnoreCase(arg) || "odd".equalsIgnoreCase(arg) || NTH_NUMERIC.matcher(arg).matches() || NTH_COMPLEX.matcher(arg).matches();
                }
                if ("placeholder-shown".equals(value)) {
                    return domNode.hasFeature(BrowserVersionFeatures.CSS_PSEUDO_SELECTOR_PLACEHOLDER_SHOWN);
                }
                if ("-ms-input-placeholder".equals(value)) {
                    return domNode.hasFeature(BrowserVersionFeatures.CSS_PSEUDO_SELECTOR_MS_PLACEHHOLDER);
                }
                return CssStyleSheet.CSS4_PSEUDO_CLASSES.contains(value);
            }
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("Unhandled CSS condition type '" + (Object)((Object)condition.getConditionType()) + "'. Accepting it silently."));
        }
        return true;
    }

    private void initCssRules() {
        if (this.cssRules_ == null) {
            this.cssRules_ = new CSSRuleList(this);
            this.cssRulesIndexFix_ = new ArrayList<Integer>();
            this.refreshCssRules();
        }
    }

    private CSSStyleSheetImpl.CSSStyleSheetRuleIndex getRuleIndex() {
        CSSStyleSheetImpl styleSheet = this.getCssStyleSheet().getWrappedSheet();
        CSSStyleSheetImpl.CSSStyleSheetRuleIndex index = styleSheet.getRuleIndex();
        if (index == null) {
            index = new CSSStyleSheetImpl.CSSStyleSheetRuleIndex();
            CSSRuleListImpl ruleList = styleSheet.getCssRules();
            this.index(index, ruleList, new HashSet<String>());
            styleSheet.setRuleIndex(index);
        }
        return index;
    }

    private void index(CSSStyleSheetImpl.CSSStyleSheetRuleIndex index, CSSRuleListImpl ruleList, Set<String> alreadyProcessing) {
        for (AbstractCSSRuleImpl rule : ruleList.getRules()) {
            if (rule instanceof CSSStyleRuleImpl) {
                CSSStyleRuleImpl styleRule = (CSSStyleRuleImpl)rule;
                SelectorList selectors = styleRule.getSelectors();
                for (Selector selector : selectors) {
                    SimpleSelector simpleSel = selector.getSimpleSelector();
                    if (Selector.SelectorType.ELEMENT_NODE_SELECTOR == simpleSel.getSelectorType()) {
                        Condition c;
                        ElementSelector es = (ElementSelector)simpleSel;
                        boolean wasClass = false;
                        List<Condition> conds = es.getConditions();
                        if (conds != null && conds.size() == 1 && Condition.ConditionType.CLASS_CONDITION == (c = conds.get(0)).getConditionType()) {
                            index.addClassSelector(es, c.getValue(), selector, styleRule);
                            wasClass = true;
                        }
                        if (wasClass) continue;
                        index.addElementSelector(es, selector, styleRule);
                        continue;
                    }
                    index.addOtherSelector(selector, styleRule);
                }
                continue;
            }
            if (rule instanceof CSSImportRuleImpl) {
                CSSImportRuleImpl importRule = (CSSImportRuleImpl)rule;
                CSSStyleSheet sheet = this.getImportedStyleSheet(importRule);
                if (alreadyProcessing.contains(sheet.getUri())) continue;
                CSSRuleListImpl sheetRuleList = sheet.getCssStyleSheet().getWrappedSheet().getCssRules();
                alreadyProcessing.add(sheet.getUri());
                MediaListImpl mediaList = importRule.getMedia();
                if (mediaList.getLength() == 0 && index.getMediaList().getLength() == 0) {
                    this.index(index, sheetRuleList, alreadyProcessing);
                    continue;
                }
                this.index(index.addMedia(mediaList), sheetRuleList, alreadyProcessing);
                continue;
            }
            if (!(rule instanceof CSSMediaRuleImpl)) continue;
            CSSMediaRuleImpl mediaRule = (CSSMediaRuleImpl)rule;
            MediaListImpl mediaList = mediaRule.getMediaList();
            if (mediaList.getLength() == 0 && index.getMediaList().getLength() == 0) {
                this.index(index, mediaRule.getCssRules(), alreadyProcessing);
                continue;
            }
            this.index(index.addMedia(mediaList), mediaRule.getCssRules(), alreadyProcessing);
        }
    }

    private List<CSSStyleSheetImpl.SelectorEntry> selects(CSSStyleSheetImpl.CSSStyleSheetRuleIndex index, HtmlUnitScriptable scriptable, BrowserVersion browserVersion, DomElement element, String pseudoElement, boolean fromQuerySelectorAll) {
        ArrayList<CSSStyleSheetImpl.SelectorEntry> matchingRules = new ArrayList<CSSStyleSheetImpl.SelectorEntry>();
        if (CSSStyleSheet.isActive(scriptable, index.getMediaList())) {
            String elementName = element.getLowercaseName();
            String[] classes = StringUtils.split((String)element.getAttributeDirect("class"), null, (int)-1);
            Iterator<CSSStyleSheetImpl.SelectorEntry> iter = index.getSelectorEntriesIteratorFor(elementName, classes);
            CSSStyleSheetImpl.SelectorEntry entry = iter.next();
            while (null != entry) {
                if (CssStyleSheet.selects(browserVersion, entry.getSelector(), element, pseudoElement, fromQuerySelectorAll, false)) {
                    matchingRules.add(entry);
                }
                entry = iter.next();
            }
            for (CSSStyleSheetImpl.CSSStyleSheetRuleIndex child : index.getChildren()) {
                matchingRules.addAll(this.selects(child, scriptable, browserVersion, element, pseudoElement, fromQuerySelectorAll));
            }
        }
        return matchingRules;
    }

    public CSSStyleSheet getImportedStyleSheet(CSSImportRuleImpl importRule) {
        CSSStyleSheet sheet = this.imports_.get(importRule);
        if (sheet == null) {
            String href = importRule.getHref();
            String url = UrlUtils.resolveUrl(this.getUri(), href);
            sheet = CSSStyleSheet.loadStylesheet(this.ownerNode_, null, url);
            this.imports_.put(importRule, sheet);
        }
        return sheet;
    }
}

