/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.css.dom.MediaListImpl;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlLink;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import com.gargoylesoftware.htmlunit.javascript.host.dom.AbstractList;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Document;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLLinkElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLStyleElement;
import java.io.Serializable;
import java.util.function.Function;
import java.util.function.Predicate;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.lang3.StringUtils;

@JsxClass
public class StyleSheetList
extends HtmlUnitScriptable {
    private HTMLCollection nodes_;

    boolean isActiveStyleSheetLink(DomNode domNode) {
        HtmlLink link;
        if (domNode instanceof HtmlLink && (link = (HtmlLink)domNode).isStyleSheetLink()) {
            String media = link.getMediaAttribute();
            if (StringUtils.isBlank((CharSequence)media)) {
                return true;
            }
            WebClient webClient = this.getWindow().getWebWindow().getWebClient();
            MediaListImpl mediaList = CSSStyleSheet.parseMedia(webClient.getCssErrorHandler(), media);
            return CSSStyleSheet.isActive((HtmlUnitScriptable)this, mediaList);
        }
        return false;
    }

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public StyleSheetList() {
    }

    public StyleSheetList(Document document) {
        this.setParentScope(document);
        this.setPrototype(this.getPrototype(this.getClass()));
        WebClient webClient = this.getWindow().getWebWindow().getWebClient();
        if (webClient.getOptions().isCssEnabled()) {
            boolean onlyActive = webClient.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_STYLESHEETLIST_ACTIVE_ONLY);
            this.nodes_ = new HTMLCollection(document.getDomNodeOrDie(), true);
            this.nodes_.setEffectOnCacheFunction((Function<HtmlAttributeChangeEvent, AbstractList.EffectOnCache> & Serializable)event -> {
                HtmlElement node = event.getHtmlElement();
                if (node instanceof HtmlLink && "rel".equalsIgnoreCase(event.getName())) {
                    return AbstractList.EffectOnCache.RESET;
                }
                return AbstractList.EffectOnCache.NONE;
            });
            this.nodes_.setIsMatchingPredicate((Predicate<DomNode> & Serializable)node -> {
                if (node instanceof HtmlStyle) {
                    return true;
                }
                if (onlyActive) {
                    return this.isActiveStyleSheetLink((DomNode)node);
                }
                return node instanceof HtmlLink && ((HtmlLink)node).isStyleSheetLink();
            });
        } else {
            this.nodes_ = HTMLCollection.emptyCollection(this.getWindow().getDomNodeOrDie());
        }
    }

    @JsxGetter
    public int getLength() {
        return this.nodes_.getLength();
    }

    @JsxFunction
    public Object item(int index) {
        if (this.nodes_ == null || index < 0 || index >= this.nodes_.getLength()) {
            return Undefined.instance;
        }
        HTMLElement element = (HTMLElement)this.nodes_.item(index);
        if (element instanceof HTMLStyleElement) {
            return ((HTMLStyleElement)element).getSheet();
        }
        return ((HTMLLinkElement)element).getSheet();
    }

    @Override
    public Object get(int index, Scriptable start) {
        if (this == start) {
            return this.item(index);
        }
        return super.get(index, start);
    }

    @Override
    protected Object equivalentValues(Object value) {
        return value != null && this.getClass() == value.getClass() && this.getDomNodeOrNull() == ((StyleSheetList)value).getDomNodeOrNull();
    }
}

