/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.dom;

import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Node;
import com.gargoylesoftware.htmlunit.util.StringUtils;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;

@JsxClass
public final class DOMStringMap
extends HtmlUnitScriptable {
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public DOMStringMap() {
    }

    public DOMStringMap(Node node) {
        this.setDomNode(node.getDomNodeOrDie(), false);
        this.setParentScope(node.getParentScope());
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    @Override
    public Object get(String name, Scriptable start) {
        String value;
        HtmlElement e = (HtmlElement)this.getDomNodeOrNull();
        if (e != null && DomElement.ATTRIBUTE_NOT_DEFINED != (value = e.getAttribute("data-" + StringUtils.cssDeCamelize(name)))) {
            return value;
        }
        return NOT_FOUND;
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        if (!(ScriptableObject.getTopLevelScope(this) instanceof Window) || this.getWindow().getWebWindow() == null) {
            super.put(name, start, value);
        } else {
            HtmlElement e = (HtmlElement)this.getDomNodeOrNull();
            if (e != null) {
                e.setAttribute("data-" + StringUtils.cssDeCamelize(name), Context.toString(value));
            }
        }
    }
}

