/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.event;

import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventTarget;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
public class HashChangeEvent
extends Event {
    private String oldURL_ = "";
    private String newURL_ = "";

    public HashChangeEvent() {
        this.setEventType("");
    }

    public HashChangeEvent(EventTarget target, String type, String oldURL, String newURL) {
        super(target, type);
        this.oldURL_ = oldURL;
        this.newURL_ = newURL;
        this.setBubbles(false);
        this.setCancelable(false);
    }

    @Override
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void jsConstructor(String type, ScriptableObject details) {
        super.jsConstructor(type, details);
        String oldURL = "";
        String newURL = "";
        if (details != null && !Undefined.isUndefined(details)) {
            oldURL = (String)details.get("oldURL");
            newURL = (String)details.get("newURL");
        }
        this.oldURL_ = oldURL;
        this.newURL_ = newURL;
    }

    @JsxFunction(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void initHashChangeEvent(String type, boolean bubbles, boolean cancelable, String oldURL, String newURL) {
        this.initEvent(type, bubbles, cancelable);
        this.oldURL_ = oldURL;
        this.newURL_ = newURL;
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Object getOldURL() {
        return this.oldURL_;
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Object getNewURL() {
        return this.newURL_;
    }
}

