/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.org.apache.http.impl.client;

import java.io.IOException;
import org.htmlunit.org.apache.http.HttpEntity;
import org.htmlunit.org.apache.http.HttpResponse;
import org.htmlunit.org.apache.http.StatusLine;
import org.htmlunit.org.apache.http.annotation.Contract;
import org.htmlunit.org.apache.http.annotation.ThreadingBehavior;
import org.htmlunit.org.apache.http.client.HttpResponseException;
import org.htmlunit.org.apache.http.client.ResponseHandler;
import org.htmlunit.org.apache.http.util.EntityUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public abstract class AbstractResponseHandler<T>
implements ResponseHandler<T> {
    @Override
    public T handleResponse(HttpResponse response) throws HttpResponseException, IOException {
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        if (statusLine.getStatusCode() >= 300) {
            EntityUtils.consume(entity);
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        return entity == null ? null : (T)this.handleEntity(entity);
    }

    public abstract T handleEntity(HttpEntity var1) throws IOException;
}

