/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.org.apache.http.impl.entity;

import org.htmlunit.org.apache.http.HttpException;
import org.htmlunit.org.apache.http.HttpMessage;
import org.htmlunit.org.apache.http.ProtocolException;
import org.htmlunit.org.apache.http.annotation.Contract;
import org.htmlunit.org.apache.http.annotation.ThreadingBehavior;
import org.htmlunit.org.apache.http.entity.ContentLengthStrategy;
import org.htmlunit.org.apache.http.impl.entity.LaxContentLengthStrategy;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DisallowIdentityContentLengthStrategy
implements ContentLengthStrategy {
    public static final DisallowIdentityContentLengthStrategy INSTANCE = new DisallowIdentityContentLengthStrategy(new LaxContentLengthStrategy(0));
    private final ContentLengthStrategy contentLengthStrategy;

    public DisallowIdentityContentLengthStrategy(ContentLengthStrategy contentLengthStrategy) {
        this.contentLengthStrategy = contentLengthStrategy;
    }

    @Override
    public long determineLength(HttpMessage message) throws HttpException {
        long result = this.contentLengthStrategy.determineLength(message);
        if (result == -1L) {
            throw new ProtocolException("Identity transfer encoding cannot be used");
        }
        return result;
    }
}

