/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.org.apache.http.protocol;

import java.io.IOException;
import org.htmlunit.org.apache.http.HttpEntityEnclosingRequest;
import org.htmlunit.org.apache.http.HttpException;
import org.htmlunit.org.apache.http.HttpRequest;
import org.htmlunit.org.apache.http.HttpRequestInterceptor;
import org.htmlunit.org.apache.http.annotation.Contract;
import org.htmlunit.org.apache.http.annotation.ThreadingBehavior;
import org.htmlunit.org.apache.http.protocol.HttpContext;
import org.htmlunit.org.apache.http.protocol.HttpDateGenerator;
import org.htmlunit.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

