/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.css.dom;

import com.gargoylesoftware.css.dom.CSSValueImpl;
import com.gargoylesoftware.css.parser.LexicalUnit;
import java.io.Serializable;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.Rect;

public class RectImpl
implements Rect,
Serializable {
    private CSSPrimitiveValue top_;
    private CSSPrimitiveValue right_;
    private CSSPrimitiveValue bottom_;
    private CSSPrimitiveValue left_;

    public RectImpl(LexicalUnit lu) throws DOMException {
        if (lu == null) {
            throw new DOMException(12, "Rect misses first parameter.");
        }
        this.top_ = new CSSValueImpl(lu, true);
        LexicalUnit next = lu.getNextLexicalUnit();
        if (next == null) {
            throw new DOMException(12, "Rect misses second parameter.");
        }
        boolean isCommaSeparated = false;
        if (next.getLexicalUnitType() == LexicalUnit.LexicalUnitType.OPERATOR_COMMA) {
            isCommaSeparated = true;
            if ((next = next.getNextLexicalUnit()) == null) {
                throw new DOMException(12, "Rect misses second parameter.");
            }
        }
        this.right_ = new CSSValueImpl(next, true);
        if ((next = next.getNextLexicalUnit()) == null) {
            throw new DOMException(12, "Rect misses third parameter.");
        }
        if (isCommaSeparated) {
            if (next.getLexicalUnitType() != LexicalUnit.LexicalUnitType.OPERATOR_COMMA) {
                throw new DOMException(12, "All or none rect parameters must be separated by ','.");
            }
            if ((next = next.getNextLexicalUnit()) == null) {
                throw new DOMException(12, "Rect misses third parameter.");
            }
        } else if (next.getLexicalUnitType() == LexicalUnit.LexicalUnitType.OPERATOR_COMMA) {
            throw new DOMException(12, "All or none rect parameters must be separated by ','.");
        }
        this.bottom_ = new CSSValueImpl(next, true);
        if ((next = next.getNextLexicalUnit()) == null) {
            throw new DOMException(12, "Rect misses fourth parameter.");
        }
        if (isCommaSeparated) {
            if (next.getLexicalUnitType() != LexicalUnit.LexicalUnitType.OPERATOR_COMMA) {
                throw new DOMException(12, "All or none rect parameters must be separated by ','.");
            }
            if ((next = next.getNextLexicalUnit()) == null) {
                throw new DOMException(12, "Rect misses fourth parameter.");
            }
        } else if (next.getLexicalUnitType() == LexicalUnit.LexicalUnitType.OPERATOR_COMMA) {
            throw new DOMException(12, "All or none rect parameters must be separated by ','.");
        }
        this.left_ = new CSSValueImpl(next, true);
        if ((next = next.getNextLexicalUnit()) != null) {
            throw new DOMException(12, "Too many parameters for rect function.");
        }
    }

    @Override
    public CSSPrimitiveValue getTop() {
        return this.top_;
    }

    public void setTop(CSSPrimitiveValue top) {
        this.top_ = top;
    }

    @Override
    public CSSPrimitiveValue getRight() {
        return this.right_;
    }

    public void setRight(CSSPrimitiveValue right) {
        this.right_ = right;
    }

    @Override
    public CSSPrimitiveValue getBottom() {
        return this.bottom_;
    }

    public void setBottom(CSSPrimitiveValue bottom) {
        this.bottom_ = bottom;
    }

    @Override
    public CSSPrimitiveValue getLeft() {
        return this.left_;
    }

    public void setLeft(CSSPrimitiveValue left) {
        this.left_ = left;
    }

    public String toString() {
        return "rect(" + this.top_ + ", " + this.right_ + ", " + this.bottom_ + ", " + this.left_ + ")";
    }
}

