/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.axes;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import net.sourceforge.htmlunit.xpath.Expression;
import net.sourceforge.htmlunit.xpath.ExpressionOwner;
import net.sourceforge.htmlunit.xpath.XPathContext;
import net.sourceforge.htmlunit.xpath.XPathVisitor;
import net.sourceforge.htmlunit.xpath.axes.LocPathIterator;
import net.sourceforge.htmlunit.xpath.axes.PathComponent;
import net.sourceforge.htmlunit.xpath.axes.PredicatedNodeTest;
import net.sourceforge.htmlunit.xpath.axes.WalkerFactory;
import net.sourceforge.htmlunit.xpath.axes.WalkingIterator;
import net.sourceforge.htmlunit.xpath.compiler.Compiler;
import net.sourceforge.htmlunit.xpath.res.XPATHMessages;
import net.sourceforge.htmlunit.xpath.xml.dtm.DTM;
import net.sourceforge.htmlunit.xpath.xml.dtm.DTMAxisTraverser;

public class AxesWalker
extends PredicatedNodeTest
implements Cloneable,
PathComponent,
ExpressionOwner {
    private DTM m_dtm;
    transient int m_root = -1;
    private transient int m_currentNode = -1;
    transient boolean m_isFresh;
    protected AxesWalker m_nextWalker;
    AxesWalker m_prevWalker;
    protected final int m_axis;
    protected DTMAxisTraverser m_traverser;

    public AxesWalker(LocPathIterator locPathIterator, int axis) {
        super(locPathIterator);
        this.m_axis = axis;
    }

    public final WalkingIterator wi() {
        return (WalkingIterator)this.m_lpi;
    }

    public void init(Compiler compiler, int opPos, int stepType) throws TransformerException {
        this.initPredicateInfo(compiler, opPos);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    AxesWalker cloneDeep(WalkingIterator cloneOwner, Vector<AxesWalker> cloneList) throws CloneNotSupportedException {
        AxesWalker clone = AxesWalker.findClone(this, cloneList);
        if (null != clone) {
            return clone;
        }
        clone = (AxesWalker)this.clone();
        clone.setLocPathIterator(cloneOwner);
        if (null != cloneList) {
            cloneList.addElement(this);
            cloneList.addElement(clone);
        }
        if (this.wi().m_lastUsedWalker == this) {
            cloneOwner.m_lastUsedWalker = clone;
        }
        if (null != this.m_nextWalker) {
            clone.m_nextWalker = this.m_nextWalker.cloneDeep(cloneOwner, cloneList);
        }
        if (null != cloneList) {
            if (null != this.m_prevWalker) {
                clone.m_prevWalker = this.m_prevWalker.cloneDeep(cloneOwner, cloneList);
            }
        } else if (null != this.m_nextWalker) {
            clone.m_nextWalker.m_prevWalker = clone;
        }
        return clone;
    }

    static AxesWalker findClone(AxesWalker key, Vector<AxesWalker> cloneList) {
        if (null != cloneList) {
            int n = cloneList.size();
            for (int i = 0; i < n; i += 2) {
                if (key != cloneList.elementAt(i)) continue;
                return cloneList.elementAt(i + 1);
            }
        }
        return null;
    }

    public void detach() {
        this.m_currentNode = -1;
        this.m_dtm = null;
        this.m_traverser = null;
        this.m_isFresh = true;
        this.m_root = -1;
    }

    public int getRoot() {
        return this.m_root;
    }

    @Override
    public int getAnalysisBits() {
        int axis = this.getAxis();
        return WalkerFactory.getAnalysisBitFromAxes(axis);
    }

    public void setRoot(int root) {
        XPathContext xctxt = this.wi().getXPathContext();
        this.m_dtm = xctxt.getDTM(root);
        this.m_traverser = this.m_dtm.getAxisTraverser(this.m_axis);
        this.m_isFresh = true;
        this.m_foundLast = false;
        this.m_root = root;
        this.m_currentNode = root;
        if (-1 == root) {
            throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_SETTING_WALKER_ROOT_TO_NULL", null));
        }
        this.resetProximityPositions();
    }

    public void setNextWalker(AxesWalker walker) {
        this.m_nextWalker = walker;
    }

    public AxesWalker getNextWalker() {
        return this.m_nextWalker;
    }

    public void setPrevWalker(AxesWalker walker) {
        this.m_prevWalker = walker;
    }

    protected int getNextNode() {
        if (this.m_foundLast) {
            return -1;
        }
        if (this.m_isFresh) {
            this.m_currentNode = this.m_traverser.first(this.m_root);
            this.m_isFresh = false;
        } else if (-1 != this.m_currentNode) {
            this.m_currentNode = this.m_traverser.next(this.m_root, this.m_currentNode);
        }
        if (-1 == this.m_currentNode) {
            this.m_foundLast = true;
        }
        return this.m_currentNode;
    }

    public int nextNode() {
        int nextNode = -1;
        AxesWalker walker = this.wi().getLastUsedWalker();
        while (null != walker) {
            nextNode = walker.getNextNode();
            if (-1 == nextNode) {
                walker = walker.m_prevWalker;
                continue;
            }
            if (walker.acceptNode(nextNode) != 1) continue;
            if (null == walker.m_nextWalker) {
                this.wi().setLastUsedWalker(walker);
                break;
            }
            AxesWalker prev = walker;
            walker = walker.m_nextWalker;
            walker.setRoot(nextNode);
            walker.m_prevWalker = prev;
        }
        return nextNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLastPos(XPathContext xctxt) {
        AxesWalker walker;
        int pos = this.getProximityPosition();
        try {
            walker = (AxesWalker)this.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return -1;
        }
        walker.setPredicateCount(this.m_predicateIndex);
        walker.setNextWalker(null);
        walker.setPrevWalker(null);
        WalkingIterator lpi = this.wi();
        AxesWalker savedWalker = lpi.getLastUsedWalker();
        try {
            lpi.setLastUsedWalker(walker);
            while (-1 != walker.nextNode()) {
                ++pos;
            }
        }
        finally {
            lpi.setLastUsedWalker(savedWalker);
        }
        return pos;
    }

    public DTM getDTM(int node) {
        return this.wi().getXPathContext().getDTM(node);
    }

    public int getAxis() {
        return this.m_axis;
    }

    @Override
    public void callVisitors(ExpressionOwner owner, XPathVisitor visitor) {
        if (visitor.visitStep()) {
            this.callPredicateVisitors(visitor);
            if (null != this.m_nextWalker) {
                this.m_nextWalker.callVisitors(this, visitor);
            }
        }
    }

    @Override
    public Expression getExpression() {
        return this.m_nextWalker;
    }

    @Override
    public void setExpression(Expression exp) {
        exp.exprSetParent(this);
        this.m_nextWalker = (AxesWalker)exp;
    }

    @Override
    public boolean deepEquals(Expression expr) {
        if (!super.deepEquals(expr)) {
            return false;
        }
        AxesWalker walker = (AxesWalker)expr;
        return this.m_axis == walker.m_axis;
    }
}

