/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.axes;

import javax.xml.transform.TransformerException;
import net.sourceforge.htmlunit.xpath.Expression;
import net.sourceforge.htmlunit.xpath.ExpressionOwner;
import net.sourceforge.htmlunit.xpath.XPathContext;
import net.sourceforge.htmlunit.xpath.XPathVisitor;
import net.sourceforge.htmlunit.xpath.axes.AxesWalker;
import net.sourceforge.htmlunit.xpath.axes.FilterExprIteratorSimple;
import net.sourceforge.htmlunit.xpath.axes.PathComponent;
import net.sourceforge.htmlunit.xpath.axes.WalkingIterator;
import net.sourceforge.htmlunit.xpath.compiler.Compiler;
import net.sourceforge.htmlunit.xpath.objects.XNodeSet;

public class FilterExprWalker
extends AxesWalker {
    private Expression m_expr;
    private transient XNodeSet m_exprObj;

    public FilterExprWalker(WalkingIterator locPathIterator) {
        super(locPathIterator, 20);
    }

    @Override
    public void init(Compiler compiler, int opPos, int stepType) throws TransformerException {
        super.init(compiler, opPos, stepType);
        switch (stepType) {
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.m_expr = compiler.compile(opPos);
                this.m_expr.exprSetParent(this);
                break;
            }
            default: {
                this.m_expr = compiler.compile(opPos + 2);
                this.m_expr.exprSetParent(this);
            }
        }
    }

    @Override
    public void detach() {
        super.detach();
        boolean m_canDetachNodeset = true;
        if (m_canDetachNodeset) {
            this.m_exprObj.detach();
        }
        this.m_exprObj = null;
    }

    @Override
    public void setRoot(int root) {
        super.setRoot(root);
        this.m_exprObj = FilterExprIteratorSimple.executeFilterExpr(root, this.m_lpi.getXPathContext(), this.m_lpi.getPrefixResolver(), this.m_lpi.getIsTopLevel(), this.m_expr);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FilterExprWalker clone = (FilterExprWalker)super.clone();
        if (null != this.m_exprObj) {
            clone.m_exprObj = (XNodeSet)this.m_exprObj.clone();
        }
        return clone;
    }

    @Override
    public short acceptNode(int n) {
        try {
            if (this.getPredicateCount() > 0) {
                this.countProximityPosition(0);
                if (!this.executePredicates(n, this.m_lpi.getXPathContext())) {
                    return 3;
                }
            }
            return 1;
        }
        catch (TransformerException se) {
            throw new RuntimeException(se.getMessage());
        }
    }

    @Override
    public int getNextNode() {
        if (null != this.m_exprObj) {
            return this.m_exprObj.nextNode();
        }
        return -1;
    }

    @Override
    public int getLastPos(XPathContext xctxt) {
        return this.m_exprObj.getLength();
    }

    public void setInnerExpression(Expression expr) {
        expr.exprSetParent(this);
        this.m_expr = expr;
    }

    @Override
    public int getAnalysisBits() {
        if (null != this.m_expr && this.m_expr instanceof PathComponent) {
            return ((PathComponent)((Object)this.m_expr)).getAnalysisBits();
        }
        return 0x4000000;
    }

    @Override
    public int getAxis() {
        return this.m_exprObj.getAxis();
    }

    @Override
    public void callPredicateVisitors(XPathVisitor visitor) {
        this.m_expr.callVisitors(new filterExprOwner(), visitor);
        super.callPredicateVisitors(visitor);
    }

    @Override
    public boolean deepEquals(Expression expr) {
        if (!super.deepEquals(expr)) {
            return false;
        }
        FilterExprWalker walker = (FilterExprWalker)expr;
        return this.m_expr.deepEquals(walker.m_expr);
    }

    class filterExprOwner
    implements ExpressionOwner {
        filterExprOwner() {
        }

        @Override
        public Expression getExpression() {
            return FilterExprWalker.this.m_expr;
        }

        @Override
        public void setExpression(Expression exp) {
            exp.exprSetParent(FilterExprWalker.this);
            FilterExprWalker.this.m_expr = exp;
        }
    }
}

