/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.compiler;

import java.util.HashMap;
import javax.xml.transform.TransformerException;
import net.sourceforge.htmlunit.xpath.functions.FuncBoolean;
import net.sourceforge.htmlunit.xpath.functions.FuncCeiling;
import net.sourceforge.htmlunit.xpath.functions.FuncConcat;
import net.sourceforge.htmlunit.xpath.functions.FuncContains;
import net.sourceforge.htmlunit.xpath.functions.FuncCount;
import net.sourceforge.htmlunit.xpath.functions.FuncFalse;
import net.sourceforge.htmlunit.xpath.functions.FuncFloor;
import net.sourceforge.htmlunit.xpath.functions.FuncId;
import net.sourceforge.htmlunit.xpath.functions.FuncLang;
import net.sourceforge.htmlunit.xpath.functions.FuncLast;
import net.sourceforge.htmlunit.xpath.functions.FuncLocalPart;
import net.sourceforge.htmlunit.xpath.functions.FuncNamespace;
import net.sourceforge.htmlunit.xpath.functions.FuncNormalizeSpace;
import net.sourceforge.htmlunit.xpath.functions.FuncNot;
import net.sourceforge.htmlunit.xpath.functions.FuncNumber;
import net.sourceforge.htmlunit.xpath.functions.FuncPosition;
import net.sourceforge.htmlunit.xpath.functions.FuncQname;
import net.sourceforge.htmlunit.xpath.functions.FuncRound;
import net.sourceforge.htmlunit.xpath.functions.FuncStartsWith;
import net.sourceforge.htmlunit.xpath.functions.FuncString;
import net.sourceforge.htmlunit.xpath.functions.FuncStringLength;
import net.sourceforge.htmlunit.xpath.functions.FuncSubstring;
import net.sourceforge.htmlunit.xpath.functions.FuncSubstringAfter;
import net.sourceforge.htmlunit.xpath.functions.FuncSubstringBefore;
import net.sourceforge.htmlunit.xpath.functions.FuncSum;
import net.sourceforge.htmlunit.xpath.functions.FuncTranslate;
import net.sourceforge.htmlunit.xpath.functions.FuncTrue;
import net.sourceforge.htmlunit.xpath.functions.Function;

public class FunctionTable {
    public static final int FUNC_CURRENT = 0;
    public static final int FUNC_LAST = 1;
    public static final int FUNC_POSITION = 2;
    public static final int FUNC_COUNT = 3;
    public static final int FUNC_ID = 4;
    public static final int FUNC_LOCAL_PART = 7;
    public static final int FUNC_NAMESPACE = 8;
    public static final int FUNC_QNAME = 9;
    public static final int FUNC_NOT = 11;
    public static final int FUNC_TRUE = 12;
    public static final int FUNC_FALSE = 13;
    public static final int FUNC_BOOLEAN = 14;
    public static final int FUNC_NUMBER = 15;
    public static final int FUNC_FLOOR = 16;
    public static final int FUNC_CEILING = 17;
    public static final int FUNC_ROUND = 18;
    public static final int FUNC_SUM = 19;
    public static final int FUNC_STRING = 20;
    public static final int FUNC_STARTS_WITH = 21;
    public static final int FUNC_CONTAINS = 22;
    public static final int FUNC_SUBSTRING_BEFORE = 23;
    public static final int FUNC_SUBSTRING_AFTER = 24;
    public static final int FUNC_NORMALIZE_SPACE = 25;
    public static final int FUNC_TRANSLATE = 26;
    public static final int FUNC_CONCAT = 27;
    public static final int FUNC_SUBSTRING = 29;
    public static final int FUNC_STRING_LENGTH = 30;
    public static final int FUNC_LANG = 32;
    private static final Class<?>[] m_functions;
    private static final HashMap<String, Integer> m_functionID;
    private final Class<?>[] m_functions_customer = new Class[30];
    private final HashMap<String, Integer> m_functionID_customer = new HashMap();
    private static final int NUM_BUILT_IN_FUNCS = 37;
    private static final int NUM_ALLOWABLE_ADDINS = 30;
    private int m_funcNextFreeIndex = 37;

    String getFunctionName(int funcID) {
        if (funcID < 37) {
            return m_functions[funcID].getName();
        }
        return this.m_functions_customer[funcID - 37].getName();
    }

    Function getFunction(int which) throws TransformerException {
        try {
            if (which < 37) {
                return (Function)m_functions[which].newInstance();
            }
            return (Function)this.m_functions_customer[which - 37].newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new TransformerException(ex.getMessage());
        }
    }

    Object getFunctionID(String key) {
        Integer id = this.m_functionID_customer.get(key);
        if (null == id) {
            id = m_functionID.get(key);
        }
        return id;
    }

    public int installFunction(String name, Class<?> func) {
        int funcIndex;
        Object funcIndexObj = this.getFunctionID(name);
        if (null != funcIndexObj) {
            funcIndex = (Integer)funcIndexObj;
            if (funcIndex < 37) {
                funcIndex = this.m_funcNextFreeIndex++;
                this.m_functionID_customer.put(name, new Integer(funcIndex));
            }
            this.m_functions_customer[funcIndex - 37] = func;
        } else {
            funcIndex = this.m_funcNextFreeIndex++;
            this.m_functions_customer[funcIndex - 37] = func;
            this.m_functionID_customer.put(name, new Integer(funcIndex));
        }
        return funcIndex;
    }

    public boolean functionAvailable(String methName) {
        Integer tblEntry = m_functionID.get(methName);
        if (null != tblEntry) {
            return true;
        }
        tblEntry = this.m_functionID_customer.get(methName);
        return null != tblEntry;
    }

    static {
        m_functionID = new HashMap();
        m_functions = new Class[37];
        FunctionTable.m_functions[1] = FuncLast.class;
        FunctionTable.m_functions[2] = FuncPosition.class;
        FunctionTable.m_functions[3] = FuncCount.class;
        FunctionTable.m_functions[4] = FuncId.class;
        FunctionTable.m_functions[7] = FuncLocalPart.class;
        FunctionTable.m_functions[8] = FuncNamespace.class;
        FunctionTable.m_functions[9] = FuncQname.class;
        FunctionTable.m_functions[11] = FuncNot.class;
        FunctionTable.m_functions[12] = FuncTrue.class;
        FunctionTable.m_functions[13] = FuncFalse.class;
        FunctionTable.m_functions[14] = FuncBoolean.class;
        FunctionTable.m_functions[32] = FuncLang.class;
        FunctionTable.m_functions[15] = FuncNumber.class;
        FunctionTable.m_functions[16] = FuncFloor.class;
        FunctionTable.m_functions[17] = FuncCeiling.class;
        FunctionTable.m_functions[18] = FuncRound.class;
        FunctionTable.m_functions[19] = FuncSum.class;
        FunctionTable.m_functions[20] = FuncString.class;
        FunctionTable.m_functions[21] = FuncStartsWith.class;
        FunctionTable.m_functions[22] = FuncContains.class;
        FunctionTable.m_functions[23] = FuncSubstringBefore.class;
        FunctionTable.m_functions[24] = FuncSubstringAfter.class;
        FunctionTable.m_functions[25] = FuncNormalizeSpace.class;
        FunctionTable.m_functions[26] = FuncTranslate.class;
        FunctionTable.m_functions[27] = FuncConcat.class;
        FunctionTable.m_functions[29] = FuncSubstring.class;
        FunctionTable.m_functions[30] = FuncStringLength.class;
        m_functionID.put("current", new Integer(0));
        m_functionID.put("last", new Integer(1));
        m_functionID.put("position", new Integer(2));
        m_functionID.put("count", new Integer(3));
        m_functionID.put("id", new Integer(4));
        m_functionID.put("local-name", new Integer(7));
        m_functionID.put("namespace-uri", new Integer(8));
        m_functionID.put("name", new Integer(9));
        m_functionID.put("not", new Integer(11));
        m_functionID.put("true", new Integer(12));
        m_functionID.put("false", new Integer(13));
        m_functionID.put("boolean", new Integer(14));
        m_functionID.put("lang", new Integer(32));
        m_functionID.put("number", new Integer(15));
        m_functionID.put("floor", new Integer(16));
        m_functionID.put("ceiling", new Integer(17));
        m_functionID.put("round", new Integer(18));
        m_functionID.put("sum", new Integer(19));
        m_functionID.put("string", new Integer(20));
        m_functionID.put("starts-with", new Integer(21));
        m_functionID.put("contains", new Integer(22));
        m_functionID.put("substring-before", new Integer(23));
        m_functionID.put("substring-after", new Integer(24));
        m_functionID.put("normalize-space", new Integer(25));
        m_functionID.put("translate", new Integer(26));
        m_functionID.put("concat", new Integer(27));
        m_functionID.put("substring", new Integer(29));
        m_functionID.put("string-length", new Integer(30));
    }
}

