/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.objects;

import javax.xml.transform.TransformerException;
import net.sourceforge.htmlunit.xpath.Expression;
import net.sourceforge.htmlunit.xpath.NodeSetDTM;
import net.sourceforge.htmlunit.xpath.XPathContext;
import net.sourceforge.htmlunit.xpath.XPathException;
import net.sourceforge.htmlunit.xpath.XPathVisitor;
import net.sourceforge.htmlunit.xpath.objects.XString;
import net.sourceforge.htmlunit.xpath.res.XPATHMessages;
import net.sourceforge.htmlunit.xpath.xml.dtm.DTMIterator;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public class XObject
extends Expression {
    protected Object m_obj;
    public static final int CLASS_NULL = -1;
    public static final int CLASS_UNKNOWN = 0;
    public static final int CLASS_BOOLEAN = 1;
    public static final int CLASS_NUMBER = 2;
    public static final int CLASS_STRING = 3;
    public static final int CLASS_NODESET = 4;
    public static final int CLASS_RTREEFRAG = 5;

    public XObject() {
    }

    public XObject(Object obj) {
        this.setObject(obj);
    }

    protected void setObject(Object obj) {
        this.m_obj = obj;
    }

    @Override
    public XObject execute(XPathContext xctxt) throws TransformerException {
        return this;
    }

    public void allowDetachToRelease(boolean allowRelease) {
    }

    public void detach() {
    }

    public int getType() {
        return 0;
    }

    public String getTypeString() {
        return "#UNKNOWN (" + this.object().getClass().getName() + ")";
    }

    public double num() throws TransformerException {
        this.error("ER_CANT_CONVERT_TO_NUMBER", new Object[]{this.getTypeString()});
        return 0.0;
    }

    public double numWithSideEffects() throws TransformerException {
        return this.num();
    }

    public boolean bool() throws TransformerException {
        this.error("ER_CANT_CONVERT_TO_NUMBER", new Object[]{this.getTypeString()});
        return false;
    }

    public boolean boolWithSideEffects() throws TransformerException {
        return this.bool();
    }

    public XString xstr() {
        return new XString(this.str());
    }

    public String str() {
        return this.m_obj != null ? this.m_obj.toString() : "";
    }

    public String toString() {
        return this.str();
    }

    public Object object() {
        return this.m_obj;
    }

    public DTMIterator iter() throws TransformerException {
        this.error("ER_CANT_CONVERT_TO_NODELIST", new Object[]{this.getTypeString()});
        return null;
    }

    public NodeIterator nodeset() throws TransformerException {
        this.error("ER_CANT_CONVERT_TO_NODELIST", new Object[]{this.getTypeString()});
        return null;
    }

    public NodeList nodelist() throws TransformerException {
        this.error("ER_CANT_CONVERT_TO_NODELIST", new Object[]{this.getTypeString()});
        return null;
    }

    public NodeSetDTM mutableNodeset() throws TransformerException {
        this.error("ER_CANT_CONVERT_TO_MUTABLENODELIST", new Object[]{this.getTypeString()});
        return (NodeSetDTM)this.m_obj;
    }

    public boolean lessThan(XObject obj2) throws TransformerException {
        if (obj2.getType() == 4) {
            return obj2.greaterThan(this);
        }
        return this.num() < obj2.num();
    }

    public boolean lessThanOrEqual(XObject obj2) throws TransformerException {
        if (obj2.getType() == 4) {
            return obj2.greaterThanOrEqual(this);
        }
        return this.num() <= obj2.num();
    }

    public boolean greaterThan(XObject obj2) throws TransformerException {
        if (obj2.getType() == 4) {
            return obj2.lessThan(this);
        }
        return this.num() > obj2.num();
    }

    public boolean greaterThanOrEqual(XObject obj2) throws TransformerException {
        if (obj2.getType() == 4) {
            return obj2.lessThanOrEqual(this);
        }
        return this.num() >= obj2.num();
    }

    public boolean equals(XObject obj2) {
        if (obj2.getType() == 4) {
            return obj2.equals(this);
        }
        if (null != this.m_obj) {
            return this.m_obj.equals(obj2.m_obj);
        }
        return obj2.m_obj == null;
    }

    public boolean notEquals(XObject obj2) throws TransformerException {
        if (obj2.getType() == 4) {
            return obj2.notEquals(this);
        }
        return !this.equals(obj2);
    }

    protected void error(String msg) throws TransformerException {
        this.error(msg, null);
    }

    protected void error(String msg, Object[] args) throws TransformerException {
        String fmsg = XPATHMessages.createXPATHMessage(msg, args);
        throw new XPathException(fmsg, this);
    }

    @Override
    public void callVisitors(XPathVisitor visitor) {
        this.assertion(false, "callVisitors should not be called for this object!!!");
    }

    @Override
    public boolean deepEquals(Expression expr) {
        if (!this.isSameClass(expr)) {
            return false;
        }
        return this.equals((XObject)expr);
    }
}

