/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.CookieManager;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ProxyConfig;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.WebWindowEvent;
import com.gargoylesoftware.htmlunit.WebWindowListener;
import com.gargoylesoftware.htmlunit.WebWindowNotFoundException;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomNodeList;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInlineFrame;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.Speed;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.htmlunit.HtmlUnitWebElement;
import org.openqa.selenium.htmlunit.RenderedHtmlUnitDriverWebElement;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.internal.ReturnedCookie;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlUnitDriver
implements WebDriver,
SearchContext,
JavascriptExecutor,
FindsById,
FindsByLinkText,
FindsByXPath,
FindsByName,
FindsByTagName {
    private WebClient webClient;
    private WebWindow currentWindow;
    private Map<WebWindow, History> histories = new HashMap<WebWindow, History>();
    private boolean enableJavascript;
    private ProxyConfig proxyConfig;
    private AtomicLong windowNamer = new AtomicLong(System.currentTimeMillis());
    private final BrowserVersion version;

    public HtmlUnitDriver(BrowserVersion version) {
        this.version = version;
        this.webClient = this.createWebClient(version);
        this.webClient.addWebWindowListener(new WebWindowListener(){
            private boolean waitingToLoad;

            public void webWindowOpened(WebWindowEvent webWindowEvent) {
                this.waitingToLoad = true;
            }

            public void webWindowContentChanged(WebWindowEvent webWindowEvent) {
                History history;
                WebWindow window = webWindowEvent.getWebWindow();
                if (this.waitingToLoad) {
                    this.waitingToLoad = false;
                    HtmlUnitDriver.this.webClient.setCurrentWindow(window);
                }
                if ((history = (History)HtmlUnitDriver.this.histories.get(window)) == null) {
                    history = new History(window);
                    HtmlUnitDriver.this.histories.put(window, history);
                }
                history.addNewPage(webWindowEvent.getNewPage());
            }

            public void webWindowClosed(WebWindowEvent webWindowEvent) {
                WebWindow window = webWindowEvent.getWebWindow();
                HtmlUnitDriver.this.histories.remove(window);
                HtmlUnitDriver.this.pickWindow();
            }
        });
        if (this.currentWindow == null) {
            this.get(WebClient.URL_ABOUT_BLANK);
        }
        this.histories.clear();
    }

    public HtmlUnitDriver() {
        this(false);
    }

    public HtmlUnitDriver(boolean enableJavascript) {
        this(BrowserVersion.getDefault());
        this.setJavascriptEnabled(enableJavascript);
    }

    private HtmlUnitDriver(boolean enableJavascript, WebWindow currentWindow) {
        this(enableJavascript);
        this.currentWindow = currentWindow;
    }

    private WebClient createWebClient(BrowserVersion version) {
        WebClient client = this.newWebClient(version);
        client.setThrowExceptionOnFailingStatusCode(false);
        client.setPrintContentOnFailingStatusCode(false);
        client.setJavaScriptEnabled(this.enableJavascript);
        client.setRedirectEnabled(true);
        try {
            client.setUseInsecureSSL(true);
        }
        catch (GeneralSecurityException e) {
            throw new WebDriverException((Throwable)e);
        }
        if (this.proxyConfig != null) {
            client.setProxyConfig(this.proxyConfig);
        }
        return this.modifyWebClient(client);
    }

    protected WebClient newWebClient(BrowserVersion version) {
        return new WebClient(version);
    }

    protected WebClient modifyWebClient(WebClient client) {
        return client;
    }

    public void setProxy(String host, int port) {
        this.proxyConfig = new ProxyConfig(host, port);
        this.webClient.setProxyConfig(this.proxyConfig);
    }

    public void get(String url) {
        URL fullUrl;
        try {
            fullUrl = new URL(url);
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
        this.get(fullUrl);
    }

    protected void get(URL fullUrl) {
        try {
            this.webClient.getPage(fullUrl);
        }
        catch (UnknownHostException e) {
        }
        catch (ConnectException e) {
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
        this.pickWindow();
    }

    protected void pickWindow() {
        FrameWindow frame;
        this.currentWindow = this.webClient.getCurrentWindow();
        Page page = this.webClient.getCurrentWindow().getEnclosedPage();
        if (page == null) {
            return;
        }
        if (!(page instanceof HtmlPage)) {
            return;
        }
        if (((HtmlPage)page).getFrames().size() > 0 && !((frame = (FrameWindow)((HtmlPage)page).getFrames().get(0)).getFrameElement() instanceof HtmlInlineFrame)) {
            this.switchTo().frame(0);
        }
    }

    public String getCurrentUrl() {
        return this.lastPage().getWebResponse().getRequestSettings().getUrl().toString();
    }

    public String getTitle() {
        Page page = this.lastPage();
        if (page == null || !(page instanceof HtmlPage)) {
            return null;
        }
        return ((HtmlPage)page).getTitleText();
    }

    public WebElement findElement(By by) {
        return by.findElement((SearchContext)this);
    }

    public List<WebElement> findElements(By by) {
        return by.findElements((SearchContext)this);
    }

    public String getPageSource() {
        WebResponse webResponse = this.lastPage().getWebResponse();
        return webResponse.getContentAsString();
    }

    public void close() {
        this.webClient = this.createWebClient(this.version);
    }

    public void quit() {
        this.webClient.closeAllWindows();
        this.webClient = null;
        this.currentWindow = null;
        this.histories.clear();
    }

    public Set<String> getWindowHandles() {
        HashSet<String> allHandles = new HashSet<String>();
        List allWindows = this.webClient.getWebWindows();
        for (WebWindow window : allWindows) {
            WebWindow top = window.getTopWindow();
            if (top.getName() == null || "".equals(top.getName())) {
                this.nameWindow(top);
            }
            allHandles.add(top.getName());
        }
        return allHandles;
    }

    public String getWindowHandle() {
        WebWindow window = this.webClient.getCurrentWindow();
        if (window.getName() == null || "".equals(window.getName())) {
            this.nameWindow(window);
        }
        return window.getName();
    }

    private String nameWindow(WebWindow window) {
        String windowName = "webdriver" + this.windowNamer.incrementAndGet();
        window.setName(windowName);
        return windowName;
    }

    public Object executeScript(String script, Object ... args) {
        if (!(this.lastPage() instanceof HtmlPage)) {
            throw new UnsupportedOperationException("Cannot execute JS against a plain text page");
        }
        HtmlPage page = (HtmlPage)this.lastPage();
        if (!this.isJavascriptEnabled()) {
            throw new UnsupportedOperationException("Javascript is not enabled for this HtmlUnitDriver instance");
        }
        Object[] parameters = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof HtmlUnitWebElement || args[i] instanceof HtmlElement || args[i] instanceof Number || args[i] instanceof String || args[i] instanceof Boolean)) {
                throw new IllegalArgumentException("Argument must be a string, number, boolean or WebElement: " + args[i] + " (" + args[i].getClass() + ")");
            }
            if (args[i] instanceof HtmlUnitWebElement) {
                HtmlElement element = ((HtmlUnitWebElement)args[i]).getElement();
                parameters[i] = element.getScriptObject();
                continue;
            }
            parameters[i] = args[i] instanceof HtmlElement ? ((HtmlElement)args[i]).getScriptObject() : args[i];
        }
        script = "function() {" + script + "};";
        ScriptResult result = page.executeJavaScript(script);
        Function func = (Function)result.getJavaScriptResult();
        Object value = (result = page.executeJavaScriptFunctionIfPossible(func, (Scriptable)((ScriptableObject)this.currentWindow.getScriptObject()), parameters, (DomNode)page.getDocumentElement())).getJavaScriptResult();
        if (value instanceof HTMLElement) {
            return this.newHtmlUnitWebElement(((HTMLElement)value).getDomNodeOrDie());
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return result.getJavaScriptResult();
    }

    public WebDriver.TargetLocator switchTo() {
        return new HtmlUnitTargetLocator();
    }

    public WebDriver.Navigation navigate() {
        return new HtmlUnitNavigation();
    }

    protected synchronized Page lastPage() {
        return this.currentWindow.getEnclosedPage();
    }

    public WebElement findElementByLinkText(String selector) {
        int equalsIndex = selector.indexOf(61) + 1;
        String expectedText = selector.substring(equalsIndex).trim();
        if (!(this.lastPage() instanceof HtmlPage)) {
            throw new IllegalStateException("Cannot find links for " + this.lastPage());
        }
        List anchors = ((HtmlPage)this.lastPage()).getAnchors();
        for (HtmlAnchor anchor : anchors) {
            if (!expectedText.equals(anchor.asText())) continue;
            return this.newHtmlUnitWebElement((HtmlElement)anchor);
        }
        throw new NoSuchElementException("No link found with text: " + expectedText);
    }

    protected WebElement newHtmlUnitWebElement(HtmlElement element) {
        if (this.isJavascriptEnabled()) {
            return new RenderedHtmlUnitDriverWebElement(this, element);
        }
        return new HtmlUnitWebElement(this, element);
    }

    public List<WebElement> findElementsByLinkText(String selector) {
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        if (!(this.lastPage() instanceof HtmlPage)) {
            return elements;
        }
        int equalsIndex = selector.indexOf(61) + 1;
        String expectedText = selector.substring(equalsIndex).trim();
        List anchors = ((HtmlPage)this.lastPage()).getAnchors();
        for (HtmlAnchor anchor : anchors) {
            if (!expectedText.equals(anchor.asText())) continue;
            elements.add(this.newHtmlUnitWebElement((HtmlElement)anchor));
        }
        return elements;
    }

    public WebElement findElementById(String id) {
        if (!(this.lastPage() instanceof HtmlPage)) {
            throw new NoSuchElementException("Cannot find element by id for " + this.lastPage());
        }
        try {
            HtmlElement element = ((HtmlPage)this.lastPage()).getHtmlElementById(id);
            return this.newHtmlUnitWebElement(element);
        }
        catch (ElementNotFoundException e) {
            throw new NoSuchElementException("Cannot find element with ID: " + id);
        }
    }

    public List<WebElement> findElementsById(String id) {
        return this.findElementsByXPath("//*[@id='" + id + "']");
    }

    public WebElement findElementByName(String name) {
        if (!(this.lastPage() instanceof HtmlPage)) {
            throw new IllegalStateException("Cannot find element by name for " + this.lastPage());
        }
        List allElements = ((HtmlPage)this.lastPage()).getElementsByName(name);
        if (allElements.size() > 0) {
            return this.newHtmlUnitWebElement((HtmlElement)allElements.get(0));
        }
        throw new NoSuchElementException("Cannot find element with name: " + name);
    }

    public List<WebElement> findElementsByName(String using) {
        if (!(this.lastPage() instanceof HtmlPage)) {
            return new ArrayList<WebElement>();
        }
        List allElements = ((HtmlPage)this.lastPage()).getElementsByName(using);
        return this.convertRawHtmlElementsToWebElements(allElements);
    }

    public WebElement findElementByTagName(String name) {
        if (!(this.lastPage() instanceof HtmlPage)) {
            throw new IllegalStateException("Cannot find element by name for " + this.lastPage());
        }
        DomNodeList allElements = ((HtmlPage)this.lastPage()).getElementsByTagName(name);
        if (allElements.getLength() > 0) {
            return this.newHtmlUnitWebElement((HtmlElement)allElements.item(0));
        }
        throw new NoSuchElementException("Cannot find element with name: " + name);
    }

    public List<WebElement> findElementsByTagName(String using) {
        if (!(this.lastPage() instanceof HtmlPage)) {
            return new ArrayList<WebElement>();
        }
        DomNodeList allElements = ((HtmlPage)this.lastPage()).getElementsByTagName(using);
        ArrayList<WebElement> toReturn = new ArrayList<WebElement>(allElements.getLength());
        for (int i = 0; i < allElements.getLength(); ++i) {
            Node item = allElements.item(i);
            if (!(item instanceof HtmlElement)) continue;
            toReturn.add(this.newHtmlUnitWebElement((HtmlElement)item));
        }
        return toReturn;
    }

    public WebElement findElementByXPath(String selector) {
        if (!(this.lastPage() instanceof HtmlPage)) {
            throw new IllegalStateException("Cannot find element by xpath for " + this.lastPage());
        }
        Object node = ((HtmlPage)this.lastPage()).getFirstByXPath(selector);
        if (node == null) {
            throw new NoSuchElementException("Cannot locate a node using " + selector);
        }
        if (node instanceof HtmlElement) {
            return this.newHtmlUnitWebElement((HtmlElement)node);
        }
        throw new NoSuchElementException(String.format("Cannot find element with xpath %s", selector));
    }

    public List<WebElement> findElementsByXPath(String selector) {
        if (!(this.lastPage() instanceof HtmlPage)) {
            return new ArrayList<WebElement>();
        }
        List nodes = ((HtmlPage)this.lastPage()).getByXPath(selector);
        return this.convertRawHtmlElementsToWebElements(nodes);
    }

    private List<WebElement> convertRawHtmlElementsToWebElements(List<?> nodes) {
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        for (Object node : nodes) {
            if (!(node instanceof HtmlElement)) continue;
            elements.add(this.newHtmlUnitWebElement((HtmlElement)node));
        }
        return elements;
    }

    public boolean isJavascriptEnabled() {
        return this.webClient.isJavaScriptEnabled();
    }

    public void setJavascriptEnabled(boolean enableJavascript) {
        this.enableJavascript = enableJavascript;
        this.webClient.setJavaScriptEnabled(enableJavascript);
    }

    protected WebDriver findActiveWindow() {
        FrameWindow frame;
        WebWindow window = this.webClient.getCurrentWindow();
        HtmlPage page = (HtmlPage)window.getEnclosedPage();
        if (page != null && page.getFrames().size() > 0 && !((frame = (FrameWindow)page.getFrames().get(0)).getFrameElement() instanceof HtmlInlineFrame)) {
            return new HtmlUnitDriver(this.isJavascriptEnabled(), (WebWindow)frame);
        }
        if (this.currentWindow != null && this.currentWindow.equals(window)) {
            return this;
        }
        return new HtmlUnitDriver(this.isJavascriptEnabled(), window);
    }

    protected WebClient getWebClient() {
        return this.webClient;
    }

    protected WebWindow getCurrentWindow() {
        return this.currentWindow;
    }

    public WebDriver.Options manage() {
        return new HtmlUnitOptions();
    }

    public WebElement findElementByPartialLinkText(String using) {
        if (!(this.lastPage() instanceof HtmlPage)) {
            throw new IllegalStateException("Cannot find links for " + this.lastPage());
        }
        List anchors = ((HtmlPage)this.lastPage()).getAnchors();
        for (HtmlAnchor anchor : anchors) {
            if (!anchor.asText().contains(using)) continue;
            return this.newHtmlUnitWebElement((HtmlElement)anchor);
        }
        throw new NoSuchElementException("No link found with text: " + using);
    }

    public List<WebElement> findElementsByPartialLinkText(String using) {
        List anchors = ((HtmlPage)this.lastPage()).getAnchors();
        Iterator allAnchors = anchors.iterator();
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        while (allAnchors.hasNext()) {
            HtmlAnchor anchor = (HtmlAnchor)allAnchors.next();
            if (!anchor.asText().contains(using)) continue;
            elements.add(this.newHtmlUnitWebElement((HtmlElement)anchor));
        }
        return elements;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HtmlUnitOptions
    implements WebDriver.Options {
        private HtmlUnitOptions() {
        }

        public void addCookie(Cookie cookie) {
            Page page = HtmlUnitDriver.this.lastPage();
            if (!(page instanceof HtmlPage)) {
                throw new WebDriverException("You may not set cookies on a page that is not HTML");
            }
            String domain = this.getDomainForCookie(cookie);
            this.verifyDomain(cookie, domain);
            HtmlUnitDriver.this.webClient.getCookieManager().addCookie(new org.apache.commons.httpclient.Cookie(domain, cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getExpiry(), cookie.isSecure()));
        }

        private void verifyDomain(Cookie cookie, String expectedDomain) {
            String domain = cookie.getDomain();
            if (domain == null) {
                return;
            }
            if ("".equals(domain)) {
                throw new WebDriverException("Domain must not be an empty string. Consider using null instead");
            }
            expectedDomain = expectedDomain.startsWith(".") ? expectedDomain : "." + expectedDomain;
            String string = domain = domain.startsWith(".") ? domain : "." + domain;
            if (!expectedDomain.endsWith(domain)) {
                throw new WebDriverException(String.format("You may only add cookies that would be visible to the current domain: %s => %s", domain, expectedDomain));
            }
        }

        public void deleteCookieNamed(String name) {
            CookieManager cookieManager = HtmlUnitDriver.this.webClient.getCookieManager();
            Set rawCookies = HtmlUnitDriver.this.webClient.getCookieManager().getCookies(this.getHostName());
            for (org.apache.commons.httpclient.Cookie cookie : rawCookies) {
                if (!name.equals(cookie.getName())) continue;
                cookieManager.removeCookie(cookie);
            }
        }

        public void deleteCookie(Cookie cookie) {
            this.deleteCookieNamed(cookie.getName());
        }

        public void deleteAllCookies() {
            HtmlUnitDriver.this.webClient.getCookieManager().clearCookies();
        }

        public Set<Cookie> getCookies() {
            Set rawCookies = HtmlUnitDriver.this.webClient.getCookieManager().getCookies(this.getHostName());
            HashSet<Cookie> retCookies = new HashSet<Cookie>();
            for (org.apache.commons.httpclient.Cookie c : rawCookies) {
                if (c.getPath() == null || !this.getPath().startsWith(c.getPath())) continue;
                retCookies.add((Cookie)new ReturnedCookie(c.getName(), c.getValue(), c.getDomain(), c.getPath(), c.getExpiryDate(), c.getSecure()));
            }
            return retCookies;
        }

        private String getHostName() {
            return HtmlUnitDriver.this.lastPage().getWebResponse().getRequestSettings().getUrl().getHost().toLowerCase();
        }

        private String getPath() {
            return HtmlUnitDriver.this.lastPage().getWebResponse().getRequestSettings().getUrl().getPath();
        }

        public Speed getSpeed() {
            throw new UnsupportedOperationException();
        }

        public void setSpeed(Speed speed) {
            throw new UnsupportedOperationException();
        }

        private String getDomainForCookie(Cookie cookie) {
            URL current = HtmlUnitDriver.this.lastPage().getWebResponse().getRequestSettings().getUrl();
            if (current.getPort() == 80) {
                return current.getHost();
            }
            return String.format("%s:%s", current.getHost(), current.getPort());
        }
    }

    private class HtmlUnitNavigation
    implements WebDriver.Navigation {
        private HtmlUnitNavigation() {
        }

        public void back() {
            History history = (History)HtmlUnitDriver.this.histories.get(HtmlUnitDriver.this.currentWindow);
            history.goBack();
        }

        public void forward() {
            History history = (History)HtmlUnitDriver.this.histories.get(HtmlUnitDriver.this.currentWindow);
            history.goForward();
        }

        public void to(String url) {
            HtmlUnitDriver.this.get(url);
        }

        public void to(URL url) {
            HtmlUnitDriver.this.get(url);
        }

        public void refresh() {
            if (HtmlUnitDriver.this.lastPage() instanceof HtmlPage) {
                try {
                    ((HtmlPage)HtmlUnitDriver.this.lastPage()).refresh();
                }
                catch (IOException e) {
                    throw new WebDriverException((Throwable)e);
                }
            }
        }
    }

    private class History {
        private final WebWindow window;
        private List<Page> history = new ArrayList<Page>();
        private int index = -1;

        private History(WebWindow window) {
            this.window = window;
        }

        public void addNewPage(Page newPage) {
            ++this.index;
            while (this.history.size() > this.index) {
                this.history.remove(this.index);
            }
            this.history.add(newPage);
        }

        public void goBack() {
            if (this.index > 0) {
                --this.index;
                this.window.setEnclosedPage(this.history.get(this.index));
            }
        }

        public void goForward() {
            if (this.index < this.history.size() - 1) {
                ++this.index;
                this.window.setEnclosedPage(this.history.get(this.index));
            }
        }
    }

    private class HtmlUnitTargetLocator
    implements WebDriver.TargetLocator {
        private HtmlUnitTargetLocator() {
        }

        public WebDriver frame(int frameIndex) {
            HtmlPage page = (HtmlPage)HtmlUnitDriver.this.webClient.getCurrentWindow().getEnclosedPage();
            try {
                HtmlUnitDriver.this.currentWindow = (WebWindow)page.getFrames().get(frameIndex);
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchFrameException("Cannot find frame: " + frameIndex);
            }
            return HtmlUnitDriver.this;
        }

        public WebDriver frame(String name) {
            String[] names;
            HtmlPage page = (HtmlPage)HtmlUnitDriver.this.webClient.getCurrentWindow().getEnclosedPage();
            WebWindow window = HtmlUnitDriver.this.webClient.getCurrentWindow();
            for (String frameName : names = name.split("\\.")) {
                try {
                    int index = Integer.parseInt(frameName);
                    window = (WebWindow)page.getFrames().get(index);
                }
                catch (NumberFormatException e) {
                    window = null;
                    for (FrameWindow frame : page.getFrames()) {
                        FrameWindow frameWindow = frame;
                        if (frameName.equals(frameWindow.getFrameElement().getId())) {
                            window = frameWindow;
                            break;
                        }
                        if (!frameName.equals(frameWindow.getName())) continue;
                        window = frameWindow;
                        break;
                    }
                    if (window == null) {
                        throw new NoSuchFrameException("Cannot find frame: " + name);
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    throw new NoSuchFrameException("Cannot find frame: " + name);
                }
                page = (HtmlPage)window.getEnclosedPage();
            }
            HtmlUnitDriver.this.currentWindow = window;
            return HtmlUnitDriver.this;
        }

        public WebDriver window(String windowId) {
            WebWindow window;
            try {
                window = HtmlUnitDriver.this.webClient.getWebWindowByName(windowId);
            }
            catch (WebWindowNotFoundException e) {
                throw new NoSuchWindowException("Cannot find window: " + windowId);
            }
            HtmlUnitDriver.this.webClient.setCurrentWindow(window);
            HtmlUnitDriver.this.pickWindow();
            return HtmlUnitDriver.this;
        }

        public WebDriver defaultContent() {
            HtmlUnitDriver.this.pickWindow();
            return HtmlUnitDriver.this;
        }

        public WebElement activeElement() {
            Page page = HtmlUnitDriver.this.currentWindow.getEnclosedPage();
            if (page instanceof HtmlPage) {
                HtmlElement element = ((HtmlPage)page).getFocusedElement();
                if (element == null) {
                    List allBodies = ((HtmlPage)page).getDocumentElement().getHtmlElementsByTagName("body");
                    if (allBodies.size() > 0) {
                        return HtmlUnitDriver.this.newHtmlUnitWebElement((HtmlElement)allBodies.get(0));
                    }
                } else {
                    return HtmlUnitDriver.this.newHtmlUnitWebElement(element);
                }
            }
            throw new NoSuchElementException("Unable to locate element with focus or body tag");
        }
    }
}

