/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaflacencoder;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import net.sourceforge.javaflacencoder.FLACOutputStream;

public class FLACFileOutputStream
implements FLACOutputStream,
Closeable {
    FileOutputStream fos = null;
    long position;
    long size = 0L;
    boolean valid;

    public FLACFileOutputStream(String filename) throws IOException {
        this.position = 0L;
        this.fos = new FileOutputStream(filename);
        this.valid = true;
    }

    public FLACFileOutputStream(File file) throws IOException {
        this.position = 0L;
        this.fos = new FileOutputStream(file);
        this.valid = true;
    }

    public FLACFileOutputStream(FileOutputStream fos) throws IOException {
        FileChannel fc = fos.getChannel();
        this.position = fc.position();
        this.fos = fos;
        this.valid = true;
    }

    @Deprecated
    public boolean isValid() {
        return this.valid;
    }

    public long seek(long pos) throws IOException {
        FileChannel fc = this.fos.getChannel();
        fc.position(pos);
        return pos;
    }

    public void write(byte data) throws IOException {
        this.fos.write(data);
        if (this.position + 1L > this.size) {
            this.size = this.position + 1L;
        }
        ++this.position;
    }

    public int write(byte[] data, int offset, int count) throws IOException {
        int result = count;
        this.fos.write(data, offset, count);
        if (this.position + (long)count > this.size) {
            this.size = this.position + (long)count;
        }
        this.position += (long)count;
        return result;
    }

    public long size() {
        return this.size;
    }

    public boolean canSeek() {
        return true;
    }

    public long getPos() {
        return this.position;
    }

    public void close() throws IOException {
        this.fos.close();
    }
}

