/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaflacencoder;

import net.sourceforge.javaflacencoder.EncodedElement;
import net.sourceforge.javaflacencoder.EncodingConfiguration;
import net.sourceforge.javaflacencoder.StreamConfiguration;
import net.sourceforge.javaflacencoder.Subframe;

public class Subframe_Verbatim
extends Subframe {
    public static int DEBUG_LEV = 0;
    public static final EncodingConfiguration.SubframeType type = EncodingConfiguration.SubframeType.VERBATIM;

    Subframe_Verbatim(StreamConfiguration sc) {
        super(sc);
    }

    public boolean registerConfiguration(EncodingConfiguration ec) {
        super.registerConfiguration(ec);
        return true;
    }

    public int estimateSize(int count, int bitsPerSample) {
        int estimatedSize = 8 + count * bitsPerSample;
        return estimatedSize;
    }

    public int encodeSamples(int[] samples, int count, int start, int skip, EncodedElement data, int offset, int bitsPerSample) {
        if (DEBUG_LEV > 0) {
            System.err.println("Subframe_Verbatim::encodeSamples(...)");
        }
        int encodedSamples = count;
        int bits = bitsPerSample * count + offset + 8;
        int bytesNeeded = bits / 8;
        if (bits % 8 != 0) {
            ++bytesNeeded;
        }
        data.clear(bytesNeeded, offset);
        data.addInt(0, 1);
        data.addInt(1, 6);
        data.addInt(0, 1);
        data.packInt(samples, bitsPerSample, start, skip, count);
        this.lastEncodedSize = bits - offset;
        if (DEBUG_LEV > 0) {
            System.err.println("Subframe_Verbatim::encodeSamples(...): End");
        }
        if (DEBUG_LEV > 10) {
            System.err.println("--: bitsUsed : " + bits + "  : Bytes : " + bytesNeeded);
        }
        return encodedSamples;
    }
}

