/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.ocrPlugins.OCRDemo;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import net.sourceforge.javaocr.ocrPlugins.mseOCR.CharacterRange;
import net.sourceforge.javaocr.ocrPlugins.mseOCR.OCRScanner;
import net.sourceforge.javaocr.ocrPlugins.mseOCR.TrainingImage;
import net.sourceforge.javaocr.ocrPlugins.mseOCR.TrainingImageLoader;
import net.sourceforge.javaocr.scanner.PixelImage;

public class OCRScannerDemo {
    private static final long serialVersionUID = 1L;
    private boolean debug = true;
    private Image image;
    private OCRScanner scanner = new OCRScanner();
    private static final Logger LOG = Logger.getLogger(OCRScannerDemo.class.getName());

    public void loadTrainingImages(String trainingImageDir) {
        if (this.debug) {
            System.err.println("loadTrainingImages(" + trainingImageDir + ")");
        }
        if (!trainingImageDir.endsWith(File.separator)) {
            trainingImageDir = trainingImageDir + File.separator;
        }
        try {
            this.scanner.clearTrainingImages();
            TrainingImageLoader loader = new TrainingImageLoader();
            HashMap<Character, ArrayList<TrainingImage>> trainingImageMap = new HashMap<Character, ArrayList<TrainingImage>>();
            if (this.debug) {
                System.err.println("ascii.png");
            }
            loader.load(trainingImageDir + "ascii.png", new CharacterRange(33, 126), trainingImageMap);
            if (this.debug) {
                System.err.println("hpljPica.jpg");
            }
            loader.load(trainingImageDir + "hpljPica.jpg", new CharacterRange(33, 126), trainingImageMap);
            if (this.debug) {
                System.err.println("digits.jpg");
            }
            loader.load(trainingImageDir + "digits.jpg", new CharacterRange(48, 57), trainingImageMap);
            if (this.debug) {
                System.err.println("adding images");
            }
            this.scanner.addTrainingImages(trainingImageMap);
            if (this.debug) {
                System.err.println("loadTrainingImages() done");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.exit(2);
        }
    }

    public void process(String imageFilename) {
        if (this.debug) {
            System.err.println("process(" + imageFilename + ")");
        }
        try {
            this.image = ImageIO.read(new File(imageFilename));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.image == null) {
            System.err.println("Cannot find image file: " + imageFilename);
            return;
        }
        if (this.debug) {
            System.err.println("constructing new PixelImage");
        }
        PixelImage pixelImage = new PixelImage(this.image);
        if (this.debug) {
            System.err.println("converting PixelImage to grayScale");
        }
        pixelImage.toGrayScale(true);
        if (this.debug) {
            System.err.println("filtering");
        }
        pixelImage.filter();
        if (this.debug) {
            System.err.println("setting image for display");
        }
        System.out.println(imageFilename + ":");
        String text = this.scanner.scan(this.image, 0, 0, 0, 0, null);
        System.out.println("[" + text + "]");
    }

    public static void main(String[] args) {
        String trainingImageDir;
        if (args.length < 1) {
            System.err.println("Please specify one or more image filenames.");
            System.exit(1);
        }
        if ((trainingImageDir = System.getProperty("TRAINING_IMAGE_DIR")) == null) {
            System.err.println("Please specify -DTRAINING_IMAGE_DIR=<dir> on the java command line.");
            return;
        }
        OCRScannerDemo demo = new OCRScannerDemo();
        demo.loadTrainingImages(trainingImageDir);
        for (int i = 0; i < args.length; ++i) {
            demo.process(args[i]);
        }
        System.out.println("done.");
    }
}

