/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import net.sourceforge.jwebunit.api.IElement;
import net.sourceforge.jwebunit.tests.JWebUnitAPITestCase;
import net.sourceforge.jwebunit.tests.util.JettySetup;

public class FormAssertionsTest
extends JWebUnitAPITestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite(FormAssertionsTest.class);
        return new JettySetup((Test)suite);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.setBaseUrl("http://localhost:8082/jwebunit/FormAssertionsTest");
    }

    public void testAssertButtonWithTextPresent() {
        this.beginAt("/assertButtonWithText.html");
        this.assertButtonPresentWithText("foo");
        this.assertButtonPresentWithText("bar");
        this.assertButtonNotPresentWithText("foobar");
    }

    public void testAssertFormParameterPresent() throws Throwable {
        this.beginAt("/testPage.html");
        this.assertPassFail("assertFormElementPresent", "testInputElement", "noSuchElement");
        this.assertPass("assertFormElementPresent", "checkboxselected");
        this.assertPass("assertFormElementEmpty", "testInputElement2");
        this.assertPass("assertFormElementPresent", "text");
    }

    public void testAssertFormParameterNotPresent() throws Throwable {
        this.beginAt("/testPage.html");
        this.assertPassFail("assertFormElementNotPresent", "noSuchElement", "testInputElement");
    }

    public void testAssertFormPresent() throws Throwable {
        this.beginAt("/testPage.html");
        this.assertPass("assertFormPresent", NOARGS);
        this.beginAt("/noFormPage.html");
        this.assertFail("assertFormPresent", NOARGS);
        this.assertPass("assertFormNotPresent", NOARGS);
    }

    public void testAssertFormPresentByName() throws Throwable {
        this.beginAt("/testPage.html");
        this.assertPass("assertFormPresent", new String[]{"form2"});
        this.assertFail("assertFormPresent", new String[]{"noform"});
        this.assertPass("assertFormNotPresent", new String[]{"noform"});
    }

    public void testAssertFormElementEquals() throws Throwable {
        this.beginAt("/testPage.html");
        this.assertPassFail("assertTextFieldEquals", new Object[]{"testInputElement", "testValue"}, new Object[]{"testInputElement", "noSuchValue"});
        this.assertPass("assertSubmitButtonPresent", new Object[]{"submitButton", "buttonLabel"});
        this.setWorkingForm("form5");
        this.assertPass("assertTextFieldEquals", new Object[]{"textarea", "sometexthere"});
        this.setWorkingForm("form3");
        this.assertPass("assertRadioOptionSelected", new Object[]{"cool", "dog"});
        this.setWorkingForm("form5");
        this.assertPassFail("assertHiddenFieldPresent", new Object[]{"hiddenelement", "hiddenvalue"}, new Object[]{"hiddenelement", "notThisValue"});
        this.setWorkingForm("form1");
        this.assertFail("assertTextFieldEquals", new Object[]{"noSuchElement", "testValue"});
        this.assertFail("assertHiddenFieldPresent", new Object[]{"noSuchElement", "testValue"});
        this.setWorkingForm("form5");
        this.assertPassFail("assertTextFieldEquals", new Object[]{"passwordelement", "password"}, new Object[]{"passwordelement", "noSuchValue"});
    }

    public void testCheckboxSelected() throws Throwable {
        this.beginAt("/testPage.html");
        this.assertPassFail("assertCheckboxSelected", "checkboxselected", "checkboxnotselected");
        this.assertFail("assertCheckboxSelected", "nosuchbox");
    }

    public void testCheckboxSelectedByName() throws Throwable {
        this.beginAt("/testPage.html");
        this.assertPassFail("assertCheckboxSelected", new Object[]{"checkboxnotselected", "actuallyselected"}, new Object[]{"checkboxselected", "actuallynotselected"});
        this.assertFail("assertCheckboxSelected", new Object[]{"checkboxselected", "nosuchvalue"});
    }

    public void testCheckboxNotSelected() throws Throwable {
        this.beginAt("/testPage.html");
        this.assertPassFail("assertCheckboxNotSelected", "checkboxnotselected", "checkboxselected");
        this.assertFail("assertCheckboxNotSelected", "nosuchbox");
    }

    public void testCheckboxNotSelectedByName() throws Throwable {
        this.beginAt("/testPage.html");
        this.assertPassFail("assertCheckboxNotSelected", new Object[]{"checkboxselected", "actuallynotselected"}, new Object[]{"checkboxnotselected", "actuallyselected"});
        this.assertFail("assertCheckboxNotSelected", new Object[]{"checkboxnotselected", "nosuchvalue"});
    }

    public void testAssertSubmitButtonPresent() throws Throwable {
        this.beginAt("/testPage.html");
        this.assertPassFail("assertSubmitButtonPresent", "submitButton", "noSuchButton");
    }

    public void testAssertSubmitButtonNotPresent() throws Throwable {
        this.beginAt("/testPage.html");
        this.assertPassFail("assertSubmitButtonNotPresent", "noSuchButton", "submitButton");
    }

    public void testAssertSubmitButtonValue() throws Throwable {
        this.beginAt("/testPage.html");
        this.assertPassFail("assertSubmitButtonPresent", new Object[]{"submitButton", "buttonLabel"}, new Object[]{"submitButton", "noSuchLabel"});
    }

    public void testAssertResetButtonPresent() throws Throwable {
        this.beginAt("/testPage.html");
        this.assertPassFail("assertResetButtonPresent", "resetButton", "noSuchButton");
    }

    public void testAssertResetButtonNotPresent() throws Throwable {
        this.beginAt("/testPage.html");
        this.assertPassFail("assertResetButtonNotPresent", "noSuchButton", "resetButton");
    }

    public void testAssertRadioOptionPresent() throws Throwable {
        this.beginAt("/testPage.html");
        this.assertPassFail("assertRadioOptionPresent", new String[]{"cool", "cat"}, new String[]{"cool", "fish"});
    }

    public void testAssertRadioOptionNotPresent() throws Throwable {
        this.beginAt("/testPage.html");
        this.assertPassFail("assertRadioOptionNotPresent", new String[]{"cool", "fish"}, new String[]{"cool", "cat"});
    }

    public void testAssertRadioOptionSelected() throws Throwable {
        this.beginAt("/testPage.html");
        this.assertPassFail("assertRadioOptionSelected", new String[]{"cool", "dog"}, new String[]{"cool", "cat"});
    }

    public void testAssertRadioOptionNotSelected() throws Throwable {
        this.beginAt("/testPage.html");
        this.assertPassFail("assertRadioOptionNotSelected", new String[]{"cool", "cat"}, new String[]{"cool", "dog"});
    }

    public void testAssertSelectOptionPresent() throws Throwable {
        this.beginAt("/testPage.html");
        this.assertPassFail("assertSelectOptionPresent", new String[]{"selectOption", "One"}, new String[]{"selectOption", "NoSuchOption"});
    }

    public void testAssertSelectOptionNotPresent() throws Throwable {
        this.beginAt("/testPage.html");
        this.assertPassFail("assertSelectOptionNotPresent", new String[]{"selectOption", "NoSuchOption"}, new String[]{"selectOption", "One"});
    }

    public void testAssertSelectOptionValuePresent() throws Throwable {
        this.beginAt("/testPage.html");
        this.assertPassFail("assertSelectOptionValuePresent", new String[]{"selectOption", "1"}, new String[]{"selectOption", "NoSuchOption"});
    }

    public void testAssertSelectOptionValueNotPresent() throws Throwable {
        this.beginAt("/testPage.html");
        this.assertPassFail("assertSelectOptionValueNotPresent", new String[]{"selectOption", "NoSuchOption"}, new String[]{"selectOption", "1"});
    }

    public void testAssertSelectOptionsEqual() throws Throwable {
        this.beginAt("/testPage.html");
        this.assertPass("assertSelectOptionsEqual", new Object[]{"select1", new String[]{"one", "two", "three", "four"}});
        this.assertFail("assertSelectOptionsEqual", new Object[]{"select1", new String[]{"one", "four", "three", "two"}});
        this.assertFail("assertSelectOptionsEqual", new Object[]{"select1", new String[]{"one", "two", "three", "four", "five"}});
    }

    public void testAssertSelectOptionsNotEqual() throws Throwable {
        this.beginAt("/testPage.html");
        this.assertFail("assertSelectOptionsNotEqual", new Object[]{"select1", new String[]{"one", "two", "three", "four"}});
        this.assertPass("assertSelectOptionsNotEqual", new Object[]{"select1", new String[]{"one", "four", "three", "two"}});
        this.assertPass("assertSelectOptionsNotEqual", new Object[]{"select1", new String[]{"one", "two", "three", "four", "five"}});
    }

    public void testAssertSelectOptionValuesEqual() throws Throwable {
        this.beginAt("/testPage.html");
        this.assertPass("assertSelectOptionValuesEqual", new Object[]{"select1", new String[]{"1", "2", "3", "4"}});
        this.assertFail("assertSelectOptionValuesEqual", new Object[]{"select1", new String[]{"1", "4", "3", "2"}});
        this.assertFail("assertSelectOptionValuesEqual", new Object[]{"select1", new String[]{"1", "2", "3", "4", "5"}});
    }

    public void testAssertSelectOptionValuesNotEqual() throws Throwable {
        this.beginAt("/testPage.html");
        this.assertFail("assertSelectOptionValuesNotEqual", new Object[]{"select1", new String[]{"1", "2", "3", "4"}});
        this.assertPass("assertSelectOptionValuesNotEqual", new Object[]{"select1", new String[]{"1", "4", "3", "2"}});
        this.assertPass("assertSelectOptionValuesNotEqual", new Object[]{"select1", new String[]{"1", "2", "3", "4", "5"}});
    }

    public void testAssertSelectedOptionEquals() throws Throwable {
        this.beginAt("/testPage.html");
        this.assertPassFail("assertSelectedOptionEquals", new String[]{"select1", "one"}, new String[]{"select1", "two"});
    }

    public void testAssertSelectedOptionValueEquals() throws Throwable {
        this.beginAt("/testPage.html");
        this.assertPassFail("assertSelectedOptionValueEquals", new String[]{"select1", "1"}, new String[]{"select1", "2"});
    }

    public void testAssertButtonPresent() throws Throwable {
        this.beginAt("/testPage.html");
        this.assertPassFail("assertButtonPresent", "b1", "nobutton");
    }

    public void testAssertButtonNotPresent() throws Throwable {
        this.beginAt("/testPage.html");
        this.assertPassFail("assertButtonNotPresent", "nobutton", "b1");
    }

    public void testComplicatedElementNames() {
        String[] names;
        this.beginAt("/testPage.html");
        for (String s : names = new String[]{"complicated[5]", "complicated'6'", "complicated['7'].8"}) {
            this.assertFormElementPresent(s);
            this.assertTextFieldEquals(s, s);
        }
    }

    public void testIssue1996193() {
        this.beginAt("/testPage.html");
        String option1 = "coreAnswers['0-1'].strAnswer";
        this.assertRadioOptionPresent(option1, "1");
        this.clickRadioOption(option1, "1");
        this.assertRadioOptionSelected(option1, "1");
    }

    public void testLabels() {
        this.beginAt("/testPage.html");
        this.assertLabelPresent("label1");
        this.assertLabeledFieldEquals("label1", "one");
        this.assertLabelPresent("label2");
        this.assertLabeledFieldEquals("label2", "two");
        this.assertLabelPresent("label3");
        this.assertLabeledFieldEquals("label3", "three");
        this.assertLabelPresent("label4");
        this.assertLabeledFieldEquals("label4", "2");
        this.assertLabelPresent("label5");
        this.assertLabeledFieldEquals("label5", "2");
        this.assertLabelPresent("label6");
        this.assertLabeledFieldEquals("label6", "ten");
        this.assertLabelPresent("label7");
        this.assertLabeledFieldEquals("label7", "10");
        this.assertLabelPresent("label8");
        this.assertLabeledFieldEquals("label8", "eight");
    }

    public void testSetLabels() {
        this.beginAt("/testPage.html");
        this.assertLabelPresent("label1");
        this.assertLabeledFieldEquals("label1", "one");
        this.assertTextFieldEquals("label1_field1", "one");
        FormAssertionsTest.assertEquals((String)this.getElementById("field1_id").getAttribute("value"), (String)"one");
        this.setLabeledFormElementField("label1", "two");
        this.assertLabeledFieldEquals("label1", "two");
        this.assertTextFieldEquals("label1_field1", "two");
        FormAssertionsTest.assertEquals((String)this.getElementById("field1_id").getAttribute("value"), (String)"two");
        this.setTextField("label1_field1", "three");
        this.assertLabeledFieldEquals("label1", "three");
        this.assertTextFieldEquals("label1_field1", "three");
        FormAssertionsTest.assertEquals((String)this.getElementById("field1_id").getAttribute("value"), (String)"three");
        IElement element = this.getElementById("field1_id");
        FormAssertionsTest.assertNotNull((Object)element);
        element.setAttribute("value", "four");
        this.assertLabeledFieldEquals("label1", "four");
        this.assertTextFieldEquals("label1_field1", "four");
        FormAssertionsTest.assertEquals((String)this.getElementById("field1_id").getAttribute("value"), (String)"four");
    }

    public void testLabeledEmptyElement() {
        this.beginAt("/testPage.html");
        this.assertLabeledFieldEquals("label9", "");
    }
}

