/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit.tests;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestSuite;
import net.sourceforge.jwebunit.tests.JWebUnitAPITestCase;
import net.sourceforge.jwebunit.tests.util.JettySetup;

public class FormSubmissionTest
extends JWebUnitAPITestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite(FormSubmissionTest.class);
        return new JettySetup((Test)suite);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.setBaseUrl("http://localhost:8082/jwebunit/FormSubmissionTest");
    }

    public void testSetTextField() {
        this.beginAt("/SingleNamedButtonForm.html");
        this.setTextField("color", "blue");
        this.submit("button");
        this.assertTextPresent("Submitted parameters");
        this.assertTextPresent("color=blue");
        this.clickLink("return");
        this.setTextField("color", "red");
        this.submit();
        this.assertTextPresent("color=red");
    }

    public void testSetTextArea() {
        this.beginAt("/TextAreaForm.html");
        this.setTextField("text", "sometext");
        this.submit("button");
        this.assertTextPresent("Submitted parameters");
        this.assertTextPresent("Params are:" + System.getProperty("line.separator") + "text=sometext");
        this.clickLink("return");
        this.setTextField("text", "anothertext");
        this.submit();
        this.assertTextPresent("text=anothertext");
    }

    public void testSetFileField() {
        this.beginAt("/InputFileForm.html");
        File temp = null;
        try {
            temp = File.createTempFile("data", ".txt");
            temp.deleteOnExit();
            BufferedWriter out = new BufferedWriter(new FileWriter(temp));
            out.write("abcdefgh");
            out.close();
        }
        catch (IOException e) {
            FormSubmissionTest.fail((String)e.toString());
        }
        String filename = temp.getAbsolutePath();
        this.setTextField("file", filename);
        this.submit("button");
        this.assertTextPresent("Submitted parameters");
        this.assertTextPresent("file=" + temp.getName() + "{abcdefgh}");
    }

    public void testSubmitImageInput() {
        this.beginAt("/InputImageForm.html");
        this.setTextField("color", "toto");
        this.assertSubmitButtonPresent();
        this.submit();
        this.assertTextPresent("Submitted parameters");
        this.assertTextPresent("color=toto");
    }

    public void testSubmitImageInputByName() {
        this.beginAt("/InputImageForm.html");
        this.setTextField("color", "toto");
        this.assertSubmitButtonPresent("image");
        this.submit("image");
        this.assertTextPresent("Submitted parameters");
        this.assertTextPresent("color=toto");
    }

    public void testCheckBoxSelection() {
        this.beginAt("/SingleNamedButtonForm.html");
        this.checkCheckbox("checkBox");
        this.setTextField("color", "blue");
        this.submit();
        this.assertTextPresent("color=blue");
        this.assertTextPresent("checkBox=,on");
    }

    public void testCheckBoxSelectionWithSameFieldName() {
        this.beginAt("/CheckboxForm.html");
        this.checkCheckbox("checkBox", "1");
        this.checkCheckbox("checkBox", "3");
        this.checkCheckbox("checkBox", "3");
        this.submit();
        this.assertTextPresent("checkBox=1,3" + System.getProperty("line.separator"));
    }

    public void testCheckBoxDeSelectionWithSameFieldName() {
        this.beginAt("/CheckboxForm.html");
        this.checkCheckbox("checkBox", "1");
        this.checkCheckbox("checkBox", "3");
        this.uncheckCheckbox("checkBox", "3");
        this.submit();
        this.assertTextPresent("checkBox=1");
    }

    public void testCheckBoxDeselection() {
        this.beginAt("/SingleNamedButtonForm.html");
        this.checkCheckbox("checkBox");
        this.assertCheckboxSelected("checkBox");
        this.setTextField("color", "blue");
        this.uncheckCheckbox("checkBox");
        this.submit();
        this.assertTextPresent("color=blue" + System.getProperty("line.separator"));
    }

    public void testRadioSelection() {
        this.beginAt("/RadioForm.html");
        this.clickRadioOption("radio", "1");
        this.assertRadioOptionSelected("radio", "1");
        this.submit();
        this.assertTextPresent("radio=1" + System.getProperty("line.separator"));
        this.clickLink("return");
        this.clickRadioOption("radio", "2");
        this.clickRadioOption("radio", "3");
        this.assertRadioOptionNotSelected("radio", "1");
        this.assertRadioOptionNotSelected("radio", "2");
        this.assertRadioOptionSelected("radio", "3");
        this.submit();
        this.assertTextPresent("radio=3" + System.getProperty("line.separator"));
    }

    public void testSingleFormSingleUnnamedButtonSubmission() {
        this.beginAt("/SingleUnnamedButtonForm.html");
        this.setTextField("color", "blue");
        this.submit();
        this.assertTextPresent("color=blue" + System.getProperty("line.separator"));
    }

    public void testSingleNamedButtonSubmission() {
        this.beginAt("/SingleNamedButtonForm.html");
        this.setTextField("color", "red");
        this.submit();
        this.assertTextPresent("color=red");
    }

    public void testSingleFormMultipleButtonSubmission() {
        this.gotoMultiButtonPage();
        this.submit("color");
        this.assertTextPresent("Params are:" + System.getProperty("line.separator") + "color=red");
        this.gotoMultiButtonPage();
        this.submit("color", "blue");
        this.assertTextPresent("color=blue");
    }

    public void testBogusParameter() {
        this.gotoMultiButtonPage();
        try {
            this.setTextField("nonexistent", "anyvalue");
        }
        catch (AssertionFailedError e) {
            return;
        }
        FormSubmissionTest.fail((String)"Expected AssertionFailedError");
    }

    public void testParamSetOnMultiForm() {
        this.beginAt("/MultiFormPage.html");
        this.setTextField("param1", "anyvalue");
        this.setWorkingForm("form2");
        this.setTextField("param2", "anyvalue");
        this.submit("button2a");
        this.assertTextPresent("param2=anyvalue");
    }

    public void testTextFieldSetOnMultiFormWithSameName() {
        this.beginAt("/MultiFormPage.html");
        this.setWorkingForm("form2");
        this.setTextField("param2", "foo");
        this.setTextField("email", "anyvalue");
        this.submit();
        this.assertTextPresent("email=anyvalue");
        this.assertTextPresent("param2=foo");
        this.closeBrowser();
        this.beginAt("/MultiFormPage.html");
        this.setWorkingForm("form3");
        this.setTextField("param3", "foo");
        this.setTextField("email", "anyvalue");
        this.submit();
        this.assertTextPresent("param3=foo");
        this.assertTextPresent("email=anyvalue");
    }

    public void testSetWorkingFormById() {
        this.beginAt("/MultiFormPage.html");
        this.setWorkingForm("form5");
    }

    public void testSetWorkingFormWithSameName() {
        this.beginAt("/MultiFormPage.html");
        this.setWorkingForm("myForm", 0);
        this.assertSubmitButtonPresent("myInput1");
        this.assertSubmitButtonNotPresent("myInput2");
        this.setWorkingForm("myForm", 1);
        this.assertSubmitButtonNotPresent("myInput1");
        this.assertSubmitButtonPresent("myInput2");
    }

    public void testInvalidButton() {
        this.beginAt("/InvalidActionForm.html");
        try {
            this.submit("button1");
            FormSubmissionTest.fail((String)"Should have failed because the target page does not exist");
        }
        catch (RuntimeException e) {
            FormSubmissionTest.assertTrue((String)"Should return 404 error", (boolean)true);
        }
    }

    public void testUnnamedSubmitOnSpecificForm() {
        this.beginAt("/MultiFormPage.html");
        this.setTextField("param4", "anyvalue");
        this.submit();
        this.assertTextPresent("param4=anyvalue");
    }

    public void testNamedSubmitOnSpecificForm() {
        this.beginAt("/MultiFormPage.html");
        this.setTextField("param2", "anyvalue");
        this.submit("button2b");
        this.assertTextPresent("param2=anyvalue" + System.getProperty("line.separator"));
        this.assertTextPresent("button2b=b2b");
    }

    public void testSubmissionReset() {
        this.beginAt("/MultiFormPage.html");
        this.setTextField("param2", "anyvalue");
        this.reset();
        this.submit("button2b");
        this.assertTextNotPresent("param2=anyvalue\n");
        this.assertTextPresent("button2b=b2b");
    }

    public void testSelectOption() {
        this.beginAt("/MultiFormPage.html");
        this.assertSelectedOptionEquals("select1", "one");
        this.selectOption("select1", "two");
        this.assertSelectedOptionEquals("select1", "two");
    }

    public void testSelectOptionInAnotherForm() {
        this.beginAt("/MultiFormPage.html");
        this.setWorkingForm("form6bis");
        this.assertSelectedOptionEquals("select1", "four");
        this.selectOption("select1", "five");
        this.assertSelectedOptionEquals("select1", "five");
    }

    public void testSelectOptionByValue() {
        this.beginAt("/MultiFormPage.html");
        this.assertSelectedOptionValueEquals("select1", "1");
        this.selectOptionByValue("select1", "2");
        this.assertSelectedOptionValueEquals("select1", "2");
    }

    private void gotoMultiButtonPage() {
        this.beginAt("/MultiNamedButtonForm.html");
    }

    public void testCachedForm() {
        this.beginAt("/Submit1.html");
        this.assertTextPresent("Page 1");
        this.submit();
        this.assertTextPresent("Page 2");
        this.submit();
        this.assertTextPresent("Page 3");
    }

    public void testClickButtonWithText1() {
        this.beginAt("/SingleNamedButtonForm.html");
        this.setTextField("color", "blue");
        this.clickButtonWithText("click me");
        this.assertTextPresent("Submitted parameters");
        this.assertTextPresent("color=blue");
    }

    public void testSetHiddenField() {
        this.beginAt("/SingleNamedButtonForm.html");
        this.assertHiddenFieldPresent("hidden", "foo");
        this.setHiddenField("hidden", "bar");
        this.submit();
        this.assertTextPresent("hidden=bar");
    }
}

