/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import net.sourceforge.jwebunit.tests.JWebUnitAPITestCase;
import net.sourceforge.jwebunit.tests.util.JettySetup;

public class FramesAndWindowsTest
extends JWebUnitAPITestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite(FramesAndWindowsTest.class);
        return new JettySetup((Test)suite);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.setBaseUrl("http://localhost:8082/jwebunit/FramesAndWindowsTest");
    }

    private void gotoRootAndOpenChild(String childName) {
        this.beginAt("RootPage.html");
        this.clickLink(childName);
    }

    public void testOpenWindow() throws Throwable {
        this.gotoRootAndOpenChild("ChildPage1");
        this.assertPassFail("assertWindowPresent", new Object[]{"ChildPage1"}, new Object[]{"NoSuchChild"});
    }

    public void testGotoWindow() {
        this.gotoRootAndOpenChild("ChildPage1");
        this.gotoWindow("ChildPage1");
        this.assertTextPresent("child 1");
    }

    public void testGotoWindowByID() {
        this.gotoRootAndOpenChild("ChildPage3");
        this.gotoWindow(1);
        this.assertTextPresent("child 3");
    }

    public void testGotoWindowByTitle() {
        this.gotoRootAndOpenChild("ChildPage2");
        this.gotoWindowByTitle("Child Page 2");
        this.assertTextPresent("child 2");
    }

    public void testAssertWindowWithTitle() throws Throwable {
        this.gotoRootAndOpenChild("ChildPage2");
        this.assertPassFail("assertWindowPresentWithTitle", new Object[]{"Child Page 2"}, new Object[]{"NoSuchTitle"});
    }

    public void testSwitchWindows() {
        this.gotoRootAndOpenChild("ChildPage1");
        this.gotoWindow("ChildPage1");
        this.gotoRootWindow();
        this.assertTextPresent("This is the Root");
    }

    public void testCloseWindow() {
        this.beginAt("RootPage.html");
        this.assertTitleEquals("This is the Root");
        this.clickLink("ChildPage1");
        this.gotoWindow("ChildPage1");
        this.assertTextPresent("child 1");
        this.closeWindow();
        this.assertWindowCountEquals(1);
        this.assertTitleEquals("This is the Root");
    }

    public void testAssertWindowCountEquals() {
        this.beginAt("RootPage.html");
        this.assertWindowCountEquals(1);
        this.clickLink("ChildPage1");
        this.assertWindowCountEquals(2);
        this.gotoWindow("ChildPage1");
        this.closeWindow();
        this.assertWindowCountEquals(1);
    }

    public void testGotoFrame() {
        this.beginAt("Frames.html");
        this.assertFramePresent("TopFrame");
        this.gotoFrame("TopFrame");
        this.assertTextPresent("TopFrame");
        this.gotoRootWindow();
        this.assertFramePresent("BottomFrame");
        this.gotoFrame("BottomFrame");
        this.assertTextPresent("BottomFrame");
        this.gotoRootWindow();
        this.assertFramePresent("ContentFrame");
        this.gotoFrame("ContentFrame");
        this.assertTextPresent("ContentFrame");
        this.assertException(RuntimeException.class, "gotoFrame", new Object[]{"BottomFrame"});
    }

    public void testGetFrameSource() {
        this.beginAt("Frames.html");
        FramesAndWindowsTest.assertTrue((this.getPageSource().indexOf("<frameset rows=\"33%, 33%, 33%\">") >= 0 ? 1 : 0) != 0);
        this.gotoFrame("TopFrame");
        FramesAndWindowsTest.assertEquals((String)"<html><body>TopFrame</body></html>", (String)this.getPageSource());
        this.assertTextPresent("TopFrame");
    }

    public void testGotoFrameById() {
        this.beginAt("Frames.html");
        this.assertFramePresent("frame1");
        this.gotoFrame("frame1");
        this.assertTextPresent("TopFrame");
        this.gotoRootWindow();
        this.assertFramePresent("frame3");
        this.gotoFrame("frame3");
        this.assertTextPresent("BottomFrame");
        this.gotoRootWindow();
        this.assertFramePresent("frame2");
        this.gotoFrame("frame2");
        this.assertTextPresent("ContentFrame");
        this.assertException(RuntimeException.class, "gotoFrame", new Object[]{"TopFrame"});
    }

    public void testGotoInlineFrame() {
        this.beginAt("InlineFrame.html");
        this.assertTextPresent("TopFrame");
        this.assertTextNotPresent("ContentFrame");
        this.gotoFrame("ContentFrame");
        this.assertTextPresent("ContentFrame");
    }

    public void testFormInputInFrame() {
        this.beginAt("Frames.html");
        this.gotoFrame("ContentFrame");
        this.assertFormPresent();
        this.setTextField("color", "red");
        this.submit("submit");
        this.assertTextPresent("color=red" + System.getProperty("line.separator"));
    }

    public void testFormInputInInlineFrame() {
        this.beginAt("InlineFrame.html");
        this.gotoFrame("ContentFrame");
        this.assertFormPresent();
        this.setTextField("color", "red");
        this.submit("submit");
        this.assertTextPresent("color=red" + System.getProperty("line.separator"));
    }

    public void testFormInputInFrameToFrame() {
        this.beginAt("Frames.html");
        this.gotoFrame("ContentFrame");
        this.setTextField("color", "green");
        this.submit();
        this.assertTitleEquals("Submitted parameters");
    }
}

