/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit.tests;

import java.util.Date;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestSuite;
import net.sourceforge.jwebunit.api.IElement;
import net.sourceforge.jwebunit.tests.JWebUnitAPITestCase;
import net.sourceforge.jwebunit.tests.util.JettySetup;

public class IElementTest
extends JWebUnitAPITestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite(IElementTest.class);
        return new JettySetup((Test)suite);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.setBaseUrl("http://localhost:8082/jwebunit/IElementTest");
        this.beginAt("/template.html");
    }

    public void testSimple() {
        IElement element = this.getElementByXPath("//input[@id='test']");
        IElementTest.assertNotNull((Object)element);
        IElementTest.assertEquals((String)element.getName(), (String)"input");
        IElementTest.assertEquals((String)element.getAttribute("name"), (String)"element_name");
        IElementTest.assertEquals((String)element.getAttribute("id"), (String)"test");
        IElementTest.assertEquals((String)element.getAttribute("value"), (String)"test3");
    }

    public void testMissing() {
        try {
            this.getElementByXPath("//input[@id='test2']");
            IElementTest.fail((String)"getElementByXPath() should have thrown an assertion exception.");
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }

    public void testChildren() {
        this.assertElementPresent("first");
        IElement element = this.getElementById("first");
        IElementTest.assertEquals((String)element.getName(), (String)"li");
        IElementTest.assertEquals((String)element.getTextContent(), (String)"one");
        IElementTest.assertEquals((String)element.getAttribute("id"), (String)"first");
        IElement parent = element.getParent();
        IElementTest.assertEquals((String)parent.getName(), (String)"ol");
        List children = parent.getChildren();
        IElementTest.assertEquals((int)children.size(), (int)4);
        IElementTest.assertEquals((String)((IElement)children.get(0)).getTextContent(), (String)"one");
        IElementTest.assertEquals((String)((IElement)children.get(1)).getTextContent(), (String)"two");
        IElementTest.assertEquals((String)((IElement)children.get(2)).getTextContent(), (String)"three");
        IElementTest.assertEquals((String)((IElement)children.get(3)).getTextContent(), (String)"four");
        for (IElement e : children) {
            IElementTest.assertEquals((String)e.getName(), (String)"li");
        }
    }

    public void testMultiple() {
        List children = this.getElementsByXPath("//li");
        IElementTest.assertEquals((int)children.size(), (int)4);
        IElementTest.assertEquals((String)((IElement)children.get(0)).getTextContent(), (String)"one");
        IElementTest.assertEquals((String)((IElement)children.get(1)).getTextContent(), (String)"two");
        IElementTest.assertEquals((String)((IElement)children.get(2)).getTextContent(), (String)"three");
        IElementTest.assertEquals((String)((IElement)children.get(3)).getTextContent(), (String)"four");
    }

    public void testChanging() {
        IElement element = this.getElementByXPath("//input[@id='test']");
        IElementTest.assertNotNull((Object)element);
        IElementTest.assertEquals((String)element.getName(), (String)"input");
        IElementTest.assertEquals((String)element.getAttribute("name"), (String)"element_name");
        IElementTest.assertEquals((String)element.getAttribute("id"), (String)"test");
        IElementTest.assertEquals((String)element.getAttribute("value"), (String)"test3");
        this.assertFormElementPresent("element_name");
        String testingText = new Date().toString();
        this.setTextField("element_name", testingText);
        this.assertTextFieldEquals("element_name", testingText);
        IElement element2 = this.getElementByXPath("//input[@id='test']");
        IElementTest.assertNotNull((Object)element2);
        IElementTest.assertEquals((String)element2.getName(), (String)"input");
        IElementTest.assertEquals((String)element2.getAttribute("name"), (String)"element_name");
        IElementTest.assertEquals((String)element2.getAttribute("id"), (String)"test");
        IElementTest.assertEquals((String)element2.getAttribute("value"), (String)testingText);
        this.assertFormElementPresent("element_name");
    }

    public void testWithXpath() {
        IElement element = this.getElementByXPath("//body");
        IElementTest.assertNotNull((Object)element);
        IElementTest.assertEquals((String)"body", (String)element.getName());
        IElement input = element.getElement("input");
        IElementTest.assertNotNull((Object)input);
        IElementTest.assertEquals((String)"input", (String)input.getName());
        IElementTest.assertEquals((String)"element_name", (String)input.getAttribute("name"));
        IElementTest.assertEquals((String)"test3", (String)input.getAttribute("value"));
        List inputs = element.getElements("input");
        IElementTest.assertEquals((int)4, (int)inputs.size());
        IElementTest.assertEquals((String)"test3", (String)((IElement)inputs.get(0)).getAttribute("value"));
        IElementTest.assertEquals((String)"Do nothing", (String)((IElement)inputs.get(1)).getAttribute("value"));
        IElementTest.assertEquals((String)"initial", (String)((IElement)inputs.get(2)).getAttribute("value"));
        IElementTest.assertEquals((String)"unchanged", (String)((IElement)inputs.get(3)).getAttribute("value"));
        this.assertMatch("init.+", ((IElement)inputs.get(2)).getAttribute("value"));
        this.assertNotMatch("^xinitial", ((IElement)inputs.get(2)).getAttribute("value"));
        this.assertMatch("test regexp with message", "init.+", ((IElement)inputs.get(2)).getAttribute("value"));
        this.assertNotMatch("test regexp with message", "$xinitial", ((IElement)inputs.get(2)).getAttribute("value"));
        IElement parent = element.getElement("..");
        IElementTest.assertNotNull((Object)parent);
        IElementTest.assertEquals((String)"html", (String)parent.getName());
    }

    public void testAttributeJavascript() {
        String testingText = new Date().toString();
        IElement js1 = this.getElementById("js1");
        IElement js2 = this.getElementById("js2");
        IElementTest.assertEquals((String)js1.getAttribute("value"), (String)"initial");
        IElementTest.assertEquals((String)js2.getAttribute("value"), (String)"unchanged");
        js1.setAttribute("value", testingText);
        js1 = this.getElementById("js1");
        js2 = this.getElementById("js2");
        IElementTest.assertEquals((String)js1.getAttribute("value"), (String)testingText);
        IElementTest.assertEquals((String)js2.getAttribute("value"), (String)testingText);
    }

    public void testComments() {
        this.assertCommentPresent("a comment");
        this.assertCommentPresent("another comment");
        this.assertCommentPresent("  a comment");
        this.assertCommentPresent("   another comment  ");
        this.assertCommentNotPresent("A Comment");
        this.assertCommentNotPresent("definitely not here");
    }

    public void testPreceding() {
        IElement element = this.getElementById("first");
        IElement preceding = element.getElement("preceding::input");
        IElementTest.assertEquals((String)preceding.getName(), (String)"input");
        IElementTest.assertEquals((String)preceding.getAttribute("name"), (String)"element_name");
    }

    public void testIElementEquals() {
        IElement container1 = this.getElementById("container");
        IElement span = this.getElementByXPath("//span[@class='inline']");
        IElement container2 = span.getElement("..");
        IElement container3 = null;
        for (IElement e : this.getElementsByXPath("//div")) {
            if (!"container".equals(e.getAttribute("id"))) continue;
            container3 = e;
        }
        IElementTest.assertNotNull((Object)container1);
        IElementTest.assertNotNull((Object)container2);
        IElementTest.assertNotNull(container3);
        IElementTest.assertEquals((Object)container1, (Object)container2);
        IElementTest.assertEquals((Object)container2, (Object)container3);
        IElementTest.assertEquals((Object)container1, (Object)container3);
    }
}

