/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit.tests;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import junit.framework.Test;
import junit.framework.TestSuite;
import net.sourceforge.jwebunit.tests.JWebUnitAPITestCase;
import net.sourceforge.jwebunit.tests.util.JettySetup;

public class ImageTest
extends JWebUnitAPITestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite(ImageTest.class);
        return new JettySetup((Test)suite);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.setBaseUrl("http://localhost:8082/jwebunit/ImageTest");
        this.beginAt("/PageWithImages.html");
    }

    public void testSimpleImagePresenceAssertion() throws Throwable {
        this.assertImagePresent("images/Image1.gif", "image 1");
        this.assertImagePresent("images/Image2.png", "image 2");
        this.assertImagePresent("images/photos/Image3.jpg", "image 3");
        this.assertImagePresent("somedir/Image4.gif", null);
        this.assertImagePresent("images/InvalidImage.gif", "invalid image");
        this.assertFail("assertImagePresent", new Object[]{"images/Image4.jpg", "image 4"});
        this.assertFail("assertImagePresent", new Object[]{"images/wrongUrl.jpg", "image 3"});
        this.assertFail("assertImagePresent", new Object[]{"images/Image2.png", "wrong alt"});
    }

    public void testGifCanBeLoaded() throws Throwable {
        this.assertPass("assertImageValid", new Object[]{"images/Image1.gif", "image 1"});
    }

    public void testPngCanBeLoaded() throws Throwable {
        this.assertPass("assertImageValid", new Object[]{"images/Image2.png", "image 2"});
    }

    public void testJpgCanBeLoaded() throws Throwable {
        this.assertPass("assertImageValid", new Object[]{"images/photos/Image3.jpg", "image 3"});
    }

    public void testFailsOnInvalidImages() throws Throwable {
        this.assertFail("assertImageValid", new Object[]{"images/InvalidImage.gif", "invalid image"});
    }

    public void testSavesImage() throws Throwable {
        File testOut = File.createTempFile("jwebunit-test-", ".png");
        testOut.deleteOnExit();
        this.assertImageValidAndStore("images/Image2.png", "image 2", testOut);
        BufferedImage testImg = ImageIO.read(testOut);
        ImageTest.assertNotNull((Object)testImg);
    }

    public void testImagesAreExposed() throws Throwable {
        Image image = this.getImage("images/Image1.gif", "image 1");
        ImageTest.assertNotNull((Object)image);
    }

    public void testRelativePathsAreCorrectlyResolved() {
        this.beginAt("/somedir/AnotherPageWithImages.html");
        this.assertImageValid("Image4.gif", "image 4 - same dir");
        this.assertImageValid("images/Image5.png", "image 5 - subdir");
        this.assertImageValid("../images/photos/Image3.jpg", "image 3 again - topdir");
    }
}

