/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit.tests;

import java.lang.reflect.InvocationTargetException;
import junit.framework.AssertionFailedError;
import net.sourceforge.jwebunit.junit.WebTestCase;
import net.sourceforge.jwebunit.junit.WebTester;
import net.sourceforge.jwebunit.tests.util.reflect.MethodInvoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JWebUnitAPITestCase
extends WebTestCase {
    protected static final Object[] NOARGS = new Object[0];
    public static final int JETTY_PORT = 8082;
    public static final String JETTY_URL = "/jwebunit";
    public static final String HOST_PATH = "http://localhost:8082/jwebunit";

    public JWebUnitAPITestCase(String name, WebTester custom) {
        super(name, custom);
    }

    public JWebUnitAPITestCase(String name) {
        super(name);
    }

    public JWebUnitAPITestCase() {
    }

    public void setUp() throws Exception {
        super.setUp();
        this.getTestContext().setBaseUrl(HOST_PATH);
        this.getTestContext().setAuthorization("admin", "admin");
    }

    public void assertPassFail(String methodName, Object passArg, Object failArgs) throws Throwable {
        this.assertPassFail(methodName, new Object[]{passArg}, new Object[]{failArgs});
    }

    public void assertPassFail(String methodName, Object[] passArgs, Object[] failArgs) throws Throwable {
        this.assertPass(methodName, passArgs);
        this.assertFail(methodName, failArgs);
    }

    protected void assertPass(String methodName, Object arg) throws Throwable {
        this.assertPass(methodName, new Object[]{arg});
    }

    protected void assertPass(String methodName, Object[] args) throws Throwable {
        MethodInvoker invoker = new MethodInvoker((Object)this, methodName, args);
        try {
            invoker.invoke();
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public void assertFail(String methodName, Object arg) {
        this.assertFail(methodName, new Object[]{arg});
    }

    public void assertFail(String methodName, Object[] args) {
        this.assertException(AssertionFailedError.class, methodName, args);
    }

    public void assertException(Class<?> exceptionClass, String methodName, Object[] args) {
        MethodInvoker invoker = new MethodInvoker((Object)this, methodName, args);
        try {
            invoker.invoke();
            JWebUnitAPITestCase.fail((String)("Expected test failure did not occur for method: " + methodName));
        }
        catch (InvocationTargetException e) {
            JWebUnitAPITestCase.assertTrue((String)("Expected " + exceptionClass.getName() + "but was " + e.getTargetException().getClass().getName()), (boolean)exceptionClass.isInstance(e.getTargetException()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }
}

