/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import net.sourceforge.jwebunit.tests.JWebUnitAPITestCase;
import net.sourceforge.jwebunit.tests.util.JettySetup;

public class JavaScriptEventsTest
extends JWebUnitAPITestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite(JavaScriptEventsTest.class);
        return new JettySetup((Test)suite);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.setBaseUrl("http://localhost:8082/jwebunit/JavaScriptEventsTest");
    }

    public void testFormOnSubmit() {
        this.beginAt("FormOnSubmit.html");
        this.submit();
        this.gotoWindow("child");
        this.assertTextPresent("on=submit");
    }

    public void testFormOnReset() {
        this.beginAt("FormOnSubmit.html");
        this.reset();
        this.gotoWindow("child");
        this.assertTextPresent("on=reset");
    }

    public void testButtonOnClick() {
        this.beginAt("FormOnSubmit.html");
        this.assertButtonPresent("b1");
        this.clickButton("b1");
        this.gotoWindow("child");
        this.assertTextPresent("on=click");
    }

    public void testJavaScriptInFile() {
        this.beginAt("index.html");
        this.assertTitleEquals("Startpage");
        this.clickButton("next");
        this.assertTextPresent("Here is the text we expect");
    }

    public void testLinkAssertsWorkJavascriptDisabled() {
        this.setScriptingEnabled(false);
        this.beginAt("index.html");
        this.clickLink("linkNext");
        this.assertTitleEquals("Startpage");
        this.assertTextNotPresent("Here is the text we expect");
        this.beginAt("index.html");
        this.clickButton("next");
        this.assertTitleEquals("Startpage");
        this.assertTextNotPresent("Here is the text we expect");
        this.setScriptingEnabled(true);
        this.beginAt("index.html");
        this.clickLink("linkNext");
        this.assertTitleEquals("Next page");
    }

    public void testLinkClickSetsWindowLocation() {
        this.beginAt("index.html");
        this.assertTitleEquals("Startpage");
        this.clickLinkWithText("Next");
        this.assertTitleEquals("Next page");
    }

    public void testOnChangeSetsWindowLocation() throws Exception {
        this.beginAt("onchange.html");
        this.assertTitleEquals("The Title");
        this.selectOption("testSelect", "Value2");
        this.assertTitleEquals("Submitted parameters");
        this.assertTextPresent("testSelect=V2");
    }

    public void testGreenLink() {
        this.beginAt("index.html");
        this.assertTextFieldEquals("color", "blue");
        this.clickLink("SetColorGreen");
        this.assertTextFieldEquals("color", "green");
    }

    public void testFormOnSubmitSetTarget() {
        this.beginAt("FormOnSubmitSetTarget.html");
        this.setWorkingForm("formID");
        this.submit("go");
    }
}

