/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import net.sourceforge.jwebunit.tests.JWebUnitAPITestCase;
import net.sourceforge.jwebunit.tests.util.JettySetup;

public class JavaScriptTest
extends JWebUnitAPITestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite(JavaScriptTest.class);
        return new JettySetup((Test)suite);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.setBaseUrl("http://localhost:8082/jwebunit/JavaScriptTest");
    }

    public void testDocumentWrite() {
        this.beginAt("DocumentWrite.html");
        this.assertTextPresent("Hello World");
    }

    public void testAlert() {
        this.setExpectedJavaScriptAlert("Foo Bar");
        this.beginAt("Alert.html");
    }

    public void testInvalidAlertOnPageLoad() {
        this.setExpectedJavaScriptAlert("invalid");
        try {
            this.beginAt("Alert.html");
            JavaScriptTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testMultipleAlerts() {
        this.setExpectedJavaScriptAlert(new String[]{"Alert 1", "Alert 2"});
        this.beginAt("MultipleAlerts.html");
    }

    public void testConfirm() {
        this.setExpectedJavaScriptConfirm("Foo Bar", true);
        this.beginAt("Confirm.html");
        this.assertLinkPresent("Toto");
        this.assertLinkNotPresent("Titi");
    }

    public void testPrompt() {
        this.setExpectedJavaScriptPrompt("Foo Bar", "toto");
        this.beginAt("Prompt.html");
        this.assertTextPresent("Toto");
    }

    public void testPromptCanceled() {
        this.setExpectedJavaScriptPrompt("Foo Bar", null);
        this.beginAt("Prompt.html");
        this.assertTextPresent("Cancel");
    }

    public void testUserAgent() {
        this.beginAt("userAgent.html");
        this.assertTextPresent("Mozilla");
    }

    public void testPrototypeJs() throws InterruptedException {
        this.beginAt("prototype.html");
        this.clickButtonWithText("do ajax");
        Thread.sleep(500L);
        this.assertTextPresent("hello, world!");
        this.assertTextNotPresent("not loaded");
    }
}

