/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit.tests;

import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestSuite;
import net.sourceforge.jwebunit.exception.TestingEngineResponseException;
import net.sourceforge.jwebunit.tests.JWebUnitAPITestCase;
import net.sourceforge.jwebunit.tests.util.JettySetup;

public class NavigationTest
extends JWebUnitAPITestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite(NavigationTest.class);
        return new JettySetup((Test)suite);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.setBaseUrl("http://localhost:8082/jwebunit/NavigationTest");
    }

    public void testBeginAtRelative() {
        this.beginAt("/blah.html");
    }

    public void testBeginAtAbsolute() {
        this.beginAt("http://localhost:8082/jwebunit/NavigationTest/blah.html");
    }

    public void testForwardSlashConfusion() throws Exception {
        this.beginAt("/blah.html");
        this.beginAt("blah.html");
        this.getTestContext().setBaseUrl("http://localhost:8082/jwebunit/NavigationTest/");
        this.beginAt("/blah.html");
        this.beginAt("blah.html");
    }

    public void testInvalidBeginAt() {
        this.assertException(TestingEngineResponseException.class, "beginAt", new Object[]{"/nosuchresource.html"});
    }

    public void testClickLinkWithText() {
        this.beginAt("/pageWithLink.html");
        this.assertTitleEquals("pageWithLink");
        this.clickLinkWithText("an active link");
        this.assertTitleEquals("targetPage");
    }

    public void testClickLinkWithTextN() {
        this.beginAt("/pageWithLink.html");
        this.assertTitleEquals("pageWithLink");
        this.clickLinkWithText("an active link", 0);
        this.assertTitleEquals("targetPage");
        this.beginAt("/pageWithLink.html");
        this.clickLinkWithText("an active link", 1);
        this.assertTitleEquals("targetPage2");
        this.beginAt("/pageWithLink.html");
        try {
            this.clickLinkWithText("an active link", 2);
            NavigationTest.fail();
        }
        catch (AssertionFailedError expected) {
            NavigationTest.assertEquals((String)"Link with text [an active link] and index [2] not found in response.", (String)expected.getMessage());
        }
        this.assertTitleEquals("pageWithLink");
    }

    public void testClickLinkWithImage() {
        this.beginAt("/pageWithLink.html");
        this.assertTitleEquals("pageWithLink");
        this.clickLinkWithImage("graphic.jpg");
        this.assertTitleEquals("targetPage2");
    }

    public void testClickLinkByID() {
        this.beginAt("/pageWithLink.html");
        this.assertTitleEquals("pageWithLink");
        this.clickLink("activeID");
        this.assertTitleEquals("targetPage");
    }

    public void testInvalidClickLink() {
        this.beginAt("/pageWithLink.html");
        this.assertTitleEquals("pageWithLink");
        try {
            this.clickLinkWithText("no such link");
        }
        catch (Throwable t) {
            return;
        }
        NavigationTest.fail((String)"Expected exception");
    }

    public void testGotoPageRelative() {
        this.beginAt("/targetPage.html");
        this.assertTitleEquals("targetPage");
        this.gotoPage("/targetPage2.html");
        this.assertTitleEquals("targetPage2");
    }

    public void testGotoPageAbsolute() {
        this.beginAt("/targetPage.html");
        this.assertTitleEquals("targetPage");
        this.gotoPage("http://localhost:8082/jwebunit/NavigationTest/targetPage2.html");
        this.assertTitleEquals("targetPage2");
    }

    public void testLinkWithEscapedText() {
        this.beginAt("/pageWithAmpersandInLink.html");
        this.assertLinkPresentWithText("Map & Directions");
        this.clickLinkWithText("Map & Directions");
        this.assertTitleEquals("targetPage");
    }

    public void testLinkExactText() {
        this.beginAt("/test1.html");
        this.assertTitleEquals("test1");
        this.assertLinkPresentWithExactText("one");
        this.assertLinkPresentWithExactText("tone");
        this.clickLinkWithExactText("one");
        this.assertTitleEquals("test2");
        boolean passed = false;
        try {
            this.clickLinkWithExactText("doesn't exist");
        }
        catch (AssertionFailedError e) {
            passed = true;
        }
        NavigationTest.assertTrue((String)"non-existant link should throw an error", (boolean)passed);
    }
}

