/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit.tests;

import java.text.NumberFormat;
import java.util.Locale;
import junit.framework.Test;
import junit.framework.TestSuite;
import net.sourceforge.jwebunit.tests.JWebUnitAPITestCase;
import net.sourceforge.jwebunit.tests.util.JettySetup;

public class ResourceBundleAssertionsTest
extends JWebUnitAPITestCase {
    static final String resourceBundleName = "MessageBundle";
    static final String pageTitle = "Keyed Message Title - Main Page";
    static final String text = "This is a test page.";

    public static Test suite() {
        TestSuite suite = new TestSuite(ResourceBundleAssertionsTest.class);
        return new JettySetup((Test)suite);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.setBaseUrl("http://localhost:8082/jwebunit/ResourceBundleAssertionsTest");
        this.getTestContext().setResourceBundleName(resourceBundleName);
        this.beginAt("/testPage.html");
    }

    public void testGetMessage() {
        ResourceBundleAssertionsTest.assertEquals((String)pageTitle, (String)this.getMessage("title.fixed"));
    }

    public void testGetMessageWithArg() {
        ResourceBundleAssertionsTest.assertEquals((String)pageTitle, (String)this.getMessage("title.with.args", new String[]{"Main Page"}));
    }

    public void testGetFormattedMessage() {
        Double amount = new Double(1234.56);
        NumberFormat numberFormat = NumberFormat.getCurrencyInstance(Locale.getDefault());
        String expectedValue = numberFormat.format(amount);
        ResourceBundleAssertionsTest.assertEquals((String)expectedValue, (String)this.tester.getMessage("currency.with.args", new Object[]{amount}));
    }

    public void testGetLocalizedFormattedMessage() {
        Double amount = new Double(1234.56);
        NumberFormat numberFormat = NumberFormat.getCurrencyInstance(Locale.FRANCE);
        String expectedValue = numberFormat.format(amount);
        this.getTestContext().setLocale(Locale.FRANCE);
        ResourceBundleAssertionsTest.assertEquals((String)expectedValue, (String)this.tester.getMessage("currency.with.args", new Object[]{amount}));
    }

    public void testAssertTitleEqualsKey() throws Throwable {
        this.assertPassFail("assertTitleEqualsKey", "title.fixed", "title.not.used");
    }

    public void testAssertTitleEqualsKeyWithArg() throws Throwable {
        this.assertPassFail("assertTitleEqualsKey", new Object[]{"title.with.args", new Object[]{"Main Page"}}, new Object[]{"title.with.args", new Object[]{"Wrong"}});
    }

    public void testAssertKeyPresent() throws Throwable {
        this.assertPassFail("assertKeyPresent", "text.fixed", "title.not.used");
    }

    public void testAssertKeyPresentWithArg() throws Throwable {
        this.assertPassFail("assertKeyPresent", new Object[]{"text.with.args", new Object[]{"test"}}, new Object[]{"text.with.args", new Object[]{"wrong"}});
    }

    public void testAssertTextNotPresent() throws Throwable {
        this.assertPassFail("assertTextNotPresent", "no such text", text);
    }

    public void testAssertNotKeyPresent() throws Throwable {
        this.assertPassFail("assertKeyNotPresent", "title.not.used", "text.fixed");
    }

    public void testAssertKeyNotPresentWithArg() throws Throwable {
        this.assertPassFail("assertKeyNotPresent", new Object[]{"text.with.args", new Object[]{"wrong"}}, new Object[]{"text.with.args", new Object[]{"test"}});
    }

    public void testAssertKeyInTable() throws Throwable {
        this.assertPassFail("assertKeyInTable", new Object[]{"testTable", "table.fixed"}, new Object[]{"testTable", "title.not.used"});
    }

    public void testAssertKeyInTableWithArgs() throws Throwable {
        this.assertPassFail("assertKeyInTable", new Object[]{"testTable", "table.with.args", new Object[]{"Data", "Table"}}, new Object[]{"testTable", "table.with.args", new Object[]{"wrong"}});
    }

    public void testAssertKeyNotInTable() throws Throwable {
        this.assertPassFail("assertKeyNotInTable", new Object[]{"testTable", "title.not.used"}, new Object[]{"testTable", "table.fixed"});
    }

    public void testAssertKeysInTable() throws Throwable {
        this.assertPassFail("assertKeysInTable", new Object[]{"testTable", new String[]{"table.fixed", "table2.fixed"}}, new Object[]{"testTable", new String[]{"table.fixed", "title.not.used"}});
    }

    public void testAssertKeysInTableWithArgs() throws Throwable {
        this.assertPassFail("assertKeysInTable", new Object[]{"testTable", new String[]{"table.with.args", "table2.with.args"}, new Object[][]{{"Data", "Table"}, {"Data", "In"}}}, new Object[]{"testTable", new String[]{"table.with.args", "table2.with.args"}, new Object[][]{{"Wrong"}, {"Wrong"}}});
    }
}

