/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit.tests;

import java.net.SocketTimeoutException;
import junit.framework.Test;
import junit.framework.TestSuite;
import net.sourceforge.jwebunit.tests.JWebUnitAPITestCase;
import net.sourceforge.jwebunit.tests.util.JettySetup;

public class ResponseServletTest
extends JWebUnitAPITestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite(ResponseServletTest.class);
        return new JettySetup((Test)suite);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.setIgnoreFailingStatusCodes(true);
        this.setBaseUrl("http://localhost:8082/jwebunit/ResponseServletTest");
    }

    public void testDefault() {
        this.beginAt("/SimpleForm.html");
        this.submit();
        this.assertResponseCodeBetween(200, 299);
        this.assertHeaderPresent("Test");
        this.assertHeaderNotPresent("Not-present");
        this.assertHeaderEquals("Test", "test2");
        this.assertHeaderMatches("Header-Added", "[0-9]{2}");
    }

    public void testResponse200() {
        this.beginAt("/SimpleForm.html");
        this.setTextField("status", "200");
        this.submit();
        this.assertResponseCode(200);
    }

    public void testResponse404() {
        this.beginAt("/SimpleForm.html");
        this.assertTitleEquals("response form");
        this.setTextField("status", "404");
        this.submit();
        this.assertResponseCode(404);
    }

    public void testResponse501() {
        this.beginAt("/SimpleForm.html");
        this.assertTitleEquals("response form");
        this.setTextField("status", "501");
        this.submit();
        this.assertResponseCode(501);
    }

    public void testTimeout() {
        this.setTimeout(500);
        this.beginAt("/SimpleForm.html");
        this.assertTitleEquals("response form");
        this.setTextField("timeout", "1");
        try {
            this.submit();
            ResponseServletTest.fail((String)"timeout was not called");
        }
        catch (RuntimeException e) {
            ResponseServletTest.assertTrue((String)("timeout caused by SocketTimeoutException, but was " + e.getCause().getClass()), (boolean)(e.getCause() instanceof SocketTimeoutException));
        }
        this.closeBrowser();
        this.setTimeout(2000);
        this.beginAt("/SimpleForm.html");
        this.assertTitleEquals("response form");
        this.setTextField("timeout", "1");
        this.submit();
        this.assertTextPresent("hello, world!");
    }
}

