/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit.tests;

import net.sourceforge.jwebunit.tests.JWebUnitAPITestCase;

public class SelectOptionsTest
extends JWebUnitAPITestCase {
    public void setUp() throws Exception {
        super.setUp();
        this.setBaseUrl("http://localhost:8082/jwebunit/SelectOptionsTest");
    }

    public void testAssertSelectOptionsOneForm() {
        this.beginAt("/pageWithOneForm.html");
        this.assertSelectOptionsForm1();
        this.setWorkingForm("form1");
        this.assertSelectOptionsForm1();
        this.beginAt("/pageWithOneFormMulti.html");
        this.assertSelectOptionsForm1();
        this.setWorkingForm("form1");
        this.assertSelectOptionsForm1();
    }

    public void testAssertSelectOptionsTwoForms() {
        this.beginAt("/pageWithTwoForms.html");
        this.setWorkingForm("form1");
        this.assertSelectOptionsForm1();
        this.setWorkingForm("form2");
        this.assertSelectOptionsForm2();
        this.beginAt("/pageWithTwoFormsMulti.html");
        this.setWorkingForm("form1");
        this.assertSelectOptionsForm1();
        this.setWorkingForm("form2");
        this.assertSelectOptionsForm2();
    }

    public void testSelectOptionsOneForm() {
        this.beginAt("/pageWithOneForm.html");
        this.selectOption("singleSelect", "Option 2");
        this.assertSelectedOptionEquals("singleSelect", "Option 2");
        this.selectOption("duplicateSelect", "Option 2");
        this.assertSelectedOptionEquals("duplicateSelect", "Option 2");
        this.selectOption("duplicateSelect", 0, "Option 3");
        this.assertSelectedOptionEquals("duplicateSelect", 0, "Option 3");
        this.selectOption("duplicateSelect", 1, "Option B");
        this.assertSelectedOptionEquals("duplicateSelect", 1, "Option B");
        this.beginAt("/pageWithOneFormMulti.html");
        this.selectOption("singleSelect", "Option 2");
        this.assertSelectedOptionEquals("singleSelect", "Option 2");
        this.selectOption("duplicateSelect", "Option 2");
        this.assertSelectedOptionEquals("duplicateSelect", "Option 2");
        this.beginAt("/pageWithOneFormMulti.html");
        this.selectOption("duplicateSelect", 0, "Option 3");
        this.assertSelectedOptionEquals("duplicateSelect", 0, "Option 3");
        this.selectOption("duplicateSelect", 1, "Option B");
        this.assertSelectedOptionEquals("duplicateSelect", 1, "Option B");
        this.beginAt("/pageWithOneFormMulti.html");
        this.selectOptions("singleSelect", new String[]{"Option 3", "Option 4"});
        this.assertSelectedOptionsEqual("singleSelect", new String[]{"Option 3", "Option 4"});
        this.selectOptions("duplicateSelect", new String[]{"Option 1", "Option 4"});
        this.assertSelectedOptionsEqual("duplicateSelect", new String[]{"Option 1", "Option 4"});
        this.beginAt("/pageWithOneFormMulti.html");
        this.selectOptions("duplicateSelect", 0, new String[]{"Option 2", "Option 4"});
        this.assertSelectedOptionsEqual("duplicateSelect", 0, new String[]{"Option 2", "Option 4"});
        this.selectOptions("duplicateSelect", 1, new String[]{"Option C", "Option B"});
        this.assertSelectedOptionsEqual("duplicateSelect", 1, new String[]{"Option B", "Option C"});
        this.beginAt("/pageWithOneForm.html");
        this.selectOptionByValue("singleSelect", "option2");
        this.assertSelectedOptionValueEquals("singleSelect", "option2");
        this.selectOptionByValue("duplicateSelect", "option2");
        this.assertSelectedOptionValueEquals("duplicateSelect", "option2");
        this.selectOptionByValue("duplicateSelect", 0, "option3");
        this.assertSelectedOptionValueEquals("duplicateSelect", 0, "option3");
        this.selectOptionByValue("duplicateSelect", 1, "optionB");
        this.assertSelectedOptionValueEquals("duplicateSelect", 1, "optionB");
        this.beginAt("/pageWithOneFormMulti.html");
        this.selectOptionByValue("singleSelect", "option2");
        this.assertSelectedOptionValueEquals("singleSelect", "option2");
        this.assertSelectedOptionMatches("singleSelect", "option2");
        this.selectOptionByValue("duplicateSelect", "option2");
        this.assertSelectedOptionValueEquals("duplicateSelect", "option2");
        this.beginAt("/pageWithOneFormMulti.html");
        this.selectOptionByValue("duplicateSelect", 0, "option3");
        this.assertSelectedOptionValueEquals("duplicateSelect", 0, "option3");
        this.assertSelectedOptionMatches("duplicateSelect", 0, "option3");
        this.selectOptionByValue("duplicateSelect", 1, "optionB");
        this.assertSelectedOptionValueEquals("duplicateSelect", 1, "optionB");
        this.beginAt("/pageWithOneFormMulti.html");
        this.selectOptionsByValues("singleSelect", new String[]{"option3", "option4"});
        this.assertSelectedOptionValuesEqual("singleSelect", new String[]{"option3", "option4"});
        this.assertSelectedOptionsMatch("singleSelect", new String[]{"option3", "option4"});
        this.selectOptionsByValues("duplicateSelect", new String[]{"option1", "option4"});
        this.assertSelectedOptionValuesEqual("duplicateSelect", new String[]{"option1", "option4"});
        this.beginAt("/pageWithOneFormMulti.html");
        this.selectOptionsByValues("duplicateSelect", 0, new String[]{"option2", "option4"});
        this.assertSelectedOptionValuesEqual("duplicateSelect", 0, new String[]{"option2", "option4"});
        this.assertSelectedOptionsMatch("duplicateSelect", 0, new String[]{"option2", "option4"});
        this.selectOptions("duplicateSelect", 1, new String[]{"Option C", "Option B"});
        this.assertSelectedOptionValuesEqual("duplicateSelect", 1, new String[]{"optionB", "optionC"});
        this.assertSelectedOptionsMatch("duplicateSelect", 0, new String[]{"option2", "option4"});
    }

    private void assertSelectOptions(String selectName, String[] validOptions, String invalidOption, String[] validOptionValues, String invalidOptionValue) {
        int i;
        for (i = 0; i < validOptions.length; ++i) {
            this.assertSelectOptionPresent(selectName, validOptions[i]);
        }
        this.assertSelectOptionsPresent(selectName, validOptions);
        this.assertSelectOptionsEqual(selectName, validOptions);
        for (i = 0; i < validOptionValues.length; ++i) {
            this.assertSelectOptionValuePresent(selectName, validOptionValues[i]);
        }
        this.assertSelectOptionValuesPresent(selectName, validOptionValues);
        this.assertSelectOptionValuesEqual(selectName, validOptionValues);
        this.assertSelectOptionNotPresent(selectName, invalidOption);
        this.assertSelectOptionsNotEqual(selectName, new String[]{invalidOption});
        this.assertSelectOptionValueNotPresent(selectName, invalidOptionValue);
        this.assertSelectOptionValuesNotEqual(selectName, new String[]{invalidOptionValue});
    }

    private void assertSelectOptions(String selectName, int index, String[] validOptions, String invalidOption, String[] validOptionValues, String invalidOptionValue) {
        int i;
        for (i = 0; i < validOptions.length; ++i) {
            this.assertSelectOptionPresent(selectName, index, validOptions[i]);
        }
        this.assertSelectOptionsPresent(selectName, index, validOptions);
        this.assertSelectOptionsEqual(selectName, index, validOptions);
        for (i = 0; i < validOptionValues.length; ++i) {
            this.assertSelectOptionValuePresent(selectName, index, validOptionValues[i]);
        }
        this.assertSelectOptionValuesPresent(selectName, index, validOptionValues);
        this.assertSelectOptionValuesEqual(selectName, index, validOptionValues);
        this.assertSelectOptionNotPresent(selectName, index, invalidOption);
        this.assertSelectOptionsNotEqual(selectName, index, new String[]{invalidOption});
        this.assertSelectOptionValueNotPresent(selectName, index, invalidOptionValue);
        this.assertSelectOptionValuesNotEqual(selectName, index, new String[]{invalidOptionValue});
    }

    private void assertSelectOptionsForm1() {
        this.assertSelectOptions("singleSelect", new String[]{"Option 1", "Option 2", "Option 3", "Option 4"}, "badoption", new String[]{"option1", "option2", "option3", "option4"}, "badoption");
        this.assertSelectOptions("singleSelect", 0, new String[]{"Option 1", "Option 2", "Option 3", "Option 4"}, "badoption", new String[]{"option1", "option2", "option3", "option4"}, "badoption");
        this.assertSelectOptions("duplicateSelect", new String[]{"Option 1", "Option 2", "Option 3", "Option 4"}, "badoption", new String[]{"option1", "option2", "option3", "option4"}, "badoption");
        this.assertSelectOptions("duplicateSelect", 0, new String[]{"Option 1", "Option 2", "Option 3", "Option 4"}, "badoption", new String[]{"option1", "option2", "option3", "option4"}, "badoption");
        this.assertSelectOptions("duplicateSelect", 1, new String[]{"Option A", "Option B", "Option C", "Option D"}, "badoption", new String[]{"optionA", "optionB", "optionC", "optionD"}, "badoption");
    }

    private void assertSelectOptionsForm2() {
        this.assertSelectOptions("singleSelectA", new String[]{"Option 1a", "Option 2a", "Option 3a", "Option 4a"}, "badoption", new String[]{"option1a", "option2a", "option3a", "option4a"}, "badoption");
        this.assertSelectOptions("singleSelectA", 0, new String[]{"Option 1a", "Option 2a", "Option 3a", "Option 4a"}, "badoption", new String[]{"option1a", "option2a", "option3a", "option4a"}, "badoption");
        this.assertSelectOptions("duplicateSelectA", new String[]{"Option 1a", "Option 2a", "Option 3a", "Option 4a"}, "badoption", new String[]{"option1a", "option2a", "option3a", "option4a"}, "badoption");
        this.assertSelectOptions("duplicateSelectA", 0, new String[]{"Option 1a", "Option 2a", "Option 3a", "Option 4a"}, "badoption", new String[]{"option1a", "option2a", "option3a", "option4a"}, "badoption");
        this.assertSelectOptions("duplicateSelectA", 1, new String[]{"Option Aa", "Option Ba", "Option Ca", "Option Da"}, "badoption", new String[]{"optionAa", "optionBa", "optionCa", "optionDa"}, "badoption");
    }
}

