/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import net.sourceforge.jwebunit.tests.JWebUnitAPITestCase;
import net.sourceforge.jwebunit.tests.util.JettySetup;

public class TableAssertionsTest
extends JWebUnitAPITestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite(TableAssertionsTest.class);
        return new JettySetup((Test)suite);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.setBaseUrl("http://localhost:8082/jwebunit/TableAssertionsTest");
        this.beginAt("/TableAssertionsTestPage.html");
    }

    public void testAssertTablePresent() throws Throwable {
        this.assertPassFail("assertTablePresent", "testTable", "noTable");
    }

    public void testAssertTableNotPresent() throws Throwable {
        this.assertPassFail("assertTableNotPresent", "noTable", "testTable");
    }

    public void testAssertTextInTable() throws Throwable {
        this.assertPassFail("assertTextInTable", new Object[]{"testTable", "table text"}, new Object[]{"testTable", "no such text"});
    }

    public void testAssertTextNotInTable() throws Throwable {
        this.assertPassFail("assertTextNotInTable", new Object[]{"testTable", "no such text"}, new Object[]{"testTable", "table text"});
    }

    public void testAssertTextArrayInTable() throws Throwable {
        this.assertPassFail("assertTextInTable", new Object[]{"testTable", new String[]{"table text", "table text row 2"}}, new Object[]{"testTable", new String[]{"table text", "no such row 2"}});
    }

    public void testAssertTextArrayNotInTable() throws Throwable {
        this.assertPassFail("assertTextNotInTable", new Object[]{"testTable", new String[]{"no such row 1", "no such row 2"}}, new Object[]{"testTable", new String[]{"no such row 1", "table text row 2"}});
    }

    public void testAssertMatchInTable() throws Throwable {
        this.assertPassFail("assertMatchInTable", new Object[]{"testTable", "table [Tt]ext"}, new Object[]{"testTable", "no.*text"});
    }

    public void testAssertNoMatchInTable() throws Throwable {
        this.assertPassFail("assertNoMatchInTable", new Object[]{"testTable", "no.*text"}, new Object[]{"testTable", "table [Tt]ext"});
    }

    public void testAssertMatchArrayInTable() throws Throwable {
        this.assertPassFail("assertMatchInTable", new Object[]{"testTable", new String[]{"table [Tt]ext", "table [Tt]ext row 2"}}, new Object[]{"testTable", new String[]{"table [Tt]ext", "no.*row 2"}});
    }

    public void testAssertNoMatchArrayInTable() throws Throwable {
        this.assertPassFail("assertNoMatchInTable", new Object[]{"testTable", new String[]{"no.*row 1", "no.*row 2"}}, new Object[]{"testTable", new String[]{"no.*row 1", "table [Tt]ext row 2"}});
    }

    public void testAssertTableEquals() throws Throwable {
        this.assertPass("assertTableEquals", new Object[]{"testTable", new String[][]{{"table text"}, {"table text row 2"}, {"table text row 3", "row 3 col 1"}}});
    }

    public void testAssertTableRowCountEquals() throws Throwable {
        this.assertPassFail("assertTableRowCountEquals", new Object[]{"tree", new Integer(3)}, new Object[]{"tree", 4});
    }

    public void testAssertTableEqualsExtraColumn() throws Throwable {
        this.assertFail("assertTableEquals", new Object[]{"testTable", new String[][]{{"table text", "extra column"}, {"table text row 2"}, {"table text row 3", "row 3 col 1"}}});
    }

    public void testAssertTableEqualsExtraRow() throws Throwable {
        this.assertFail("assertTableEquals", new Object[]{"testTable", new String[][]{{"table text"}, {"table text row 2"}, {"table text row 3", "row 3 col 1"}, {"no row 4"}}});
    }

    public void testAssertTableEqualsInvalidColumnText() throws Throwable {
        this.assertFail("assertTableEquals", new Object[]{"testTable", new String[][]{{"table text"}, {"no such text in row 2"}, {"table text row 3", "row 3 col 1"}}});
    }

    public void testAssertTableEqualsMissingText() throws Throwable {
        this.assertFail("assertTableEquals", new Object[]{"testTable", new String[][]{{"table text"}, {"table text row 2"}, {"table text row 3", ""}}});
    }

    public void testAssertTableRowsEquals() throws Throwable {
        this.assertPass("assertTableRowsEqual", new Object[]{"testTable", 1, new String[][]{{"table text row 2"}, {"table text row 3", "row 3 col 1"}}});
    }

    public void testAssertTableRowsEqualsTooManyExpected() throws Throwable {
        this.assertFail("assertTableRowsEqual", new Object[]{"testTable", 2, new String[][]{{"table text row 3", "row 3 col 1"}, {"unexpected"}}});
    }

    public void testTableWithSpaces() throws Throwable {
        this.assertTablePresent("tree");
        String[][] table = new String[][]{{"root", " ", ""}, {"child1 ;semicolon", " ", "child2", " "}, {"child1.1", "", "child2.1", "child2.2"}};
        this.assertTableEquals("tree", table);
    }

    public void testAssertTableMatch() throws Throwable {
        this.assertPass("assertTableMatch", new Object[]{"testTable", new String[][]{{"table [Tt]ext"}, {"table [Tt]ext row 2"}, {"table [Tt]ext row 3", "row [0-9] col 1"}}});
    }

    public void testAssertTableMatchExtraColumn() throws Throwable {
        this.assertFail("assertTableMatch", new Object[]{"testTable", new String[][]{{"table text", "", "extra column"}, {"table text row 2", ""}, {"table text row 3", "row 3 col 1"}}});
    }

    public void testAssertTableMatchExtraRow() throws Throwable {
        this.assertFail("assertTableMatch", new Object[]{"testTable", new String[][]{{"table text", ""}, {"table text row 2", ""}, {"table text row 3", "row 3 col 1"}, {"no row 4"}}});
    }

    public void testAssertTableMatchInvalidColumnText() throws Throwable {
        this.assertFail("assertTableMatch", new Object[]{"testTable", new String[][]{{"table [Tt]ext", ""}, {"no such [Tt]ext in row 2", ""}, {"table text row 3", "row 3 col 1"}}});
    }

    public void testAssertTableMatchMissingText() throws Throwable {
        this.assertFail("assertTableMatch", new Object[]{"testTable", new String[][]{{"table text", ""}, {"table text row 2", ""}, {"table text row 3", "^$"}}});
    }

    public void testAssertTableRowsMatch() throws Throwable {
        this.assertPass("assertTableRowsMatch", new Object[]{"testTable", 1, new String[][]{{"table text row 2"}, {"table text row 3", "row 3 col 1"}}});
    }

    public void testAssertTableRowsMatchTooManyExpected() throws Throwable {
        this.assertFail("assertTableRowsMatch", new Object[]{"testTable", 2, new String[][]{{"table text row 3", "row 3 col 1"}, {"unexpected", ""}}});
    }

    public void testTableWithSpacesMatch() throws Throwable {
        this.assertTablePresent("tree");
        String[][] table = new String[][]{{"root", "", ""}, {"child1 ;semicolon", "", "child2", ""}, {"child1.1", "", "child2.1", "child2.2"}};
        this.assertTableMatch("tree", table);
    }
}

