/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit.tests;

import java.util.List;
import java.util.Locale;
import javax.servlet.http.Cookie;
import net.sourceforge.jwebunit.tests.JWebUnitAPITestCase;
import net.sourceforge.jwebunit.util.TestContext;

public class TestContextTest
extends JWebUnitAPITestCase {
    private TestContext context;

    public TestContextTest(String s) {
        super(s);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.context = new TestContext();
        this.context.setAuthorization("user", "pwd");
        this.context.addCookie("key", "val", "www.foo.bar");
        this.context.setLocale(Locale.CANADA_FRENCH);
    }

    public void testInit() {
        TestContextTest.assertTrue((boolean)this.context.hasAuthorization());
        TestContextTest.assertTrue((boolean)this.context.hasCookies());
        TestContextTest.assertEquals((String)this.context.getUser(), (String)"user");
        TestContextTest.assertEquals((String)this.context.getPassword(), (String)"pwd");
        List cookies = this.context.getCookies();
        Cookie c = (Cookie)cookies.get(0);
        TestContextTest.assertEquals((String)c.getName(), (String)"key");
        TestContextTest.assertEquals((String)c.getValue(), (String)"val");
        TestContextTest.assertEquals((String)c.getDomain(), (String)"www.foo.bar");
        TestContextTest.assertEquals((Object)Locale.CANADA_FRENCH, (Object)this.context.getLocale());
        TestContextTest.assertEquals((String)"http://localhost:8080", (String)this.context.getBaseUrl().toString());
        TestContextTest.assertNull((Object)this.context.getResourceBundleName());
    }

    public void testResourceBundle() {
        String name = "/TestContextBundle";
        this.context.setResourceBundleName("/TestContextBundle");
        TestContextTest.assertEquals((String)name, (String)this.context.getResourceBundleName());
    }

    public void testUserAgent() {
        this.getTestContext().setBaseUrl("http://localhost:8082/jwebunit/TestContextTest");
        String userAgent = "Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.0.3) Gecko/20060426 Firefox/1.5.0.3";
        this.getTestContext().setUserAgent(userAgent);
        this.beginAt("/testPage.html");
        this.assertTextPresent("Browser user-agent: " + userAgent);
    }
}

