/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit.tests;

import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestSuite;
import net.sourceforge.jwebunit.tests.JWebUnitAPITestCase;
import net.sourceforge.jwebunit.tests.util.JettySetup;

public class WebAssertionsTest
extends JWebUnitAPITestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite(WebAssertionsTest.class);
        return new JettySetup((Test)suite);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.setBaseUrl("http://localhost:8082/jwebunit/WebAssertionsTest");
        this.beginAt("/testPage.html");
    }

    public void testAssertTitleEquals() throws Throwable {
        this.assertPass("assertTitleEquals", new String[]{"testPage"});
        this.assertFail("assertTitleEquals", "wrong title");
    }

    public void testAssertTitleMatch() throws Throwable {
        this.assertPass("assertTitleMatch", new String[]{"test[Pp]age"});
        this.assertFail("assertTitleMatch", "[Ww]rong title");
    }

    public void testAssertTextPresent() throws Throwable {
        this.assertPassFail("assertTextPresent", "This is a test.", "no such text");
    }

    public void testAssertMatch() throws Throwable {
        this.assertPassFail("assertMatch", "This (is)* a .* test.", "no.*text");
    }

    public void testAssertTextNotPresent() throws Throwable {
        this.assertTextNotPresent("no such text");
    }

    public void testAssertNoMatch() throws Throwable {
        this.assertNoMatch("no.*text");
    }

    public void testAssertNoMatchFails() throws Throwable {
        boolean failed = false;
        try {
            this.assertNoMatch("Span Text");
            failed = true;
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
        WebAssertionsTest.assertFalse((String)"assertNoMatch() did not throw expected failure", (boolean)failed);
    }

    public void testAssertLinkPresentWithText() throws Throwable {
        this.assertPassFail("assertLinkPresentWithText", "test link", "no such link");
    }

    public void testAssertLinkNotPresentWithText() throws Throwable {
        this.assertPassFail("assertLinkNotPresentWithText", "no such link", "test link");
    }

    public void testAssertLinkPresentWithTextN() throws Throwable {
        this.assertPass("assertLinkPresentWithText", new Object[]{"test link", 0});
        this.assertFail("assertLinkPresentWithText", new Object[]{"test link", 1});
    }

    public void testAssertLinkNotPresentWithTextN() throws Throwable {
        this.assertPass("assertLinkNotPresentWithText", new Object[]{"test link", new Integer(1)});
        this.assertFail("assertLinkNotPresentWithText", new Object[]{"test link", 0});
    }

    public void testAssertLinkPresent() throws Throwable {
        this.assertPassFail("assertLinkPresent", "test_link_id", "no_link_id");
    }

    public void testAssertLinkNotPresent() throws Throwable {
        this.assertPassFail("assertLinkNotPresent", "no_link_id", "test_link_id");
    }

    public void testAssertLinkPresentWithImage() throws Throwable {
        this.assertPassFail("assertLinkPresentWithImage", "graphic.jpg", "nosuchgraphic.jsp");
    }

    public void testAssertLinkNotPresentWithImage() throws Throwable {
        this.assertPassFail("assertLinkNotPresentWithImage", "nosuchgraphic.jpg", "graphic.jpg");
    }

    public void testAssertElementPresent() throws Throwable {
        this.assertElementPresent("row1");
        this.assertPassFail("assertElementPresent", "span_id", "no_id");
    }

    public void testAssertElementNotPresent() throws Throwable {
        this.assertPassFail("assertElementNotPresent", "no_id", "span_id");
    }

    public void testAssertTextNotInElement() throws Throwable {
        this.assertTextNotInElement("outer_id", "nosuchtext");
        this.assertTextNotInElement("inner_id", "Outer");
        this.assertFail("assertTextNotInElement", new Object[]{"outer_id", "Outer"});
    }

    public void testAssertElementContainsText() throws Throwable {
        this.assertTextInElement("span_id", "Span");
        this.assertTextInElement("span_id", "Text");
        this.assertTextInElement("span_id", "Span Text");
        this.assertTextInElement("span_empty", "");
        this.assertFail("assertTextInElement", new Object[]{"span_id", "Not Text"});
    }

    public void testAssertElementContainsTextInChild() throws Throwable {
        this.assertTextInElement("outer_id", "Outer");
        this.assertTextInElement("outer_id", "Text");
        this.assertTextInElement("outer_id", "Inner Text");
        this.assertTextInElement("outer2", "$100,000/$300,000");
    }

    public void testAssertNoMatchInElement() throws Throwable {
        this.assertNoMatchInElement("outer_id", "no[Ss]uchtext");
        this.assertNoMatchInElement("inner_id", "Out+er");
        this.assertFail("assertNoMatchInElement", new Object[]{"outer_id", "Out+er"});
    }

    public void testAssertMatchInElement() throws Throwable {
        this.assertMatchInElement("span_id", "Sp[Aa]n");
        this.assertMatchInElement("span_id", "Te+xt");
        this.assertMatchInElement("span_id", "Span\\sText");
        this.assertFail("assertMatchInElement", new Object[]{"span_id", "Not.*Text"});
    }

    public void testAssertMatchInElementChild() throws Throwable {
        this.assertMatchInElement("outer_id", "Out+er");
        this.assertMatchInElement("outer_id", "Texx*t");
        this.assertMatchInElement("outer_id", "Inner.*Text");
    }

    public void testAssertFormElementEquals() throws Throwable {
        this.assertFormElementEquals("testInputElement", "testValue");
        this.assertFail("assertFormElementEquals", new Object[]{"testInputElement", "AnotherValue"});
    }

    public void testAssertTextFieldEquals() throws Throwable {
        this.assertTextFieldEquals("testInputElement", "testValue");
        this.assertFail("assertTextFieldEquals", new Object[]{"testInputElement", "AnotherValue"});
    }

    public void testAssertHiddenFieldPresent() throws Throwable {
        this.assertHiddenFieldPresent("hidden", "h");
        this.assertFail("assertHiddenFieldPresent", new Object[]{"hidden", "AnotherValue"});
    }

    public void testAssertFormElementMatch() throws Throwable {
        this.assertFormElementMatch("testInputElement", "test[Vv]alue");
        this.assertFail("assertFormElementMatch", new Object[]{"testInputElement", "Another[Vv]alue"});
    }

    public void testAssertSelectedOptionEquals() throws Throwable {
        this.assertSelectedOptionEquals("testSelect", "Value1");
        this.assertFail("assertSelectedOptionEquals", new Object[]{"testSelect", "AnotherValue"});
    }

    public void testAssertSelectedOptionMatch() throws Throwable {
        this.assertSelectedOptionMatches("testSelect", "[Vv]alue1");
        this.assertFail("assertSelectedOptionMatches", new Object[]{"testSelect", "Another[Vv]alue"});
    }
}

