/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import net.sourceforge.jwebunit.tests.JWebUnitAPITestCase;
import net.sourceforge.jwebunit.tests.util.JettySetup;

public class WebCookieTest
extends JWebUnitAPITestCase {
    public static Test suite() {
        return new JettySetup((Test)new TestSuite(WebCookieTest.class));
    }

    public void setUp() throws Exception {
        super.setUp();
        this.getTestContext().addCookie("cookie1", "Cookievalue1", "localhost");
        this.setBaseUrl("http://localhost:8082/jwebunit");
    }

    public void testAddCookie() {
        this.beginAt("/cookies.jsp");
        this.assertTextPresent("cookie1=Cookievalue1");
    }

    public void testAddAnotherCookie() {
        this.getTestContext().addCookie("cookie2", "Cookievalue2", "localhost");
        this.beginAt("/cookies.jsp");
        this.assertTextPresent("cookie1=Cookievalue1");
        this.assertTextPresent("cookie2=Cookievalue2");
    }

    public void testAssertCookiePresent() throws Throwable {
        this.beginAt("/cookies.jsp");
        this.assertCookiePresent("serveurCookie");
    }

    public void testAssertCookieValue() throws Throwable {
        this.beginAt("/cookies.jsp");
        this.assertCookieValueEquals("serveurCookie", "foo");
    }

    public void testAssertCookieMatch() throws Throwable {
        this.beginAt("/cookies.jsp");
        this.assertCookieValueMatch("serveurCookie", "fo*");
    }

    public void testCookieWithoutExplicitSet() {
        this.beginAt("/cookies.jsp");
        this.assertCookieValueEquals("serveurCookie", "foo");
        this.gotoPage("/cookies.jsp?dont_set=1");
        this.assertCookieValueEquals("serveurCookie", "foo");
        this.gotoPage("/cookies.jsp?dont_set=1");
        this.assertCookieValueEquals("serveurCookie", "foo");
        this.gotoPage("/cookies.jsp?dont_set=1");
        this.assertCookieValueEquals("serveurCookie", "foo");
    }
}

