/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jwebunit.tests;

import junit.framework.Test;
import junit.framework.TestSuite;
import net.sourceforge.jwebunit.tests.JWebUnitAPITestCase;
import net.sourceforge.jwebunit.tests.util.JettySetup;

public class XPathTest
extends JWebUnitAPITestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite(XPathTest.class);
        return new JettySetup((Test)suite);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.setBaseUrl("http://localhost:8082/jwebunit/XPathTest");
    }

    public void testAssertElementPresentByXPath() throws Throwable {
        this.beginAt("/testPage.html");
        this.assertPassFail("assertElementPresentByXPath", "//tr[contains(.//a/@href,\"next\") and contains(string(),\"test link\")]", "//InvalidXPath");
    }

    public void testAssertElementNotPresentByXPath() throws Throwable {
        this.beginAt("/testPage.html");
        this.assertPassFail("assertElementNotPresentByXPath", "//InvalidXPath", "//tr[contains(.//a/@href,\"next\") and contains(string(),\"test link\")]");
    }

    public void testClickElementByXPath() throws Throwable {
        this.beginAt("/testPage.html");
        this.clickElementByXPath("//tr//a[contains(@href,\"next\") and contains(string(),\"test link\")]");
        this.assertTitleEquals("Next");
    }

    public void testGetElementTextByXPath() throws Throwable {
        this.beginAt("/testPage.html");
        XPathTest.assertEquals((String)"test link", (String)this.getElementTextByXPath("//tr//a[contains(@href,\"next\")]"));
    }
}

